/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.EntityManager;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.ApplicationAdapter;
import org.keycloak.models.jpa.RealmAdapter;
import org.keycloak.models.jpa.entities.ApplicationRoleEntity;
import org.keycloak.models.jpa.entities.RealmRoleEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleAdapter
implements RoleModel {
    protected RoleEntity role;
    protected EntityManager em;
    protected RealmModel realm;

    public RoleAdapter(RealmModel realm, EntityManager em, RoleEntity role) {
        this.em = em;
        this.realm = realm;
        this.role = role;
    }

    public RoleEntity getRole() {
        return this.role;
    }

    public void setRole(RoleEntity role) {
        this.role = role;
    }

    public String getName() {
        return this.role.getName();
    }

    public String getDescription() {
        return this.role.getDescription();
    }

    public void setDescription(String description) {
        this.role.setDescription(description);
    }

    public String getId() {
        return this.role.getId();
    }

    public void setName(String name) {
        this.role.setName(name);
    }

    public boolean isComposite() {
        return this.getComposites().size() > 0;
    }

    public void addCompositeRole(RoleModel role) {
        RoleEntity entity = ((RoleAdapter)role).getRole();
        for (RoleEntity composite : this.getRole().getCompositeRoles()) {
            if (!composite.equals(entity)) continue;
            return;
        }
        this.getRole().getCompositeRoles().add(entity);
        this.em.flush();
    }

    public void removeCompositeRole(RoleModel role) {
        RoleEntity entity = ((RoleAdapter)role).getRole();
        Iterator<RoleEntity> it = this.getRole().getCompositeRoles().iterator();
        while (it.hasNext()) {
            if (!it.next().equals(entity)) continue;
            it.remove();
        }
    }

    public Set<RoleModel> getComposites() {
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        for (RoleEntity composite : this.getRole().getCompositeRoles()) {
            set.add(new RoleAdapter(this.realm, this.em, composite));
        }
        return set;
    }

    public boolean hasRole(RoleModel role) {
        if (this.equals(role)) {
            return true;
        }
        if (!this.isComposite()) {
            return false;
        }
        HashSet visited = new HashSet();
        return KeycloakModelUtils.searchFor((RoleModel)role, (RoleModel)this, visited);
    }

    public RoleContainerModel getContainer() {
        if (this.role instanceof ApplicationRoleEntity) {
            ApplicationRoleEntity entity = (ApplicationRoleEntity)this.role;
            return new ApplicationAdapter(this.realm, this.em, entity.getApplication());
        }
        if (this.role instanceof RealmRoleEntity) {
            RealmRoleEntity entity = (RealmRoleEntity)this.role;
            return new RealmAdapter(this.em, entity.getRealm());
        }
        throw new IllegalStateException("Unknown role entity type");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleAdapter that = (RoleAdapter)o;
        return this.role.equals(that.role);
    }

    public int hashCode() {
        return this.role.hashCode();
    }
}

