/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.provider.Provider;

public interface RealmProvider
extends Provider,
ClientProvider,
GroupProvider,
RoleProvider {
    public MigrationModel getMigrationModel();

    public RealmModel createRealm(String var1);

    public RealmModel createRealm(String var1, String var2);

    public RealmModel getRealm(String var1);

    public RealmModel getRealmByName(String var1);

    public ClientScopeModel getClientScopeById(String var1, RealmModel var2);

    @Deprecated
    default public List<RealmModel> getRealms() {
        return this.getRealmsStream().collect(Collectors.toList());
    }

    public Stream<RealmModel> getRealmsStream();

    @Deprecated
    default public List<RealmModel> getRealmsWithProviderType(Class<?> type) {
        return this.getRealmsWithProviderTypeStream(type).collect(Collectors.toList());
    }

    public Stream<RealmModel> getRealmsWithProviderTypeStream(Class<?> var1);

    public boolean removeRealm(String var1);

    public ClientInitialAccessModel createClientInitialAccessModel(RealmModel var1, int var2, int var3);

    public ClientInitialAccessModel getClientInitialAccessModel(RealmModel var1, String var2);

    public void removeClientInitialAccessModel(RealmModel var1, String var2);

    @Deprecated
    default public List<ClientInitialAccessModel> listClientInitialAccess(RealmModel realm) {
        return this.listClientInitialAccessStream(realm).collect(Collectors.toList());
    }

    public Stream<ClientInitialAccessModel> listClientInitialAccessStream(RealmModel var1);

    public void removeExpiredClientInitialAccess();

    public void decreaseRemainingCount(RealmModel var1, ClientInitialAccessModel var2);

    public void saveLocalizationText(RealmModel var1, String var2, String var3, String var4);

    public void saveLocalizationTexts(RealmModel var1, String var2, Map<String, String> var3);

    public boolean updateLocalizationText(RealmModel var1, String var2, String var3, String var4);

    public boolean deleteLocalizationTextsByLocale(RealmModel var1, String var2);

    public boolean deleteLocalizationText(RealmModel var1, String var2, String var3);

    public String getLocalizationTextsById(RealmModel var1, String var2, String var3);

    @Override
    public ClientModel addClient(RealmModel var1, String var2, String var3);

    @Override
    default public ClientModel addClient(RealmModel realm, String clientId) {
        return this.addClient(realm, null, clientId);
    }

    @Override
    default public List<ClientModel> getClients(RealmModel realm) {
        return this.getClients(realm, null, null);
    }

    @Override
    default public List<ClientModel> getClients(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.getClientsStream(realm, firstResult, maxResults).collect(Collectors.toList());
    }

    @Override
    default public List<ClientModel> searchClientsByClientId(String clientId, Integer firstResult, Integer maxResults, RealmModel realm) {
        return this.searchClientsByClientIdStream(realm, clientId, firstResult, maxResults).collect(Collectors.toList());
    }

    @Override
    default public ClientModel getClientByClientId(String clientId, RealmModel realm) {
        return this.getClientByClientId(realm, clientId);
    }

    @Override
    default public ClientModel getClientById(String id, RealmModel realm) {
        return this.getClientById(realm, id);
    }

    @Override
    default public boolean removeClient(String id, RealmModel realm) {
        return this.removeClient(realm, id);
    }

    @Override
    default public List<ClientModel> getAlwaysDisplayInConsoleClients(RealmModel realm) {
        return this.getAlwaysDisplayInConsoleClientsStream(realm).collect(Collectors.toList());
    }

    @Override
    public long getClientsCount(RealmModel var1);

    @Override
    default public RoleModel addRealmRole(RealmModel realm, String name) {
        return this.addRealmRole(realm, null, name);
    }

    @Override
    public RoleModel addRealmRole(RealmModel var1, String var2, String var3);

    @Override
    public RoleModel getRealmRole(RealmModel var1, String var2);

    default public RoleModel getRoleById(String id, RealmModel realm) {
        return this.getRoleById(realm, id);
    }

    @Override
    default public Set<RoleModel> getRealmRoles(RealmModel realm) {
        return this.getRealmRoles(realm, null, null);
    }

    default public Set<RoleModel> getRealmRoles(RealmModel realm, Integer first, Integer max) {
        return this.getRealmRolesStream(realm, first, max).collect(Collectors.toSet());
    }

    default public Set<RoleModel> searchForRoles(RealmModel realm, String search, Integer first, Integer max) {
        return this.searchForRolesStream(realm, search, first, max).collect(Collectors.toSet());
    }

    default public boolean removeRole(RealmModel realm, RoleModel role) {
        return this.removeRole(role);
    }

    default public RoleModel addClientRole(RealmModel realm, ClientModel client, String name) {
        return this.addClientRole(client, name);
    }

    default public RoleModel addClientRole(RealmModel realm, ClientModel client, String id, String name) {
        return this.addClientRole(client, id, name);
    }

    default public RoleModel getClientRole(RealmModel realm, ClientModel client, String name) {
        return this.getClientRole(client, name);
    }

    default public Set<RoleModel> getClientRoles(RealmModel realm, ClientModel client) {
        return this.getClientRolesStream(client).collect(Collectors.toSet());
    }

    default public Set<RoleModel> getClientRoles(RealmModel realm, ClientModel client, Integer first, Integer max) {
        return this.getClientRolesStream(client, first, max).collect(Collectors.toSet());
    }

    default public Set<RoleModel> searchForClientRoles(RealmModel realm, ClientModel client, String search, Integer first, Integer max) {
        return this.searchForClientRolesStream(client, search, first, max).collect(Collectors.toSet());
    }

    @Override
    public void moveGroup(RealmModel var1, GroupModel var2, GroupModel var3);

    @Override
    public GroupModel getGroupById(RealmModel var1, String var2);

    @Override
    default public GroupModel getGroupById(String id, RealmModel realm) {
        return this.getGroupById(realm, id);
    }

    @Override
    default public List<GroupModel> getGroups(RealmModel realm) {
        return this.getGroupsStream(realm).collect(Collectors.toList());
    }

    @Override
    public Long getGroupsCount(RealmModel var1, Boolean var2);

    @Override
    public Long getGroupsCountByNameContaining(RealmModel var1, String var2);

    @Override
    default public List<GroupModel> getGroupsByRole(RealmModel realm, RoleModel role, int firstResult, int maxResults) {
        return this.getGroupsByRoleStream(realm, role, firstResult, maxResults).collect(Collectors.toList());
    }

    @Override
    default public List<GroupModel> getTopLevelGroups(RealmModel realm) {
        return this.getTopLevelGroupsStream(realm).collect(Collectors.toList());
    }

    @Override
    default public List<GroupModel> getTopLevelGroups(RealmModel realm, Integer first, Integer max) {
        return this.getTopLevelGroupsStream(realm, first, max).collect(Collectors.toList());
    }

    @Override
    default public List<GroupModel> searchForGroupByName(RealmModel realm, String search, Integer first, Integer max) {
        return this.searchForGroupByNameStream(realm, search, first, max).collect(Collectors.toList());
    }

    @Override
    public boolean removeGroup(RealmModel var1, GroupModel var2);

    @Override
    default public GroupModel createGroup(RealmModel realm, String name) {
        return this.createGroup(realm, null, name, null);
    }

    @Override
    default public GroupModel createGroup(RealmModel realm, String id, String name) {
        return this.createGroup(realm, id, name, null);
    }

    @Override
    default public GroupModel createGroup(RealmModel realm, String name, GroupModel toParent) {
        return this.createGroup(realm, null, name, toParent);
    }

    @Override
    public GroupModel createGroup(RealmModel var1, String var2, String var3, GroupModel var4);

    @Override
    public void addTopLevelGroup(RealmModel var1, GroupModel var2);
}

