/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.Provider;
import org.keycloak.storage.user.UserBulkUpdateProvider;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;

public interface UserProvider
extends Provider,
UserLookupProvider,
UserQueryProvider,
UserRegistrationProvider,
UserBulkUpdateProvider {
    public void addFederatedIdentity(RealmModel var1, UserModel var2, FederatedIdentityModel var3);

    public boolean removeFederatedIdentity(RealmModel var1, UserModel var2, String var3);

    public void preRemove(RealmModel var1, IdentityProviderModel var2);

    public void updateFederatedIdentity(RealmModel var1, UserModel var2, FederatedIdentityModel var3);

    @Deprecated
    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel var1, RealmModel var2);

    default public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(UserModel user, RealmModel realm) {
        Set<FederatedIdentityModel> value = this.getFederatedIdentities(user, realm);
        return value != null ? value.stream() : Stream.empty();
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel var1, String var2, RealmModel var3);

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel var1, RealmModel var2);

    public void addConsent(RealmModel var1, String var2, UserConsentModel var3);

    public UserConsentModel getConsentByClient(RealmModel var1, String var2, String var3);

    @Deprecated
    public List<UserConsentModel> getConsents(RealmModel var1, String var2);

    default public Stream<UserConsentModel> getConsentsStream(RealmModel realm, String userId) {
        List<UserConsentModel> value = this.getConsents(realm, userId);
        return value != null ? value.stream() : Stream.empty();
    }

    public void updateConsent(RealmModel var1, String var2, UserConsentModel var3);

    public boolean revokeConsentForClient(RealmModel var1, String var2, String var3);

    public void setNotBeforeForUser(RealmModel var1, UserModel var2, int var3);

    public int getNotBeforeOfUser(RealmModel var1, UserModel var2);

    public UserModel getServiceAccount(ClientModel var1);

    @Deprecated
    public List<UserModel> getUsers(RealmModel var1, boolean var2);

    default public Stream<UserModel> getUsersStream(RealmModel realm, boolean includeServiceAccounts) {
        List<UserModel> value = this.getUsers(realm, includeServiceAccounts);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> getUsers(RealmModel var1, int var2, int var3, boolean var4);

    default public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults, boolean includeServiceAccounts) {
        List<UserModel> value = this.getUsers(realm, firstResult == null ? -1 : firstResult, maxResults == null ? -1 : maxResults, includeServiceAccounts);
        return value != null ? value.stream() : Stream.empty();
    }

    public UserModel addUser(RealmModel var1, String var2, String var3, boolean var4, boolean var5);

    public void preRemove(RealmModel var1);

    public void removeImportedUsers(RealmModel var1, String var2);

    public void unlinkUsers(RealmModel var1, String var2);

    public void preRemove(RealmModel var1, RoleModel var2);

    public void preRemove(RealmModel var1, GroupModel var2);

    public void preRemove(RealmModel var1, ClientModel var2);

    public void preRemove(ProtocolMapperModel var1);

    public void preRemove(ClientScopeModel var1);

    @Override
    public void close();

    public void preRemove(RealmModel var1, ComponentModel var2);

    public static interface Streams
    extends UserProvider,
    UserQueryProvider.Streams {
        @Override
        default public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
            return this.getFederatedIdentitiesStream(user, realm).collect(Collectors.toSet());
        }

        @Override
        public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(UserModel var1, RealmModel var2);

        @Override
        default public List<UserConsentModel> getConsents(RealmModel realm, String userId) {
            return this.getConsentsStream(realm, userId).collect(Collectors.toList());
        }

        @Override
        public Stream<UserConsentModel> getConsentsStream(RealmModel var1, String var2);

        @Override
        default public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
            return this.getUsersStream(realm, includeServiceAccounts).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> getUsersStream(RealmModel var1, boolean var2);

        @Override
        default public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
            return this.getUsersStream(realm, firstResult, maxResults, includeServiceAccounts).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> getUsersStream(RealmModel var1, Integer var2, Integer var3, boolean var4);
    }
}

