/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.flows;

import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.flows.ErrorFlows;
import org.keycloak.services.resources.flows.OAuthFlows;
import org.keycloak.services.resources.flows.SocialRedirectFlows;
import org.keycloak.social.SocialProvider;

public class Flows {
    private Flows() {
    }

    public static LoginFormsProvider forms(KeycloakSession session, RealmModel realm, ClientModel client, UriInfo uriInfo) {
        return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setRealm(realm).setUriInfo(uriInfo).setClient(client);
    }

    public static OAuthFlows oauth(KeycloakSession session, RealmModel realm, HttpRequest request, UriInfo uriInfo, ClientConnection clientConnection, AuthenticationManager authManager, TokenManager tokenManager) {
        return new OAuthFlows(session, realm, request, uriInfo, clientConnection, authManager, tokenManager);
    }

    public static SocialRedirectFlows social(RealmModel realm, UriInfo uriInfo, ClientConnection clientConnection, SocialProvider provider) {
        return new SocialRedirectFlows(realm, uriInfo, clientConnection, provider);
    }

    public static ErrorFlows errors() {
        return new ErrorFlows();
    }
}

