/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public abstract class AbstractLoginProtocolFactory
implements LoginProtocolFactory {
    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof RealmModel.ClientCreationEvent) {
                    ClientModel client = ((RealmModel.ClientCreationEvent)event).getCreatedClient();
                    AbstractLoginProtocolFactory.this.addDefaults(client);
                }
            }
        });
    }

    protected abstract void addDefaults(ClientModel var1);

    public void close() {
    }
}

