/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ClientRoleMappingsResource;
import org.keycloak.services.resources.admin.RealmAuth;

public class RoleMapperResource {
    protected static final Logger logger = Logger.getLogger(RoleMapperResource.class);
    protected RealmModel realm;
    private RealmAuth auth;
    private RoleMapperModel roleMapper;
    private AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;
    @Context
    protected BruteForceProtector protector;

    public RoleMapperResource(RealmModel realm, RealmAuth auth, RoleMapperModel roleMapper, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
        this.roleMapper = roleMapper;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public MappingsRepresentation getRoleMappings() {
        List clients;
        this.auth.requireView();
        MappingsRepresentation all = new MappingsRepresentation();
        Set realmMappings = this.roleMapper.getRoleMappings();
        RealmManager manager = new RealmManager(this.session);
        if (realmMappings.size() > 0) {
            ArrayList<RoleRepresentation> realmRep = new ArrayList<RoleRepresentation>();
            for (RoleModel roleModel : realmMappings) {
                realmRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
            }
            all.setRealmMappings(realmRep);
        }
        if ((clients = this.realm.getClients()).size() > 0) {
            HashMap<String, ClientMappingsRepresentation> appMappings = new HashMap<String, ClientMappingsRepresentation>();
            for (ClientModel client : clients) {
                Set roleMappings = this.roleMapper.getClientRoleMappings(client);
                if (roleMappings.size() <= 0) continue;
                ClientMappingsRepresentation mappings = new ClientMappingsRepresentation();
                mappings.setId(client.getId());
                mappings.setClient(client.getClientId());
                ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
                mappings.setMappings(roles);
                for (RoleModel role : roleMappings) {
                    roles.add(ModelToRepresentation.toRepresentation((RoleModel)role));
                }
                appMappings.put(client.getClientId(), mappings);
                all.setClientMappings(appMappings);
            }
        }
        return all;
    }

    @Path(value="realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getRealmRoleMappings() {
        this.auth.requireView();
        Set realmMappings = this.roleMapper.getRealmRoleMappings();
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : realmMappings) {
            realmMappingsRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="realm/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeRealmRoleMappings() {
        this.auth.requireView();
        Set roles = this.realm.getRoles();
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (!this.roleMapper.hasRole(roleModel)) continue;
            realmMappingsRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="realm/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableRealmRoleMappings() {
        this.auth.requireView();
        Set available = this.realm.getRoles();
        return ClientRoleMappingsResource.getAvailableRoles(this.roleMapper, available);
    }

    @Path(value="realm")
    @POST
    @Consumes(value={"application/json"})
    public void addRealmRoleMappings(List<RoleRepresentation> roles) {
        this.auth.requireManage();
        logger.debugv("** addRealmRoleMappings: {0}", roles);
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.realm.getRole(role.getName());
            if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                throw new NotFoundException("Role not found");
            }
            this.roleMapper.grantRole(roleModel);
            this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, role.getId()).representation(roles).success();
        }
    }

    @Path(value="realm")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteRealmRoleMappings(List<RoleRepresentation> roles) {
        this.auth.requireManage();
        logger.debug((Object)"deleteRealmRoleMappings");
        if (roles == null) {
            Set roleModels = this.roleMapper.getRealmRoleMappings();
            for (RoleModel roleModel : roleModels) {
                this.roleMapper.deleteRoleMapping(roleModel);
            }
            this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(roles).success();
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.roleMapper.deleteRoleMapping(roleModel);
                this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo, role.getId()).representation(roles).success();
            }
        }
    }

    @Path(value="clients/{client}")
    public ClientRoleMappingsResource getUserClientRoleMappingsResource(@PathParam(value="client") String client) {
        ClientModel clientModel = this.realm.getClientById(client);
        if (clientModel == null) {
            throw new NotFoundException("Client not found");
        }
        return new ClientRoleMappingsResource(this.uriInfo, this.realm, this.auth, this.roleMapper, clientModel, this.adminEvent);
    }
}

