/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PolicyEvaluationService;
import org.keycloak.authorization.admin.representation.PolicyProviderRepresentation;
import org.keycloak.authorization.admin.representation.PolicyRepresentation;
import org.keycloak.authorization.admin.util.Models;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.services.resources.admin.RealmAuth;

public class PolicyService {
    private final ResourceServer resourceServer;
    private final AuthorizationProvider authorization;
    private final RealmAuth auth;

    public PolicyService(ResourceServer resourceServer, AuthorizationProvider authorization, RealmAuth auth) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(PolicyRepresentation representation) {
        this.auth.requireManage();
        Policy policy = Models.toModel(representation, this.resourceServer, this.authorization);
        this.updateResources(policy, this.authorization);
        this.updateAssociatedPolicies(policy);
        this.updateScopes(policy, this.authorization);
        PolicyProviderAdminService resource = this.getPolicyProviderAdminResource(policy.getType(), this.authorization);
        if (resource != null) {
            try {
                resource.onCreate(policy);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        representation.setId(policy.getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)representation).build();
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="id") String id, PolicyRepresentation representation) {
        this.auth.requireManage();
        representation.setId(id);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Policy policy = storeFactory.getPolicyStore().findById(representation.getId());
        if (policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        policy.setName(representation.getName());
        policy.setDescription(representation.getDescription());
        policy.setConfig(representation.getConfig());
        policy.setDecisionStrategy(representation.getDecisionStrategy());
        policy.setLogic(representation.getLogic());
        this.updateResources(policy, this.authorization);
        this.updateAssociatedPolicies(policy);
        this.updateScopes(policy, this.authorization);
        PolicyProviderAdminService resource = this.getPolicyProviderAdminResource(policy.getType(), this.authorization);
        if (resource != null) {
            try {
                resource.onUpdate(policy);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @Path(value="{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        this.auth.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        Policy policy = policyStore.findById(id);
        if (policy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PolicyProviderAdminService resource = this.getPolicyProviderAdminResource(policy.getType(), this.authorization);
        if (resource != null) {
            try {
                resource.onRemove(policy);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        policyStore.findDependentPolicies(id).forEach(dependentPolicy -> dependentPolicy.removeAssociatedPolicy(policy));
        policyStore.delete(policy.getId());
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="id") String id) {
        this.auth.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Policy model = storeFactory.getPolicyStore().findById(id);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)Models.toRepresentation(model, this.authorization)).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response findAll() {
        this.auth.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        return Response.ok(storeFactory.getPolicyStore().findByResourceServer(this.resourceServer.getId()).stream().map(policy -> Models.toRepresentation(policy, this.authorization)).collect(Collectors.toList())).build();
    }

    @Path(value="providers")
    @GET
    @Produces(value={"application/json"})
    public Response findPolicyProviders() {
        this.auth.requireView();
        return Response.ok(this.authorization.getProviderFactories().stream().map(provider -> {
            PolicyProviderRepresentation representation = new PolicyProviderRepresentation();
            representation.setName(provider.getName());
            representation.setGroup(provider.getGroup());
            representation.setType(provider.getId());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="evaluate")
    public PolicyEvaluationService getPolicyEvaluateResource() {
        this.auth.requireView();
        PolicyEvaluationService resource = new PolicyEvaluationService(this.resourceServer, this.authorization);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="{policyType}")
    public Object getPolicyTypeResource(@PathParam(value="policyType") String policyType) {
        this.auth.requireView();
        return this.getPolicyProviderAdminResource(policyType, this.authorization);
    }

    private PolicyProviderAdminService getPolicyProviderAdminResource(String policyType, AuthorizationProvider authorization) {
        PolicyProviderFactory providerFactory = authorization.getProviderFactory(policyType);
        if (providerFactory != null) {
            return providerFactory.getAdminResource(this.resourceServer);
        }
        return null;
    }

    private void updateScopes(Policy policy, AuthorizationProvider authorization) {
        String scopes = (String)policy.getConfig().get("scopes");
        if (scopes != null) {
            String[] scopeIds;
            try {
                scopeIds = (String[])new ObjectMapper().readValue(scopes, String[].class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            StoreFactory storeFactory = authorization.getStoreFactory();
            PolicyStore policyStore = storeFactory.getPolicyStore();
            for (String scopeId : scopeIds) {
                boolean hasScope = false;
                for (Scope scopeModel : new HashSet(policy.getScopes())) {
                    if (!scopeModel.getId().equals(scopeId)) continue;
                    hasScope = true;
                }
                if (hasScope) continue;
                policy.addScope(storeFactory.getScopeStore().findById(scopeId));
            }
            for (Scope scopeModel : new HashSet(policy.getScopes())) {
                boolean hasScope = false;
                for (String scopeId : scopeIds) {
                    if (!scopeModel.getId().equals(scopeId)) continue;
                    hasScope = true;
                }
                if (hasScope) continue;
                policy.removeScope(scopeModel);
            }
        }
    }

    private void updateAssociatedPolicies(Policy policy) {
        String policies = (String)policy.getConfig().get("applyPolicies");
        if (policies != null) {
            String[] policyIds;
            try {
                policyIds = (String[])new ObjectMapper().readValue(policies, String[].class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            StoreFactory storeFactory = this.authorization.getStoreFactory();
            PolicyStore policyStore = storeFactory.getPolicyStore();
            for (String policyId : policyIds) {
                boolean hasPolicy = false;
                for (Policy policyModel : new HashSet(policy.getAssociatedPolicies())) {
                    if (!policyModel.getId().equals(policyId)) continue;
                    hasPolicy = true;
                }
                if (hasPolicy) continue;
                Policy associatedPolicy = policyStore.findById(policyId);
                if (associatedPolicy == null) {
                    associatedPolicy = policyStore.findByName(policyId, this.resourceServer.getId());
                }
                policy.addAssociatedPolicy(associatedPolicy);
            }
            for (Policy policyModel : new HashSet(policy.getAssociatedPolicies())) {
                boolean hasPolicy = false;
                for (String policyId : policyIds) {
                    if (!policyModel.getId().equals(policyId) && !policyModel.getName().equals(policyId)) continue;
                    hasPolicy = true;
                }
                if (hasPolicy) continue;
                policy.removeAssociatedPolicy(policyModel);
            }
        }
    }

    private void updateResources(Policy policy, AuthorizationProvider authorization) {
        String resources = (String)policy.getConfig().get("resources");
        if (resources != null) {
            String[] resourceIds;
            try {
                resourceIds = (String[])new ObjectMapper().readValue(resources, String[].class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            StoreFactory storeFactory = authorization.getStoreFactory();
            for (String resourceId : resourceIds) {
                boolean hasResource = false;
                for (Resource resourceModel : new HashSet(policy.getResources())) {
                    if (!resourceModel.getId().equals(resourceId)) continue;
                    hasResource = true;
                }
                if (hasResource || "".equals(resourceId)) continue;
                policy.addResource(storeFactory.getResourceStore().findById(resourceId));
            }
            for (Resource resourceModel : new HashSet(policy.getResources())) {
                boolean hasResource = false;
                for (String resourceId : resourceIds) {
                    if (!resourceModel.getId().equals(resourceId)) continue;
                    hasResource = true;
                }
                if (hasResource) continue;
                policy.removeResource(resourceModel);
            }
        }
    }
}

