/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin.representation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.admin.representation.PolicyEvaluationRequest;
import org.keycloak.authorization.admin.representation.PolicyRepresentation;
import org.keycloak.authorization.admin.representation.ResourceRepresentation;
import org.keycloak.authorization.admin.representation.ScopeRepresentation;
import org.keycloak.authorization.admin.util.Models;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.representations.authorization.Permission;

public class PolicyEvaluationResponse {
    private List<EvaluationResultRepresentation> results;
    private boolean entitlements;
    private Decision.Effect status;

    private PolicyEvaluationResponse() {
    }

    public static PolicyEvaluationResponse build(PolicyEvaluationRequest evaluationRequest, List<Result> results, ResourceServer resourceServer, final AuthorizationProvider authorization) {
        PolicyEvaluationResponse response = new PolicyEvaluationResponse();
        ArrayList<EvaluationResultRepresentation> resultsRep = new ArrayList<EvaluationResultRepresentation>();
        response.entitlements = evaluationRequest.isEntitlements();
        if (response.entitlements) {
            List<Permission> entitlements = Permissions.allPermits(results);
            if (entitlements.isEmpty()) {
                response.status = Decision.Effect.DENY;
            } else {
                StoreFactory storeFactory = authorization.getStoreFactory();
                for (Permission permission : entitlements) {
                    EvaluationResultRepresentation rep = new EvaluationResultRepresentation();
                    rep.setStatus(Decision.Effect.PERMIT);
                    resultsRep.add(rep);
                    Resource resource = storeFactory.getResourceStore().findById(permission.getResourceSetId());
                    if (resource != null) {
                        rep.setResource(Models.toRepresentation(resource, resourceServer, authorization));
                    } else {
                        ResourceRepresentation representation = new ResourceRepresentation();
                        representation.setName("Any Resource with Scopes " + permission.getScopes());
                        rep.setResource(representation);
                    }
                    rep.setScopes(permission.getScopes().stream().map(ScopeRepresentation::new).collect(Collectors.toList()));
                }
            }
        } else {
            response.status = results.stream().anyMatch(evaluationResult -> evaluationResult.getEffect().equals((Object)Decision.Effect.DENY)) ? Decision.Effect.DENY : Decision.Effect.PERMIT;
            for (Result result : results) {
                EvaluationResultRepresentation rep = new EvaluationResultRepresentation();
                rep.setStatus(result.getEffect());
                resultsRep.add(rep);
                if (result.getPermission().getResource() != null) {
                    rep.setResource(Models.toRepresentation(result.getPermission().getResource(), resourceServer, authorization));
                } else {
                    ResourceRepresentation resource = new ResourceRepresentation();
                    resource.setName("Any Resource with Scopes " + result.getPermission().getScopes());
                    rep.setResource(resource);
                }
                rep.setScopes(result.getPermission().getScopes().stream().map(new Function<Scope, ScopeRepresentation>(){

                    @Override
                    public ScopeRepresentation apply(Scope scope) {
                        return Models.toRepresentation(scope, authorization);
                    }
                }).collect(Collectors.toList()));
                ArrayList<PolicyResultRepresentation> policies = new ArrayList<PolicyResultRepresentation>();
                for (Result.PolicyResult policy : result.getResults()) {
                    policies.add(PolicyEvaluationResponse.toRepresentation(policy, authorization));
                }
                rep.setPolicies(policies);
            }
        }
        response.results = resultsRep;
        return response;
    }

    private static PolicyResultRepresentation toRepresentation(Result.PolicyResult policy, AuthorizationProvider authorization) {
        PolicyResultRepresentation policyResultRep = new PolicyResultRepresentation();
        policyResultRep.setPolicy(Models.toRepresentation(policy.getPolicy(), authorization));
        policyResultRep.setStatus(policy.getStatus());
        policyResultRep.setAssociatedPolicies(policy.getAssociatedPolicies().stream().map(result -> PolicyEvaluationResponse.toRepresentation(result, authorization)).collect(Collectors.toList()));
        return policyResultRep;
    }

    public List<EvaluationResultRepresentation> getResults() {
        return this.results;
    }

    public Decision.Effect getStatus() {
        return this.status;
    }

    public boolean isEntitlements() {
        return this.entitlements;
    }

    public static class PolicyResultRepresentation {
        private PolicyRepresentation policy;
        private Decision.Effect status;
        private List<PolicyResultRepresentation> associatedPolicies;

        public PolicyRepresentation getPolicy() {
            return this.policy;
        }

        public void setPolicy(PolicyRepresentation policy) {
            this.policy = policy;
        }

        public Decision.Effect getStatus() {
            return this.status;
        }

        public void setStatus(Decision.Effect status) {
            this.status = status;
        }

        public List<PolicyResultRepresentation> getAssociatedPolicies() {
            return this.associatedPolicies;
        }

        public void setAssociatedPolicies(List<PolicyResultRepresentation> associatedPolicies) {
            this.associatedPolicies = associatedPolicies;
        }
    }

    public static class EvaluationResultRepresentation {
        private ResourceRepresentation resource;
        private List<ScopeRepresentation> scopes;
        private List<PolicyResultRepresentation> policies;
        private Decision.Effect status;

        public void setResource(ResourceRepresentation resource) {
            this.resource = resource;
        }

        public ResourceRepresentation getResource() {
            return this.resource;
        }

        public void setScopes(List<ScopeRepresentation> scopes) {
            this.scopes = scopes;
        }

        public List<ScopeRepresentation> getScopes() {
            return this.scopes;
        }

        public void setPolicies(List<PolicyResultRepresentation> policies) {
            this.policies = policies;
        }

        public List<PolicyResultRepresentation> getPolicies() {
            return this.policies;
        }

        public void setStatus(Decision.Effect status) {
            this.status = status;
        }

        public Decision.Effect getStatus() {
            return this.status;
        }
    }
}

