/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.authorization;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.admin.representation.ScopeRepresentation;
import org.keycloak.authorization.authorization.representation.AuthorizationRequest;
import org.keycloak.authorization.authorization.representation.AuthorizationResponse;
import org.keycloak.authorization.common.KeycloakEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.protection.permission.PermissionTicket;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.authorization.Permission;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.Cors;

public class AuthorizationTokenService {
    private final AuthorizationProvider authorization;
    @Context
    private HttpRequest httpRequest;

    public AuthorizationTokenService(AuthorizationProvider authorization) {
        this.authorization = authorization;
    }

    @OPTIONS
    public Response authorizepPreFlight() {
        return Cors.add(this.httpRequest, Response.ok()).auth().preflight().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void authorize(AuthorizationRequest authorizationRequest, final @Suspended AsyncResponse asyncResponse) {
        KeycloakEvaluationContext evaluationContext = new KeycloakEvaluationContext(this.authorization.getKeycloakSession());
        final KeycloakIdentity identity = (KeycloakIdentity)evaluationContext.getIdentity();
        if (!identity.hasRole("uma_authorization")) {
            throw new ErrorResponseException("invalid_grant", "Requires uma_authorization scope.", Response.Status.FORBIDDEN);
        }
        if (authorizationRequest == null) {
            throw new ErrorResponseException("invalid_request", "Invalid authorization request.", Response.Status.BAD_REQUEST);
        }
        PermissionTicket ticket = this.verifyPermissionTicket(authorizationRequest);
        this.authorization.evaluators().from(this.createPermissions(ticket, authorizationRequest, this.authorization), (EvaluationContext)evaluationContext).evaluate((Decision)new DecisionResultCollector(){

            public void onComplete(List<Result> results) {
                List<Permission> entitlements = Permissions.allPermits(results);
                if (entitlements.isEmpty()) {
                    asyncResponse.resume((Object)Cors.add(AuthorizationTokenService.this.httpRequest, Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorResponseException("not_authorized", "Authorization denied.", Response.Status.FORBIDDEN))).allowedOrigins(identity.getAccessToken()).exposedHeaders("Access-Control-Allow-Methods").build());
                } else {
                    AuthorizationResponse response = new AuthorizationResponse(AuthorizationTokenService.this.createRequestingPartyToken(entitlements, identity.getAccessToken()));
                    asyncResponse.resume((Object)Cors.add(AuthorizationTokenService.this.httpRequest, Response.status((Response.Status)Response.Status.CREATED).entity((Object)response)).allowedOrigins(identity.getAccessToken()).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build());
                }
            }

            public void onError(Throwable cause) {
                asyncResponse.resume(cause);
            }
        });
    }

    private List<ResourcePermission> createPermissions(PermissionTicket ticket, AuthorizationRequest request, AuthorizationProvider authorization) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        HashMap permissionsToEvaluate = new HashMap();
        ticket.getResources().forEach(requestedResource -> {
            Resource resource = requestedResource.getId() != null ? storeFactory.getResourceStore().findById(requestedResource.getId()) : storeFactory.getResourceStore().findByName(requestedResource.getName(), ticket.getResourceServerId());
            if (resource == null) {
                throw new ErrorResponseException("invalid_resource", "Resource with id [" + requestedResource.getId() + "] or name [" + requestedResource.getName() + "] does not exist.", Response.Status.FORBIDDEN);
            }
            Set<ScopeRepresentation> requestedScopes = requestedResource.getScopes();
            permissionsToEvaluate.put(resource.getId(), requestedScopes.stream().map(ScopeRepresentation::getName).collect(Collectors.toSet()));
        });
        String rpt = request.getRpt();
        if (rpt != null && !"".equals(rpt)) {
            List permissions;
            AccessToken.Authorization authorizationData;
            AccessToken requestingPartyToken;
            if (!Tokens.verifySignature(rpt, this.getRealm().getPublicKey())) {
                throw new ErrorResponseException("invalid_rpt", "RPT signature is invalid", Response.Status.FORBIDDEN);
            }
            try {
                requestingPartyToken = (AccessToken)new JWSInput(rpt).readJsonContent(AccessToken.class);
            }
            catch (JWSInputException e) {
                throw new ErrorResponseException("invalid_rpt", "Invalid RPT", Response.Status.FORBIDDEN);
            }
            if (requestingPartyToken.isActive() && (authorizationData = requestingPartyToken.getAuthorization()) != null && (permissions = authorizationData.getPermissions()) != null) {
                permissions.forEach(permission -> {
                    Resource resourcePermission = storeFactory.getResourceStore().findById(permission.getResourceSetId());
                    if (resourcePermission != null) {
                        Set scopePermission;
                        HashSet scopes = (HashSet)permissionsToEvaluate.get(resourcePermission.getId());
                        if (scopes == null) {
                            scopes = new HashSet();
                            permissionsToEvaluate.put(resourcePermission.getId(), scopes);
                        }
                        if ((scopePermission = permission.getScopes()) != null) {
                            scopes.addAll(scopePermission);
                        }
                    }
                });
            }
        }
        return permissionsToEvaluate.entrySet().stream().flatMap(entry -> {
            Resource entryResource = storeFactory.getResourceStore().findById((String)entry.getKey());
            if (((Set)entry.getValue()).isEmpty()) {
                return Arrays.asList(new ResourcePermission(entryResource, Collections.emptyList(), entryResource.getResourceServer())).stream();
            }
            return ((Set)entry.getValue()).stream().map(scopeName -> storeFactory.getScopeStore().findByName(scopeName, entryResource.getResourceServer().getId())).filter(scope -> scope != null).map(scope -> new ResourcePermission(entryResource, Arrays.asList(scope), entryResource.getResourceServer()));
        }).collect(Collectors.toList());
    }

    private RealmModel getRealm() {
        return this.authorization.getKeycloakSession().getContext().getRealm();
    }

    private String createRequestingPartyToken(List<Permission> permissions, AccessToken accessToken) {
        AccessToken.Authorization authorization = new AccessToken.Authorization();
        authorization.setPermissions(permissions);
        accessToken.setAuthorization(authorization);
        return new TokenManager().encodeToken(this.getRealm(), accessToken);
    }

    private PermissionTicket verifyPermissionTicket(AuthorizationRequest request) {
        String ticketString = request.getTicket();
        if (ticketString == null || !Tokens.verifySignature(ticketString, this.getRealm().getPublicKey())) {
            throw new ErrorResponseException("invalid_ticket", "Ticket verification failed", Response.Status.FORBIDDEN);
        }
        try {
            PermissionTicket ticket = (PermissionTicket)((Object)new JWSInput(ticketString).readJsonContent(PermissionTicket.class));
            if (!ticket.isActive()) {
                throw new ErrorResponseException("invalid_ticket", "Invalid permission ticket.", Response.Status.FORBIDDEN);
            }
            return ticket;
        }
        catch (JWSInputException e) {
            throw new ErrorResponseException("invalid_ticket", "Could not parse permission ticket.", Response.Status.FORBIDDEN);
        }
    }
}

