/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.permission;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.TokenIdGenerator;
import org.keycloak.authorization.admin.representation.ResourceRepresentation;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;

public class PermissionTicket
extends JsonWebToken {
    private final List<ResourceRepresentation> resources = new ArrayList<ResourceRepresentation>();
    private final String resourceServerId;

    public PermissionTicket() {
        this.resourceServerId = null;
    }

    public PermissionTicket(List<ResourceRepresentation> resources, String resourceServerId, AccessToken accessToken) {
        this.id(TokenIdGenerator.generateId());
        this.subject(accessToken.getSubject());
        this.expiration(accessToken.getExpiration());
        this.notBefore(accessToken.getNotBefore());
        this.issuedAt(accessToken.getIssuedAt());
        this.issuedFor(accessToken.getIssuedFor());
        this.resources.addAll(resources);
        this.resourceServerId = resourceServerId;
    }

    public List<ResourceRepresentation> getResources() {
        return this.resources;
    }

    public String getResourceServerId() {
        return this.resourceServerId;
    }
}

