/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PolicyService;
import org.keycloak.authorization.admin.ResourceSetService;
import org.keycloak.authorization.admin.ScopeService;
import org.keycloak.authorization.admin.util.Models;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationManager;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.util.JsonSerialization;

public class ResourceServerService {
    private final AuthorizationProvider authorization;
    private final RealmAuth auth;
    private final RealmModel realm;
    private final KeycloakSession session;
    private ResourceServer resourceServer;
    private final ClientModel client;

    public ResourceServerService(AuthorizationProvider authorization, ResourceServer resourceServer, ClientModel client, RealmAuth auth) {
        this.authorization = authorization;
        this.session = authorization.getKeycloakSession();
        this.client = client;
        this.resourceServer = resourceServer;
        this.realm = client.getRealm();
        this.auth = auth;
    }

    public void create() {
        this.auth.requireManage();
        this.resourceServer = this.authorization.getStoreFactory().getResourceServerStore().create(this.client.getId());
        this.createDefaultRoles();
        this.createDefaultPermission(this.createDefaultResource(), this.createDefaultPolicy());
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(ResourceServerRepresentation server) {
        this.auth.requireManage();
        this.resourceServer.setAllowRemoteResourceManagement(server.isAllowRemoteResourceManagement());
        this.resourceServer.setPolicyEnforcementMode(server.getPolicyEnforcementMode());
        return Response.noContent().build();
    }

    public void delete() {
        this.auth.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        String id = this.resourceServer.getId();
        resourceStore.findByResourceServer(id).forEach(resource -> resourceStore.delete(resource.getId()));
        ScopeStore scopeStore = storeFactory.getScopeStore();
        scopeStore.findByResourceServer(id).forEach(scope -> scopeStore.delete(scope.getId()));
        PolicyStore policyStore = storeFactory.getPolicyStore();
        policyStore.findByResourceServer(id).forEach(scope -> policyStore.delete(scope.getId()));
        storeFactory.getResourceServerStore().delete(id);
    }

    @GET
    @Produces(value={"application/json"})
    public Response findById() {
        this.auth.requireView();
        return Response.ok((Object)Models.toRepresentation(this.resourceServer, this.realm)).build();
    }

    @Path(value="/settings")
    @GET
    @Produces(value={"application/json"})
    public Response exportSettings() {
        this.auth.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceServerRepresentation settings = Models.toRepresentation(this.resourceServer, this.realm);
        settings.setId(null);
        settings.setName(null);
        settings.setClientId(null);
        List resources = storeFactory.getResourceStore().findByResourceServer(this.resourceServer.getId()).stream().map(resource -> {
            ResourceRepresentation rep = Models.toRepresentation(resource, this.resourceServer, this.authorization);
            if (rep.getOwner().getId().equals(this.resourceServer.getClientId())) {
                rep.setOwner(null);
            } else {
                rep.getOwner().setId(null);
            }
            rep.setId(null);
            rep.setPolicies(null);
            rep.getScopes().forEach(scopeRepresentation -> {
                scopeRepresentation.setId(null);
                scopeRepresentation.setIconUri(null);
            });
            return rep;
        }).collect(Collectors.toList());
        settings.setResources(resources);
        ArrayList policies = new ArrayList();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        policies.addAll(policyStore.findByResourceServer(this.resourceServer.getId()).stream().filter(policy -> !policy.getType().equals("resource") && !policy.getType().equals("scope")).map(policy -> this.createPolicyRepresentation(storeFactory, (Policy)policy)).collect(Collectors.toList()));
        policies.addAll(policyStore.findByResourceServer(this.resourceServer.getId()).stream().filter(policy -> policy.getType().equals("resource") || policy.getType().equals("scope")).map(policy -> this.createPolicyRepresentation(storeFactory, (Policy)policy)).collect(Collectors.toList()));
        settings.setPolicies(policies);
        List scopes = storeFactory.getScopeStore().findByResourceServer(this.resourceServer.getId()).stream().map(scope -> {
            ScopeRepresentation rep = Models.toRepresentation(scope, this.authorization);
            rep.setId(null);
            rep.setPolicies(null);
            rep.setResources(null);
            return rep;
        }).collect(Collectors.toList());
        settings.setScopes(scopes);
        return Response.ok((Object)settings).build();
    }

    @Path(value="/import")
    @POST
    @Consumes(value={"application/json"})
    public Response importSettings(@Context UriInfo uriInfo, ResourceServerRepresentation rep) throws IOException {
        this.auth.requireManage();
        this.resourceServer.setPolicyEnforcementMode(rep.getPolicyEnforcementMode());
        this.resourceServer.setAllowRemoteResourceManagement(rep.isAllowRemoteResourceManagement());
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        ScopeStore scopeStore = storeFactory.getScopeStore();
        ScopeService scopeResource = new ScopeService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)scopeResource);
        rep.getScopes().forEach(scope -> {
            Scope existing = scopeStore.findByName(scope.getName(), this.resourceServer.getId());
            if (existing != null) {
                scopeResource.update(existing.getId(), (ScopeRepresentation)scope);
            } else {
                scopeResource.create((ScopeRepresentation)scope);
            }
        });
        ResourceSetService resourceSetResource = new ResourceSetService(this.resourceServer, this.authorization, this.auth);
        rep.getResources().forEach(resourceRepresentation -> {
            Resource existing;
            UserModel user;
            ResourceOwnerRepresentation owner = resourceRepresentation.getOwner();
            if (owner == null) {
                owner = new ResourceOwnerRepresentation();
            }
            owner.setId(this.resourceServer.getClientId());
            if (owner.getName() != null && (user = this.session.users().getUserByUsername(owner.getName(), this.realm)) != null) {
                owner.setId(user.getId());
            }
            if ((existing = resourceStore.findByName(resourceRepresentation.getName(), this.resourceServer.getId())) != null) {
                resourceSetResource.update(existing.getId(), (ResourceRepresentation)resourceRepresentation);
            } else {
                resourceSetResource.create((ResourceRepresentation)resourceRepresentation);
            }
        });
        PolicyStore policyStore = storeFactory.getPolicyStore();
        PolicyService policyResource = new PolicyService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)policyResource);
        rep.getPolicies().forEach(policyRepresentation -> {
            Policy existing;
            String applyPolicies;
            String policyResources;
            String scopes;
            String users;
            Map config = policyRepresentation.getConfig();
            String roles = (String)config.get("roles");
            if (roles != null && !roles.isEmpty()) {
                try {
                    List rolesMap = (List)JsonSerialization.readValue((String)roles, List.class);
                    config.put("roles", JsonSerialization.writeValueAsString(rolesMap.stream().map(roleConfig -> {
                        RoleModel role;
                        String roleName = roleConfig.get("id").toString();
                        String clientId = null;
                        int clientIdSeparator = roleName.indexOf("/");
                        if (clientIdSeparator != -1) {
                            clientId = roleName.substring(0, clientIdSeparator);
                            roleName = roleName.substring(clientIdSeparator + 1);
                        }
                        if ((role = clientId == null ? this.realm.getRole(roleName) : this.realm.getClientByClientId(clientId).getRole(roleName)) == null) {
                            String finalRoleName = roleName;
                            role = this.realm.getClients().stream().map(clientModel -> clientModel.getRole(finalRoleName)).filter(roleModel -> roleModel != null).findFirst().orElse(null);
                        }
                        if (role == null) {
                            throw new RuntimeException("Error while importing configuration. Role [" + role + "] could not be found.");
                        }
                        roleConfig.put("id", role.getId());
                        return roleConfig;
                    }).collect(Collectors.toList())));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while exporting policy [" + policyRepresentation.getName() + "].", e);
                }
            }
            if ((users = (String)config.get("users")) != null && !users.isEmpty()) {
                try {
                    List usersMap = (List)JsonSerialization.readValue((String)users, List.class);
                    config.put("users", JsonSerialization.writeValueAsString(usersMap.stream().map(userName -> this.session.users().getUserByUsername(userName, this.realm).getId()).collect(Collectors.toList())));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while exporting policy [" + policyRepresentation.getName() + "].", e);
                }
            }
            if ((scopes = (String)config.get("scopes")) != null && !scopes.isEmpty()) {
                try {
                    List scopesMap = (List)JsonSerialization.readValue((String)scopes, List.class);
                    config.put("scopes", JsonSerialization.writeValueAsString(scopesMap.stream().map(scopeName -> {
                        Scope newScope = scopeStore.findByName(scopeName, this.resourceServer.getId());
                        if (newScope == null) {
                            throw new RuntimeException("Scope with name [" + scopeName + "] not defined.");
                        }
                        return newScope.getId();
                    }).collect(Collectors.toList())));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while exporting policy [" + policyRepresentation.getName() + "].", e);
                }
            }
            if ((policyResources = (String)config.get("resources")) != null && !policyResources.isEmpty()) {
                try {
                    List resources = (List)JsonSerialization.readValue((String)policyResources, List.class);
                    config.put("resources", JsonSerialization.writeValueAsString(resources.stream().map(resourceName -> storeFactory.getResourceStore().findByName(resourceName, this.resourceServer.getId()).getId()).collect(Collectors.toList())));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while exporting policy [" + policyRepresentation.getName() + "].", e);
                }
            }
            if ((applyPolicies = (String)config.get("applyPolicies")) != null && !applyPolicies.isEmpty()) {
                try {
                    List policies = (List)JsonSerialization.readValue((String)applyPolicies, List.class);
                    config.put("applyPolicies", JsonSerialization.writeValueAsString(policies.stream().map(policyName -> {
                        Policy policy = policyStore.findByName(policyName, this.resourceServer.getId());
                        if (policy == null) {
                            throw new RuntimeException("Policy with name [" + policyName + "] not defined.");
                        }
                        return policy.getId();
                    }).collect(Collectors.toList())));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while exporting policy [" + policyRepresentation.getName() + "].", e);
                }
            }
            if ((existing = policyStore.findByName(policyRepresentation.getName(), this.resourceServer.getId())) != null) {
                policyResource.update(existing.getId(), (PolicyRepresentation)policyRepresentation);
            } else {
                policyResource.create((PolicyRepresentation)policyRepresentation);
            }
        });
        return Response.noContent().build();
    }

    @Path(value="/resource")
    public ResourceSetService getResourceSetResource() {
        ResourceSetService resource = new ResourceSetService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="/scope")
    public ScopeService getScopeResource() {
        ScopeService resource = new ScopeService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="/policy")
    public PolicyService getPolicyResource() {
        PolicyService resource = new PolicyService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    private void createDefaultPermission(ResourceRepresentation resource, PolicyRepresentation policy) {
        PolicyRepresentation defaultPermission = new PolicyRepresentation();
        defaultPermission.setName("Default Permission");
        defaultPermission.setType("resource");
        defaultPermission.setDescription("A permission that applies to the default resource type");
        defaultPermission.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
        defaultPermission.setLogic(Logic.POSITIVE);
        HashMap<String, String> defaultPermissionConfig = new HashMap<String, String>();
        defaultPermissionConfig.put("default", "true");
        defaultPermissionConfig.put("defaultResourceType", resource.getType());
        defaultPermissionConfig.put("applyPolicies", "[\"" + policy.getName() + "\"]");
        defaultPermission.setConfig(defaultPermissionConfig);
        this.getPolicyResource().create(defaultPermission);
    }

    private PolicyRepresentation createDefaultPolicy() {
        PolicyRepresentation defaultPolicy = new PolicyRepresentation();
        defaultPolicy.setName("Default Policy");
        defaultPolicy.setDescription("A policy that grants access only for users within this realm");
        defaultPolicy.setType("js");
        defaultPolicy.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        defaultPolicy.setLogic(Logic.POSITIVE);
        HashMap<String, String> defaultPolicyConfig = new HashMap<String, String>();
        defaultPolicyConfig.put("code", "// by default, grants any permission associated with this policy\n$evaluation.grant();\n");
        defaultPolicy.setConfig(defaultPolicyConfig);
        this.getPolicyResource().create(defaultPolicy);
        return defaultPolicy;
    }

    private ResourceRepresentation createDefaultResource() {
        ResourceRepresentation defaultResource = new ResourceRepresentation();
        defaultResource.setName("Default Resource");
        defaultResource.setUri("/*");
        defaultResource.setType("urn:" + this.client.getClientId() + ":resources:default");
        this.getResourceSetResource().create(defaultResource);
        return defaultResource;
    }

    private void createDefaultRoles() {
        UserModel serviceAccount;
        RoleModel umaProtectionRole = this.client.getRole("uma_protection");
        if (umaProtectionRole == null) {
            umaProtectionRole = this.client.addRole("uma_protection");
        }
        if (!(serviceAccount = this.session.users().getServiceAccount(this.client)).hasRole(umaProtectionRole)) {
            serviceAccount.grantRole(umaProtectionRole);
        }
    }

    private PolicyRepresentation createPolicyRepresentation(StoreFactory storeFactory, Policy policy) {
        try {
            Set associatedPolicies;
            String policyResources;
            String scopes;
            String users;
            PolicyRepresentation rep = Models.toRepresentation(policy, this.authorization);
            rep.setId(null);
            rep.setDependentPolicies(null);
            Map config = rep.getConfig();
            String roles = (String)config.get("roles");
            if (roles != null && !roles.isEmpty()) {
                List rolesMap = (List)JsonSerialization.readValue((String)roles, List.class);
                config.put("roles", JsonSerialization.writeValueAsString(rolesMap.stream().map(roleMap -> {
                    roleMap.put("id", this.realm.getRoleById(roleMap.get("id").toString()).getName());
                    return roleMap;
                }).collect(Collectors.toList())));
            }
            if ((users = (String)config.get("users")) != null && !users.isEmpty()) {
                UserFederationManager userManager = this.session.users();
                List userIds = (List)JsonSerialization.readValue((String)users, List.class);
                config.put("users", JsonSerialization.writeValueAsString(userIds.stream().map(userId -> userManager.getUserById(userId, this.realm).getUsername()).collect(Collectors.toList())));
            }
            if ((scopes = (String)config.get("scopes")) != null && !scopes.isEmpty()) {
                ScopeStore scopeStore = storeFactory.getScopeStore();
                List scopeIds = (List)JsonSerialization.readValue((String)scopes, List.class);
                config.put("scopes", JsonSerialization.writeValueAsString(scopeIds.stream().map(scopeId -> scopeStore.findById(scopeId).getName()).collect(Collectors.toList())));
            }
            if ((policyResources = (String)config.get("resources")) != null && !policyResources.isEmpty()) {
                ResourceStore resourceStore = storeFactory.getResourceStore();
                List resourceIds = (List)JsonSerialization.readValue((String)policyResources, List.class);
                config.put("resources", JsonSerialization.writeValueAsString(resourceIds.stream().map(resourceId -> resourceStore.findById(resourceId).getName()).collect(Collectors.toList())));
            }
            if (!(associatedPolicies = policy.getAssociatedPolicies()).isEmpty()) {
                config.put("applyPolicies", JsonSerialization.writeValueAsString(associatedPolicies.stream().map(associated -> associated.getName()).collect(Collectors.toList())));
            }
            rep.setAssociatedPolicies(null);
            return rep;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while exporting policy [" + policy.getName() + "].", e);
        }
    }
}

