/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.Arrays;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientregistration.policy.AbstractClientRegistrationPolicyFactory;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.impl.TrustedHostClientRegistrationPolicy;

public class TrustedHostClientRegistrationPolicyFactory
extends AbstractClientRegistrationPolicyFactory {
    public static final String PROVIDER_ID = "trusted-hosts";
    public static final String TRUSTED_HOSTS = "trusted-hosts";
    public static final String HOST_SENDING_REGISTRATION_REQUEST_MUST_MATCH = "host-sending-registration-request-must-match";
    public static final String CLIENT_URIS_MUST_MATCH = "client-uris-must-match";
    private static final ProviderConfigProperty TRUSTED_HOSTS_PROPERTY = new ProviderConfigProperty("trusted-hosts", "trusted-hosts.label", "trusted-hosts.tooltip", "MultivaluedString", null);
    private static final ProviderConfigProperty HOST_SENDING_REGISTRATION_REQUEST_MUST_MATCH_PROPERTY = new ProviderConfigProperty("host-sending-registration-request-must-match", "host-sending-registration-request-must-match.label", "host-sending-registration-request-must-match.tooltip", "boolean", (Object)"true");
    private static final ProviderConfigProperty CLIENT_URIS_MUST_MATCH_PROPERTY = new ProviderConfigProperty("client-uris-must-match", "client-uris-must-match.label", "client-uris-must-match.tooltip", "boolean", (Object)"true");

    public ClientRegistrationPolicy create(KeycloakSession session, ComponentModel model) {
        return new TrustedHostClientRegistrationPolicy(session, model);
    }

    public String getHelpText() {
        return "Allows to specify from which hosts is user able to register and which redirect URIs can client use in it's configuration";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Arrays.asList(TRUSTED_HOSTS_PROPERTY, HOST_SENDING_REGISTRATION_REQUEST_MUST_MATCH_PROPERTY, CLIENT_URIS_MUST_MATCH_PROPERTY);
    }

    public String getId() {
        return "trusted-hosts";
    }

    @Override
    public void validateConfiguration(KeycloakSession session, ComponentModel config) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)config).checkBoolean(HOST_SENDING_REGISTRATION_REQUEST_MUST_MATCH_PROPERTY, true).checkBoolean(CLIENT_URIS_MUST_MATCH_PROPERTY, true);
        TrustedHostClientRegistrationPolicy policy = new TrustedHostClientRegistrationPolicy(session, config);
        if (!policy.isHostMustMatch() && !policy.isClientUrisMustMatch()) {
            throw new ComponentValidationException("At least one of hosts verification or client URIs validation must be enabled", new Object[0]);
        }
    }
}

