/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.security.Key;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.util.PemUtils;
import org.keycloak.jose.jws.AlgorithmType;
import org.keycloak.keys.RsaKeyMetadata;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;

public class KeyResource {
    private RealmModel realm;
    private KeycloakSession session;
    private RealmAuth auth;

    public KeyResource(RealmModel realm, KeycloakSession session, RealmAuth auth) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public KeysMetadataRepresentation getKeyMetadata() {
        KeysMetadataRepresentation.KeyMetadataRepresentation r;
        this.auth.requireView();
        KeyManager keystore = this.session.keys();
        KeysMetadataRepresentation keys = new KeysMetadataRepresentation();
        HashMap<String, String> active = new HashMap<String, String>();
        active.put(AlgorithmType.RSA.name(), keystore.getActiveRsaKey(this.realm).getKid());
        active.put(AlgorithmType.HMAC.name(), keystore.getActiveHmacKey(this.realm).getKid());
        keys.setActive(active);
        LinkedList<KeysMetadataRepresentation.KeyMetadataRepresentation> l = new LinkedList<KeysMetadataRepresentation.KeyMetadataRepresentation>();
        for (RsaKeyMetadata m : this.session.keys().getRsaKeys(this.realm, true)) {
            r = new KeysMetadataRepresentation.KeyMetadataRepresentation();
            r.setProviderId(m.getProviderId());
            r.setProviderPriority(m.getProviderPriority());
            r.setKid(m.getKid());
            r.setStatus(m.getStatus() != null ? m.getStatus().name() : null);
            r.setType(AlgorithmType.RSA.name());
            r.setPublicKey(PemUtils.encodeKey((Key)m.getPublicKey()));
            r.setCertificate(PemUtils.encodeCertificate((Certificate)m.getCertificate()));
            l.add(r);
        }
        for (RsaKeyMetadata m : this.session.keys().getHmacKeys(this.realm, true)) {
            r = new KeysMetadataRepresentation.KeyMetadataRepresentation();
            r.setProviderId(m.getProviderId());
            r.setProviderPriority(m.getProviderPriority());
            r.setKid(m.getKid());
            r.setStatus(m.getStatus() != null ? m.getStatus().name() : null);
            r.setType(AlgorithmType.HMAC.name());
            l.add(r);
        }
        keys.setKeys(l);
        return keys;
    }
}

