/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.Config;
import org.keycloak.KeyPairVerifier;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.exportimport.ClientDescriptionConverter;
import org.keycloak.exportimport.ClientDescriptionConverterFactory;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.partialimport.PartialImportManager;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.LDAPConnectionTestManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.UserStorageSyncManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AttackDetectionResource;
import org.keycloak.services.resources.admin.AuthenticationManagementResource;
import org.keycloak.services.resources.admin.ClientInitialAccessResource;
import org.keycloak.services.resources.admin.ClientRegistrationPolicyResource;
import org.keycloak.services.resources.admin.ClientTemplatesResource;
import org.keycloak.services.resources.admin.ClientsResource;
import org.keycloak.services.resources.admin.ComponentResource;
import org.keycloak.services.resources.admin.GroupsResource;
import org.keycloak.services.resources.admin.IdentityProvidersResource;
import org.keycloak.services.resources.admin.KeyResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleByIdResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.UserStorageProviderResource;
import org.keycloak.services.resources.admin.UsersResource;
import org.keycloak.storage.UserStorageProviderModel;

public class RealmAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmAuth auth;
    protected RealmModel realm;
    private TokenManager tokenManager;
    private AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ClientConnection connection;
    @Context
    protected HttpHeaders headers;

    public RealmAdminResource(RealmAuth auth, RealmModel realm, TokenManager tokenManager, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.tokenManager = tokenManager;
        this.adminEvent = adminEvent.realm(realm).resource(ResourceType.REALM);
        auth.init(RealmAuth.Resource.REALM);
        auth.requireAny();
    }

    @Path(value="client-description-converter")
    @Consumes(value={"application/json", "application/xml", "text/plain"})
    @POST
    @Produces(value={"application/json"})
    public ClientRepresentation convertClientDescription(String description) {
        this.auth.init(RealmAuth.Resource.CLIENT).requireManage();
        if (this.realm == null) {
            throw new NotFoundException("Realm not found.");
        }
        for (ProviderFactory factory : this.session.getKeycloakSessionFactory().getProviderFactories(ClientDescriptionConverter.class)) {
            if (!((ClientDescriptionConverterFactory)factory).isSupported(description)) continue;
            return ((ClientDescriptionConverter)factory.create(this.session)).convertToInternal(description);
        }
        throw new BadRequestException("Unsupported format");
    }

    @Path(value="attack-detection")
    public AttackDetectionResource getAttackDetection() {
        AttackDetectionResource resource = new AttackDetectionResource(this.auth, this.realm, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="clients")
    public ClientsResource getClients() {
        ClientsResource clientsResource = new ClientsResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)clientsResource);
        return clientsResource;
    }

    @Path(value="client-templates")
    public ClientTemplatesResource getClientTemplates() {
        ClientTemplatesResource clientsResource = new ClientTemplatesResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)clientsResource);
        return clientsResource;
    }

    @Path(value="clients-initial-access")
    public ClientInitialAccessResource getClientInitialAccess() {
        ClientInitialAccessResource resource = new ClientInitialAccessResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="client-registration-policy")
    public ClientRegistrationPolicyResource getClientRegistrationPolicy() {
        ClientRegistrationPolicyResource resource = new ClientRegistrationPolicyResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="components")
    public ComponentResource getComponents() {
        ComponentResource resource = new ComponentResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.uriInfo, this.realm, this.auth, (RoleContainerModel)this.realm, this.adminEvent);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RealmRepresentation getRealm() {
        if (this.auth.hasView()) {
            return ModelToRepresentation.toRepresentation((RealmModel)this.realm, (boolean)false);
        }
        this.auth.requireAny();
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm(this.realm.getName());
        if (this.auth.init(RealmAuth.Resource.IDENTITY_PROVIDER).hasView()) {
            RealmRepresentation r = ModelToRepresentation.toRepresentation((RealmModel)this.realm, (boolean)false);
            rep.setIdentityProviders(r.getIdentityProviders());
            rep.setIdentityProviderMappers(r.getIdentityProviderMappers());
        }
        return rep;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateRealm(RealmRepresentation rep) {
        this.auth.requireManage();
        logger.debug((Object)("updating realm: " + this.realm.getName()));
        if (Config.getAdminRealm().equals(this.realm.getName()) && rep.getRealm() != null && !rep.getRealm().equals(Config.getAdminRealm())) {
            return ErrorResponse.error("Can't rename master realm", Response.Status.BAD_REQUEST);
        }
        try {
            UserCache cache;
            if (!"GENERATE".equals(rep.getPublicKey()) && rep.getPrivateKey() != null && rep.getPublicKey() != null) {
                try {
                    KeyPairVerifier.verify((String)rep.getPrivateKey(), (String)rep.getPublicKey());
                }
                catch (VerificationException e) {
                    return ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
                }
            }
            if (!"GENERATE".equals(rep.getPublicKey()) && rep.getCertificate() != null) {
                try {
                    X509Certificate cert = PemUtils.decodeCertificate((String)rep.getCertificate());
                    if (cert == null) {
                        return ErrorResponse.error("Failed to decode certificate", Response.Status.BAD_REQUEST);
                    }
                }
                catch (Exception e) {
                    return ErrorResponse.error("Failed to decode certificate", Response.Status.BAD_REQUEST);
                }
            }
            boolean wasDuplicateEmailsAllowed = this.realm.isDuplicateEmailsAllowed();
            RepresentationToModel.updateRealm((RealmRepresentation)rep, (RealmModel)this.realm, (KeycloakSession)this.session);
            List federationProviders = this.realm.getUserStorageProviders();
            UserStorageSyncManager usersSyncManager = new UserStorageSyncManager();
            for (UserStorageProviderModel fedProvider : federationProviders) {
                usersSyncManager.notifyToRefreshPeriodicSync(this.session, this.realm, fedProvider, false);
            }
            this.adminEvent.operation(OperationType.UPDATE).representation(StripSecretsUtils.strip((RealmRepresentation)rep)).success();
            if (rep.isDuplicateEmailsAllowed() != null && rep.isDuplicateEmailsAllowed() != wasDuplicateEmailsAllowed && (cache = (UserCache)this.session.getProvider(UserCache.class)) != null) {
                cache.clear();
            }
            return Response.noContent().build();
        }
        catch (PatternSyntaxException e) {
            return ErrorResponse.error("Specified regex pattern(s) is invalid.", Response.Status.BAD_REQUEST);
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Realm with same name exists");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return ErrorResponse.error("Failed to update realm", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    public void deleteRealm() {
        this.auth.requireManage();
        if (!new RealmManager(this.session).removeRealm(this.realm)) {
            throw new NotFoundException("Realm doesn't exist");
        }
    }

    @Path(value="users")
    public UsersResource users() {
        UsersResource users = new UsersResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)users);
        return users;
    }

    @Path(value="user-storage")
    public UserStorageProviderResource userStorage() {
        UserStorageProviderResource fed = new UserStorageProviderResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)fed);
        return fed;
    }

    @Path(value="authentication")
    public AuthenticationManagementResource flows() {
        AuthenticationManagementResource resource = new AuthenticationManagementResource(this.realm, this.session, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="roles-by-id")
    public RoleByIdResource rolesById() {
        RoleByIdResource resource = new RoleByIdResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="push-revocation")
    @POST
    public GlobalRequestResult pushRevocation() {
        this.auth.requireManage();
        GlobalRequestResult result = new ResourceAdminManager(this.session).pushRealmRevocationPolicy(this.uriInfo.getRequestUri(), this.realm);
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).representation(result).success();
        return result;
    }

    @Path(value="logout-all")
    @POST
    public GlobalRequestResult logoutAll() {
        this.auth.init(RealmAuth.Resource.USER).requireManage();
        this.session.sessions().removeUserSessions(this.realm);
        GlobalRequestResult result = new ResourceAdminManager(this.session).logoutAll(this.uriInfo.getRequestUri(), this.realm);
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).representation(result).success();
        return result;
    }

    @Path(value="sessions/{session}")
    @DELETE
    public void deleteSession(@PathParam(value="session") String sessionId) {
        this.auth.init(RealmAuth.Resource.USER).requireManage();
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, sessionId);
        if (userSession == null) {
            throw new NotFoundException("Sesssion not found");
        }
        AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, this.uriInfo, this.connection, this.headers, true);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.USER_SESSION).resourcePath(this.uriInfo).success();
    }

    @Path(value="client-session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Map<String, String>> getClientSessionStats() {
        this.auth.requireView();
        LinkedList<Map<String, String>> data = new LinkedList<Map<String, String>>();
        for (ClientModel client : this.realm.getClients()) {
            long size = this.session.sessions().getActiveUserSessions(client.getRealm(), client);
            if (size == 0L) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", client.getId());
            map.put("clientId", client.getClientId());
            map.put("active", size + "");
            data.add(map);
        }
        return data;
    }

    @GET
    @NoCache
    @Path(value="events/config")
    @Produces(value={"application/json"})
    public RealmEventsConfigRepresentation getRealmEventsConfig() {
        this.auth.init(RealmAuth.Resource.EVENTS).requireView();
        RealmEventsConfigRepresentation config = ModelToRepresentation.toEventsConfigReprensetation((RealmModel)this.realm);
        if (config.getEnabledEventTypes() == null || config.getEnabledEventTypes().isEmpty()) {
            config.setEnabledEventTypes(new LinkedList());
            for (EventType e : EventType.values()) {
                if (!e.isSaveByDefault()) continue;
                config.getEnabledEventTypes().add(e.name());
            }
        }
        return config;
    }

    @PUT
    @Path(value="events/config")
    @Consumes(value={"application/json"})
    public void updateRealmEventsConfig(RealmEventsConfigRepresentation rep) {
        this.auth.init(RealmAuth.Resource.EVENTS).requireManage();
        logger.debug((Object)("updating realm events config: " + this.realm.getName()));
        new RealmManager(this.session).updateRealmEventsConfig(rep, this.realm);
    }

    @Path(value="events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<EventRepresentation> getEvents(@QueryParam(value="type") List<String> types, @QueryParam(value="client") String client, @QueryParam(value="user") String user, @QueryParam(value="dateFrom") String dateFrom, @QueryParam(value="dateTo") String dateTo, @QueryParam(value="ipAddress") String ipAddress, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        SimpleDateFormat df;
        this.auth.init(RealmAuth.Resource.EVENTS).requireView();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        EventQuery query = eventStore.createQuery().realm(this.realm.getId());
        if (client != null) {
            query.client(client);
        }
        if (types != null & !types.isEmpty()) {
            EventType[] t = new EventType[types.size()];
            for (int i = 0; i < t.length; ++i) {
                t[i] = EventType.valueOf((String)types.get(i));
            }
            query.type(t);
        }
        if (user != null) {
            query.user(user);
        }
        if (dateFrom != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date from = null;
            try {
                from = df.parse(dateFrom);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(From)', expected format is yyyy-MM-dd");
            }
            query.fromDate(from);
        }
        if (dateTo != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date to = null;
            try {
                to = df.parse(dateTo);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(To)', expected format is yyyy-MM-dd");
            }
            query.toDate(to);
        }
        if (ipAddress != null) {
            query.ipAddress(ipAddress);
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        } else {
            query.maxResults(100);
        }
        return this.toEventListRep(query.getResultList());
    }

    private List<EventRepresentation> toEventListRep(List<Event> events) {
        ArrayList<EventRepresentation> reps = new ArrayList<EventRepresentation>();
        for (Event event : events) {
            reps.add(ModelToRepresentation.toRepresentation((Event)event));
        }
        return reps;
    }

    @Path(value="admin-events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<AdminEventRepresentation> getEvents(@QueryParam(value="operationTypes") List<String> operationTypes, @QueryParam(value="authRealm") String authRealm, @QueryParam(value="authClient") String authClient, @QueryParam(value="authUser") String authUser, @QueryParam(value="authIpAddress") String authIpAddress, @QueryParam(value="resourcePath") String resourcePath, @QueryParam(value="dateFrom") String dateFrom, @QueryParam(value="dateTo") String dateTo, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="resourceTypes") List<String> resourceTypes) {
        SimpleDateFormat df;
        int i;
        OperationType[] t;
        this.auth.init(RealmAuth.Resource.EVENTS).requireView();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        AdminEventQuery query = eventStore.createAdminQuery().realm(this.realm.getId());
        if (authRealm != null) {
            query.authRealm(authRealm);
        }
        if (authClient != null) {
            query.authClient(authClient);
        }
        if (authUser != null) {
            query.authUser(authUser);
        }
        if (authIpAddress != null) {
            query.authIpAddress(authIpAddress);
        }
        if (resourcePath != null) {
            query.resourcePath(resourcePath);
        }
        if (operationTypes != null && !operationTypes.isEmpty()) {
            t = new OperationType[operationTypes.size()];
            for (i = 0; i < t.length; ++i) {
                t[i] = OperationType.valueOf((String)operationTypes.get(i));
            }
            query.operation(t);
        }
        if (resourceTypes != null && !resourceTypes.isEmpty()) {
            t = new ResourceType[resourceTypes.size()];
            for (i = 0; i < t.length; ++i) {
                t[i] = ResourceType.valueOf((String)resourceTypes.get(i));
            }
            query.resourceType((ResourceType[])t);
        }
        if (dateFrom != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date from = null;
            try {
                from = df.parse(dateFrom);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(From)', expected format is yyyy-MM-dd");
            }
            query.fromTime(from);
        }
        if (dateTo != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date to = null;
            try {
                to = df.parse(dateTo);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(To)', expected format is yyyy-MM-dd");
            }
            query.toTime(to);
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        } else {
            query.maxResults(100);
        }
        return this.toAdminEventRep(query.getResultList());
    }

    private List<AdminEventRepresentation> toAdminEventRep(List<AdminEvent> events) {
        ArrayList<AdminEventRepresentation> reps = new ArrayList<AdminEventRepresentation>();
        for (AdminEvent event : events) {
            reps.add(ModelToRepresentation.toRepresentation((AdminEvent)event));
        }
        return reps;
    }

    @Path(value="events")
    @DELETE
    public void clearEvents() {
        this.auth.init(RealmAuth.Resource.EVENTS).requireManage();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clear(this.realm.getId());
    }

    @Path(value="admin-events")
    @DELETE
    public void clearAdminEvents() {
        this.auth.init(RealmAuth.Resource.EVENTS).requireManage();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clearAdmin(this.realm.getId());
    }

    @Path(value="testLDAPConnection")
    @GET
    @NoCache
    public Response testLDAPConnection(@QueryParam(value="action") String action, @QueryParam(value="connectionUrl") String connectionUrl, @QueryParam(value="bindDn") String bindDn, @QueryParam(value="bindCredential") String bindCredential, @QueryParam(value="useTruststoreSpi") String useTruststoreSpi, @QueryParam(value="connectionTimeout") String connectionTimeout, @QueryParam(value="componentId") String componentId) {
        boolean result;
        this.auth.init(RealmAuth.Resource.REALM).requireManage();
        if (componentId != null && bindCredential.equals("**********")) {
            bindCredential = (String)this.realm.getComponent(componentId).getConfig().getFirst((Object)"bindCredential");
        }
        return (result = new LDAPConnectionTestManager().testLDAP(action, connectionUrl, bindDn, bindCredential, useTruststoreSpi, connectionTimeout)) ? Response.noContent().build() : ErrorResponse.error("LDAP test error", Response.Status.BAD_REQUEST);
    }

    @Path(value="identity-provider")
    public IdentityProvidersResource getIdentityProviderResource() {
        return new IdentityProvidersResource(this.realm, this.session, this.auth, this.adminEvent);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="default-groups")
    public List<GroupRepresentation> getDefaultGroups() {
        this.auth.requireView();
        LinkedList<GroupRepresentation> defaults = new LinkedList<GroupRepresentation>();
        for (GroupModel group : this.realm.getDefaultGroups()) {
            defaults.add(ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)false));
        }
        return defaults;
    }

    @PUT
    @NoCache
    @Path(value="default-groups/{groupId}")
    public void addDefaultGroup(@PathParam(value="groupId") String groupId) {
        this.auth.requireManage();
        GroupModel group = this.realm.getGroupById(groupId);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.realm.addDefaultGroup(group);
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.GROUP).resourcePath(this.uriInfo).success();
    }

    @DELETE
    @NoCache
    @Path(value="default-groups/{groupId}")
    public void removeDefaultGroup(@PathParam(value="groupId") String groupId) {
        this.auth.requireManage();
        GroupModel group = this.realm.getGroupById(groupId);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.realm.removeDefaultGroup(group);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.GROUP).resourcePath(this.uriInfo).success();
    }

    @Path(value="groups")
    public GroupsResource getGroups() {
        GroupsResource resource = new GroupsResource(this.realm, this.session, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @GET
    @Path(value="group-by-path/{path: .*}")
    @NoCache
    @Produces(value={"application/json"})
    public GroupRepresentation getGroupByPath(@PathParam(value="path") String path) {
        this.auth.requireView();
        GroupModel found = KeycloakModelUtils.findGroupByPath((RealmModel)this.realm, (String)path);
        if (found == null) {
            throw new NotFoundException("Group path does not exist");
        }
        return ModelToRepresentation.toGroupHierarchy((GroupModel)found, (boolean)true);
    }

    @Path(value="partialImport")
    @POST
    @Consumes(value={"application/json"})
    public Response partialImport(PartialImportRepresentation rep) {
        this.auth.requireManage();
        PartialImportManager partialImport = new PartialImportManager(rep, this.session, this.realm, this.adminEvent);
        return partialImport.saveResources();
    }

    @Path(value="clear-realm-cache")
    @POST
    public void clearRealmCache() {
        this.auth.requireManage();
        CacheRealmProvider cache = (CacheRealmProvider)this.session.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            cache.clear();
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Path(value="clear-user-cache")
    @POST
    public void clearUserCache() {
        this.auth.requireManage();
        UserCache cache = (UserCache)this.session.getProvider(UserCache.class);
        if (cache != null) {
            cache.clear();
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Path(value="clear-keys-cache")
    @POST
    public void clearKeysCache() {
        this.auth.requireManage();
        PublicKeyStorageProvider cache = (PublicKeyStorageProvider)this.session.getProvider(PublicKeyStorageProvider.class);
        if (cache != null) {
            cache.clearCache();
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Path(value="keys")
    public KeyResource keys() {
        KeyResource resource = new KeyResource(this.realm, this.session, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }
}

