/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ClientAuthenticationFlow;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.DefaultAuthenticationFlow;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.authentication.ForkFlowException;
import org.keycloak.authentication.FormAuthenticationFlow;
import org.keycloak.authentication.authenticators.client.ClientAuthUtil;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public class AuthenticationProcessor {
    public static final String CURRENT_AUTHENTICATION_EXECUTION = "current.authentication.execution";
    public static final String LAST_PROCESSED_EXECUTION = "last.processed.execution";
    public static final String CURRENT_FLOW_PATH = "current.flow.path";
    public static final String FORKED_FROM = "forked.from";
    public static final String BROKER_SESSION_ID = "broker.session.id";
    public static final String BROKER_USER_ID = "broker.user.id";
    protected static final Logger logger = Logger.getLogger(AuthenticationProcessor.class);
    protected RealmModel realm;
    protected UserSessionModel userSession;
    protected AuthenticationSessionModel authenticationSession;
    protected ClientConnection connection;
    protected UriInfo uriInfo;
    protected KeycloakSession session;
    protected EventBuilder event;
    protected HttpRequest request;
    protected String flowId;
    protected String flowPath;
    protected boolean browserFlow;
    protected BruteForceProtector protector;
    protected Runnable afterResetListener;
    protected FormMessage forwardedErrorMessage;
    protected FormMessage forwardedSuccessMessage;
    protected ClientModel client;
    protected Map<String, String> clientAuthAttributes = new HashMap<String, String>();

    public boolean isBrowserFlow() {
        return this.browserFlow;
    }

    public AuthenticationProcessor setBrowserFlow(boolean browserFlow) {
        this.browserFlow = browserFlow;
        return this;
    }

    public BruteForceProtector getBruteForceProtector() {
        if (this.protector == null) {
            this.protector = (BruteForceProtector)this.session.getProvider(BruteForceProtector.class);
        }
        return this.protector;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public Map<String, String> getClientAuthAttributes() {
        return this.clientAuthAttributes;
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authenticationSession;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public AuthenticationProcessor setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public AuthenticationProcessor setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
        return this;
    }

    public AuthenticationProcessor setConnection(ClientConnection connection) {
        this.connection = connection;
        return this;
    }

    public AuthenticationProcessor setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public AuthenticationProcessor setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public AuthenticationProcessor setEventBuilder(EventBuilder eventBuilder) {
        this.event = eventBuilder;
        return this;
    }

    public AuthenticationProcessor setRequest(HttpRequest request) {
        this.request = request;
        return this;
    }

    public AuthenticationProcessor setFlowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    public AuthenticationProcessor setFlowPath(String flowPath) {
        this.flowPath = flowPath;
        return this;
    }

    public AuthenticationProcessor setForwardedErrorMessage(FormMessage forwardedErrorMessage) {
        this.forwardedErrorMessage = forwardedErrorMessage;
        return this;
    }

    public AuthenticationProcessor setForwardedSuccessMessage(FormMessage forwardedSuccessMessage) {
        this.forwardedSuccessMessage = forwardedSuccessMessage;
        return this;
    }

    public String generateCode() {
        ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.getRealm(), this.getAuthenticationSession());
        this.authenticationSession.setTimestamp(Time.currentTime());
        return accessCode.getCode();
    }

    public EventBuilder newEvent() {
        this.event = new EventBuilder(this.realm, this.session, this.connection);
        return this.event;
    }

    public EventBuilder getEvent() {
        return this.event;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setAutheticatedUser(UserModel user) {
        UserModel previousUser = this.getAuthenticationSession().getAuthenticatedUser();
        if (previousUser != null && !user.getId().equals(previousUser.getId())) {
            throw new AuthenticationFlowException(AuthenticationFlowError.USER_CONFLICT);
        }
        this.validateUser(user);
        this.getAuthenticationSession().setAuthenticatedUser(user);
    }

    public void clearAuthenticatedUser() {
        this.getAuthenticationSession().setAuthenticatedUser(null);
    }

    public void logFailure() {
        UserModel user;
        String username;
        if (this.realm.isBruteForceProtected() && (username = this.authenticationSession.getAuthNote("ATTEMPTED_USERNAME")) != null && (user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)this.session, (RealmModel)this.realm, (String)username)) != null) {
            this.getBruteForceProtector().failedLogin(this.realm, user, this.connection);
        }
    }

    protected void logSuccess() {
        if (this.realm.isBruteForceProtected()) {
            String username = this.authenticationSession.getAuthNote("ATTEMPTED_USERNAME");
            if (username == null) {
                return;
            }
            UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)this.session, (RealmModel)this.realm, (String)username);
            if (user != null) {
                this.getBruteForceProtector().successfulLogin(this.realm, user, this.connection);
            }
        }
    }

    public boolean isSuccessful(AuthenticationExecutionModel model) {
        CommonClientSessionModel.ExecutionStatus status = (CommonClientSessionModel.ExecutionStatus)this.authenticationSession.getExecutionStatus().get(model.getId());
        if (status == null) {
            return false;
        }
        return status == CommonClientSessionModel.ExecutionStatus.SUCCESS;
    }

    public Response handleBrowserException(Exception failure) {
        if (failure instanceof AuthenticationFlowException) {
            AuthenticationFlowException e = (AuthenticationFlowException)((Object)failure);
            if (e.getError() == AuthenticationFlowError.INVALID_USER) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("user_not_found");
                return ErrorPage.error(this.session, "invalidUserMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.USER_DISABLED) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("user_disabled");
                return ErrorPage.error(this.session, "accountDisabledMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.USER_TEMPORARILY_DISABLED) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("user_temporarily_disabled");
                return ErrorPage.error(this.session, "invalidUserMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.INVALID_CLIENT_SESSION) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("invalid_code");
                return ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.EXPIRED_CODE) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("expired_code");
                return ErrorPage.error(this.session, "expiredCodeMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.FORK_FLOW) {
                ForkFlowException reset = (ForkFlowException)e;
                AuthenticationSessionModel clone = AuthenticationProcessor.clone(this.session, this.authenticationSession);
                clone.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
                this.setAuthenticationSession(clone);
                AuthenticationProcessor processor = new AuthenticationProcessor();
                processor.setAuthenticationSession(clone).setFlowPath("authenticate").setFlowId(this.realm.getBrowserFlow().getId()).setForwardedErrorMessage(reset.getErrorMessage()).setForwardedSuccessMessage(reset.getSuccessMessage()).setConnection(this.connection).setEventBuilder(this.event).setRealm(this.realm).setBrowserFlow(this.isBrowserFlow()).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
                CacheControlUtil.noBackButtonCacheControlHeader();
                return processor.authenticate();
            }
            ServicesLogger.LOGGER.failedAuthentication(e);
            this.event.error("invalid_user_credentials");
            return ErrorPage.error(this.session, "invalidUserMessage", new Object[0]);
        }
        ServicesLogger.LOGGER.failedAuthentication(failure);
        this.event.error("invalid_user_credentials");
        return ErrorPage.error(this.session, "unexpectedErrorHandlingRequestMessage", new Object[0]);
    }

    public Response handleClientAuthException(Exception failure) {
        if (failure instanceof AuthenticationFlowException) {
            AuthenticationFlowException e = (AuthenticationFlowException)((Object)failure);
            ServicesLogger.LOGGER.failedClientAuthentication(e);
            if (e.getError() == AuthenticationFlowError.CLIENT_NOT_FOUND) {
                this.event.error("client_not_found");
                return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Could not find client");
            }
            if (e.getError() == AuthenticationFlowError.CLIENT_DISABLED) {
                this.event.error("client_disabled");
                return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Client is not enabled");
            }
            if (e.getError() == AuthenticationFlowError.CLIENT_CREDENTIALS_SETUP_REQUIRED) {
                this.event.error("invalid_client_credentials");
                return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "unauthorized_client", e.getMessage());
            }
            this.event.error("invalid_client_credentials");
            return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "unauthorized_client", e.getError().toString() + ": " + e.getMessage());
        }
        ServicesLogger.LOGGER.errorAuthenticatingClient(failure);
        this.event.error("invalid_client_credentials");
        return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "unauthorized_client", "Unexpected error when authenticating client: " + failure.getMessage());
    }

    public AuthenticationFlow createFlowExecution(String flowId, AuthenticationExecutionModel execution) {
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowById(flowId);
        if (flow == null) {
            logger.error((Object)"Unknown flow to execute with");
            throw new AuthenticationFlowException(AuthenticationFlowError.INTERNAL_ERROR);
        }
        if (flow.getProviderId() == null || flow.getProviderId().equals("basic-flow")) {
            DefaultAuthenticationFlow flowExecution = new DefaultAuthenticationFlow(this, flow);
            return flowExecution;
        }
        if (flow.getProviderId().equals("form-flow")) {
            FormAuthenticationFlow flowExecution = new FormAuthenticationFlow(this, execution);
            return flowExecution;
        }
        if (flow.getProviderId().equals("client-flow")) {
            ClientAuthenticationFlow flowExecution = new ClientAuthenticationFlow(this, flow);
            return flowExecution;
        }
        throw new AuthenticationFlowException("Unknown flow provider type", AuthenticationFlowError.INTERNAL_ERROR);
    }

    public Response authenticate() throws AuthenticationFlowException {
        logger.debug((Object)"AUTHENTICATE");
        Response challenge = this.authenticateOnly();
        if (challenge != null) {
            return challenge;
        }
        return this.authenticationComplete();
    }

    public Response authenticateClient() throws AuthenticationFlowException {
        logger.debug((Object)"AUTHENTICATE CLIENT");
        AuthenticationFlow authenticationFlow = this.createFlowExecution(this.flowId, null);
        try {
            Response challenge = authenticationFlow.processFlow();
            return challenge;
        }
        catch (Exception e) {
            return this.handleClientAuthException(e);
        }
    }

    public Response redirectToFlow() {
        URI redirect = new AuthenticationFlowURLHelper(this.session, this.realm, this.uriInfo).getLastExecutionUrl(this.authenticationSession);
        logger.debug((Object)("Redirecting to URL: " + redirect.toString()));
        return Response.status((int)302).location(redirect).build();
    }

    public void resetFlow() {
        AuthenticationProcessor.resetFlow(this.authenticationSession, this.flowPath);
        if (this.afterResetListener != null) {
            this.afterResetListener.run();
        }
    }

    public static void resetFlow(AuthenticationSessionModel authSession, String flowPath) {
        logger.debug((Object)"RESET FLOW");
        authSession.setTimestamp(Time.currentTime());
        authSession.setAuthenticatedUser(null);
        authSession.clearExecutionStatus();
        authSession.clearUserSessionNotes();
        authSession.clearAuthNotes();
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setAuthNote(CURRENT_FLOW_PATH, flowPath);
    }

    public static AuthenticationSessionModel clone(KeycloakSession session, AuthenticationSessionModel authSession) {
        AuthenticationSessionModel clone = new AuthenticationSessionManager(session).createAuthenticationSession(authSession.getRealm(), authSession.getClient(), true);
        for (Map.Entry entry : authSession.getClientNotes().entrySet()) {
            clone.setClientNote((String)entry.getKey(), (String)entry.getValue());
        }
        clone.setRedirectUri(authSession.getRedirectUri());
        clone.setProtocol(authSession.getProtocol());
        clone.setTimestamp(Time.currentTime());
        clone.setAuthNote(FORKED_FROM, authSession.getId());
        logger.debugf("Forked authSession %s from authSession %s", (Object)clone.getId(), (Object)authSession.getId());
        return clone;
    }

    public Response authenticationAction(String execution) {
        AuthenticationFlow authenticationFlow;
        Response challenge;
        logger.debug((Object)"authenticationAction");
        this.checkClientSession(true);
        String current = this.authenticationSession.getAuthNote(CURRENT_AUTHENTICATION_EXECUTION);
        if (execution == null || !execution.equals(current)) {
            logger.debug((Object)"Current execution does not equal executed execution.  Might be a page refresh");
            return new AuthenticationFlowURLHelper(this.session, this.realm, this.uriInfo).showPageExpired(this.authenticationSession);
        }
        UserModel authUser = this.authenticationSession.getAuthenticatedUser();
        this.validateUser(authUser);
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            logger.debug((Object)"Cannot find execution, reseting flow");
            this.logFailure();
            this.resetFlow();
            return this.authenticate();
        }
        this.event.client(this.authenticationSession.getClient().getClientId()).detail("redirect_uri", this.authenticationSession.getRedirectUri()).detail("auth_method", this.authenticationSession.getProtocol());
        String authType = this.authenticationSession.getAuthNote("auth_type");
        if (authType != null) {
            this.event.detail("auth_type", authType);
        }
        if ((challenge = (authenticationFlow = this.createFlowExecution(this.flowId, model)).processAction(execution)) != null) {
            return challenge;
        }
        if (this.authenticationSession.getAuthenticatedUser() == null) {
            throw new AuthenticationFlowException(AuthenticationFlowError.UNKNOWN_USER);
        }
        return this.authenticationComplete();
    }

    private void checkClientSession(boolean checkAction) {
        String action;
        ClientSessionCode<AuthenticationSessionModel> code = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.realm, this.authenticationSession);
        if (checkAction && !code.isValidAction(action = CommonClientSessionModel.Action.AUTHENTICATE.name())) {
            throw new AuthenticationFlowException(AuthenticationFlowError.INVALID_CLIENT_SESSION);
        }
        if (!code.isActionActive(ClientSessionCode.ActionType.LOGIN)) {
            throw new AuthenticationFlowException(AuthenticationFlowError.EXPIRED_CODE);
        }
        this.authenticationSession.setTimestamp(Time.currentTime());
    }

    public Response authenticateOnly() throws AuthenticationFlowException {
        logger.debug((Object)"AUTHENTICATE ONLY");
        this.checkClientSession(false);
        this.event.client(this.authenticationSession.getClient().getClientId()).detail("redirect_uri", this.authenticationSession.getRedirectUri()).detail("auth_method", this.authenticationSession.getProtocol());
        String authType = this.authenticationSession.getAuthNote("auth_type");
        if (authType != null) {
            this.event.detail("auth_type", authType);
        }
        UserModel authUser = this.authenticationSession.getAuthenticatedUser();
        this.validateUser(authUser);
        AuthenticationFlow authenticationFlow = this.createFlowExecution(this.flowId, null);
        Response challenge = authenticationFlow.processFlow();
        if (challenge != null) {
            return challenge;
        }
        if (this.authenticationSession.getAuthenticatedUser() == null) {
            throw new AuthenticationFlowException(AuthenticationFlowError.UNKNOWN_USER);
        }
        return challenge;
    }

    public AuthenticatedClientSessionModel attachSession() {
        AuthenticatedClientSessionModel clientSession = AuthenticationProcessor.attachSession(this.authenticationSession, this.userSession, this.session, this.realm, this.connection, this.event);
        if (this.userSession == null) {
            this.userSession = clientSession.getUserSession();
        }
        return clientSession;
    }

    public static AuthenticatedClientSessionModel attachSession(AuthenticationSessionModel authSession, UserSessionModel userSession, KeycloakSession session, RealmModel realm, ClientConnection connection, EventBuilder event) {
        String rememberMe;
        String username = authSession.getAuthenticatedUser().getUsername();
        String attemptedUsername = authSession.getAuthNote("ATTEMPTED_USERNAME");
        if (attemptedUsername != null) {
            username = attemptedUsername;
        }
        boolean remember = (rememberMe = authSession.getAuthNote("remember_me")) != null && rememberMe.equalsIgnoreCase("true");
        String brokerSessionId = authSession.getAuthNote(BROKER_SESSION_ID);
        String brokerUserId = authSession.getAuthNote(BROKER_USER_ID);
        if (userSession == null) {
            userSession = session.sessions().getUserSession(realm, authSession.getId());
            if (userSession == null) {
                userSession = session.sessions().createUserSession(authSession.getId(), realm, authSession.getAuthenticatedUser(), username, connection.getRemoteAddr(), authSession.getProtocol(), remember, brokerSessionId, brokerUserId);
            } else if (userSession.getUser() == null || !AuthenticationManager.isSessionValid(realm, userSession)) {
                userSession.restartSession(realm, authSession.getAuthenticatedUser(), username, connection.getRemoteAddr(), authSession.getProtocol(), remember, brokerSessionId, brokerUserId);
            } else {
                logger.debugf("No SSO login, but found existing userSession with ID '%s' after finished authentication.", (Object)userSession.getId());
                if (!authSession.getAuthenticatedUser().equals(userSession.getUser())) {
                    event.detail("previous_user", userSession.getUser().getId());
                    event.error("different_user_authenticated");
                    throw new ErrorPageException(session, "differentUserAuthenticated", userSession.getUser().getUsername());
                }
            }
            userSession.setState(UserSessionModel.State.LOGGED_IN);
        }
        if (remember) {
            event.detail("remember_me", "true");
        }
        AuthenticatedClientSessionModel clientSession = TokenManager.attachAuthenticationSession(session, userSession, authSession);
        event.user(userSession.getUser()).detail("username", username).session(userSession);
        return clientSession;
    }

    public void evaluateRequiredActionTriggers() {
        AuthenticationManager.evaluateRequiredActionTriggers(this.session, this.authenticationSession, this.connection, this.request, this.uriInfo, this.event, this.realm, this.authenticationSession.getAuthenticatedUser());
    }

    public Response finishAuthentication(LoginProtocol protocol) {
        this.event.success();
        RealmModel realm = this.authenticationSession.getRealm();
        AuthenticatedClientSessionModel clientSession = this.attachSession();
        return AuthenticationManager.redirectAfterSuccessfulFlow(this.session, realm, this.userSession, clientSession, this.request, this.uriInfo, this.connection, this.event, protocol);
    }

    public void validateUser(UserModel authenticatedUser) {
        if (authenticatedUser == null) {
            return;
        }
        if (!authenticatedUser.isEnabled()) {
            throw new AuthenticationFlowException(AuthenticationFlowError.USER_DISABLED);
        }
        if (this.realm.isBruteForceProtected() && !this.realm.isPermanentLockout() && this.getBruteForceProtector().isTemporarilyDisabled(this.session, this.realm, authenticatedUser)) {
            throw new AuthenticationFlowException(AuthenticationFlowError.USER_TEMPORARILY_DISABLED);
        }
    }

    protected Response authenticationComplete() {
        AuthenticationManager.setRolesAndMappersInSession(this.authenticationSession);
        String nextRequiredAction = this.nextRequiredAction();
        if (nextRequiredAction != null) {
            return AuthenticationManager.redirectToRequiredActions(this.session, this.realm, this.authenticationSession, this.uriInfo, nextRequiredAction);
        }
        this.event.detail("code_id", this.authenticationSession.getId());
        this.logSuccess();
        return AuthenticationManager.finishedRequiredActions(this.session, this.authenticationSession, this.userSession, this.connection, this.request, this.uriInfo, this.event);
    }

    public String nextRequiredAction() {
        return AuthenticationManager.nextRequiredAction(this.session, this.authenticationSession, this.connection, this.request, this.uriInfo, this.event);
    }

    public Result createAuthenticatorContext(AuthenticationExecutionModel model, Authenticator authenticator, List<AuthenticationExecutionModel> executions) {
        return new Result(model, authenticator, executions);
    }

    public Result createClientAuthenticatorContext(AuthenticationExecutionModel model, ClientAuthenticator clientAuthenticator, List<AuthenticationExecutionModel> executions) {
        return new Result(model, clientAuthenticator, executions);
    }

    public class Result
    implements AuthenticationFlowContext,
    ClientAuthenticationFlowContext {
        AuthenticatorConfigModel authenticatorConfig;
        AuthenticationExecutionModel execution;
        Authenticator authenticator;
        FlowStatus status;
        ClientAuthenticator clientAuthenticator;
        Response challenge;
        AuthenticationFlowError error;
        List<AuthenticationExecutionModel> currentExecutions;
        FormMessage errorMessage;
        FormMessage successMessage;

        private Result(AuthenticationExecutionModel execution, Authenticator authenticator, List<AuthenticationExecutionModel> currentExecutions) {
            this.execution = execution;
            this.authenticator = authenticator;
            this.currentExecutions = currentExecutions;
        }

        private Result(AuthenticationExecutionModel execution, ClientAuthenticator clientAuthenticator, List<AuthenticationExecutionModel> currentExecutions) {
            this.execution = execution;
            this.clientAuthenticator = clientAuthenticator;
            this.currentExecutions = currentExecutions;
        }

        public EventBuilder newEvent() {
            return AuthenticationProcessor.this.newEvent();
        }

        public AuthenticationExecutionModel.Requirement getCategoryRequirementFromCurrentFlow(String authenticatorCategory) {
            List executions = AuthenticationProcessor.this.realm.getAuthenticationExecutions(this.execution.getParentFlow());
            for (AuthenticationExecutionModel exe : executions) {
                AuthenticatorFactory factory = (AuthenticatorFactory)this.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, exe.getAuthenticator());
                if (factory == null || !factory.getReferenceCategory().equals(authenticatorCategory)) continue;
                return exe.getRequirement();
            }
            return null;
        }

        public AuthenticationExecutionModel getExecution() {
            return this.execution;
        }

        public AuthenticatorConfigModel getAuthenticatorConfig() {
            if (this.execution.getAuthenticatorConfig() == null) {
                return null;
            }
            if (this.authenticatorConfig != null) {
                return this.authenticatorConfig;
            }
            this.authenticatorConfig = AuthenticationProcessor.this.realm.getAuthenticatorConfigById(this.execution.getAuthenticatorConfig());
            return this.authenticatorConfig;
        }

        public Authenticator getAuthenticator() {
            return this.authenticator;
        }

        public FlowStatus getStatus() {
            return this.status;
        }

        public ClientAuthenticator getClientAuthenticator() {
            return this.clientAuthenticator;
        }

        public void success() {
            this.status = FlowStatus.SUCCESS;
        }

        public void failure(AuthenticationFlowError error) {
            this.status = FlowStatus.FAILED;
            this.error = error;
        }

        public void challenge(Response challenge) {
            this.status = FlowStatus.CHALLENGE;
            this.challenge = challenge;
        }

        public void forceChallenge(Response challenge) {
            this.status = FlowStatus.FORCE_CHALLENGE;
            this.challenge = challenge;
        }

        public void failureChallenge(AuthenticationFlowError error, Response challenge) {
            this.error = error;
            this.status = FlowStatus.FAILURE_CHALLENGE;
            this.challenge = challenge;
        }

        public void failure(AuthenticationFlowError error, Response challenge) {
            this.error = error;
            this.status = FlowStatus.FAILED;
            this.challenge = challenge;
        }

        public void attempted() {
            this.status = FlowStatus.ATTEMPTED;
        }

        public UserModel getUser() {
            return this.getAuthenticationSession().getAuthenticatedUser();
        }

        public void setUser(UserModel user) {
            AuthenticationProcessor.this.setAutheticatedUser(user);
        }

        public void clearUser() {
            AuthenticationProcessor.this.clearAuthenticatedUser();
        }

        public RealmModel getRealm() {
            return AuthenticationProcessor.this.getRealm();
        }

        public ClientModel getClient() {
            return AuthenticationProcessor.this.getClient();
        }

        public void setClient(ClientModel client) {
            AuthenticationProcessor.this.setClient(client);
        }

        public Map<String, String> getClientAuthAttributes() {
            return AuthenticationProcessor.this.getClientAuthAttributes();
        }

        public AuthenticationSessionModel getAuthenticationSession() {
            return AuthenticationProcessor.this.getAuthenticationSession();
        }

        public ClientConnection getConnection() {
            return AuthenticationProcessor.this.getConnection();
        }

        public UriInfo getUriInfo() {
            return AuthenticationProcessor.this.getUriInfo();
        }

        public KeycloakSession getSession() {
            return AuthenticationProcessor.this.getSession();
        }

        public HttpRequest getHttpRequest() {
            return AuthenticationProcessor.this.request;
        }

        public void attachUserSession(UserSessionModel userSession) {
            AuthenticationProcessor.this.userSession = userSession;
        }

        public BruteForceProtector getProtector() {
            return AuthenticationProcessor.this.getBruteForceProtector();
        }

        public EventBuilder getEvent() {
            return AuthenticationProcessor.this.event;
        }

        public FormMessage getForwardedErrorMessage() {
            return AuthenticationProcessor.this.forwardedErrorMessage;
        }

        public String generateAccessCode() {
            return AuthenticationProcessor.this.generateCode();
        }

        public Response getChallenge() {
            return this.challenge;
        }

        public AuthenticationFlowError getError() {
            return this.error;
        }

        public LoginFormsProvider form() {
            String accessCode = this.generateAccessCode();
            URI action = this.getActionUrl(accessCode);
            LoginFormsProvider provider = ((LoginFormsProvider)this.getSession().getProvider(LoginFormsProvider.class)).setUser(this.getUser()).setActionUri(action).setExecution(this.getExecution().getId()).setFormData(AuthenticationProcessor.this.request.getDecodedFormParameters()).setClientSessionCode(accessCode);
            if (this.getForwardedErrorMessage() != null) {
                provider.addError(this.getForwardedErrorMessage());
            } else if (this.getForwardedSuccessMessage() != null) {
                provider.addSuccess(this.getForwardedSuccessMessage());
            }
            return provider;
        }

        public URI getActionUrl(String code) {
            return LoginActionsService.loginActionsBaseUrl(this.getUriInfo()).path(AuthenticationProcessor.this.flowPath).queryParam("code", new Object[]{code}).queryParam("execution", new Object[]{this.getExecution().getId()}).queryParam("client_id", new Object[]{this.getAuthenticationSession().getClient().getClientId()}).build(new Object[]{this.getRealm().getName()});
        }

        public URI getActionTokenUrl(String tokenString) {
            return LoginActionsService.actionTokenProcessor(this.getUriInfo()).queryParam("key", new Object[]{tokenString}).queryParam("execution", new Object[]{this.getExecution().getId()}).queryParam("client_id", new Object[]{this.getAuthenticationSession().getClient().getClientId()}).build(new Object[]{this.getRealm().getName()});
        }

        public URI getRefreshExecutionUrl() {
            return LoginActionsService.loginActionsBaseUrl(this.getUriInfo()).path(AuthenticationProcessor.this.flowPath).queryParam("execution", new Object[]{this.getExecution().getId()}).queryParam("client_id", new Object[]{this.getAuthenticationSession().getClient().getClientId()}).build(new Object[]{this.getRealm().getName()});
        }

        public void cancelLogin() {
            this.getEvent().error("rejected_by_user");
            LoginProtocol protocol = (LoginProtocol)this.getSession().getProvider(LoginProtocol.class, this.getAuthenticationSession().getProtocol());
            protocol.setRealm(this.getRealm()).setHttpHeaders(this.getHttpRequest().getHttpHeaders()).setUriInfo(this.getUriInfo()).setEventBuilder(AuthenticationProcessor.this.event);
            Response response = protocol.sendError(this.getAuthenticationSession(), LoginProtocol.Error.CANCELLED_BY_USER);
            this.forceChallenge(response);
        }

        public void resetFlow() {
            this.status = FlowStatus.FLOW_RESET;
        }

        public void resetFlow(Runnable afterResetListener) {
            this.status = FlowStatus.FLOW_RESET;
            AuthenticationProcessor.this.afterResetListener = afterResetListener;
        }

        public void fork() {
            this.status = FlowStatus.FORK;
        }

        public void forkWithSuccessMessage(FormMessage message) {
            this.status = FlowStatus.FORK;
            this.successMessage = message;
        }

        public void forkWithErrorMessage(FormMessage message) {
            this.status = FlowStatus.FORK;
            this.errorMessage = message;
        }

        public FormMessage getForwardedSuccessMessage() {
            return AuthenticationProcessor.this.forwardedSuccessMessage;
        }

        public FormMessage getErrorMessage() {
            return this.errorMessage;
        }

        public FormMessage getSuccessMessage() {
            return this.successMessage;
        }
    }
}

