/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.representation.PolicyEvaluationResponseBuilder;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.common.KeycloakEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.PolicyEvaluationRequest;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.sessions.AuthenticationSessionModel;

public class PolicyEvaluationService {
    private final AuthorizationProvider authorization;
    private final AdminPermissionEvaluator auth;
    @Context
    private HttpRequest httpRequest;
    private final ResourceServer resourceServer;

    PolicyEvaluationService(ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
    }

    public static <T> List<T> asList(T ... a) {
        LinkedList<T> list = new LinkedList<T>();
        for (T t : a) {
            list.add(t);
        }
        return list;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response evaluate(PolicyEvaluationRequest evaluationRequest) throws Throwable {
        this.auth.realm().requireViewAuthorization();
        try (CloseableKeycloakIdentity identity = this.createIdentity(evaluationRequest);){
            Response response = Response.ok((Object)PolicyEvaluationResponseBuilder.build(this.evaluate(evaluationRequest, this.createEvaluationContext(evaluationRequest, identity)), this.resourceServer, this.authorization, identity)).build();
            return response;
        }
    }

    private List<Result> evaluate(PolicyEvaluationRequest evaluationRequest, EvaluationContext evaluationContext) {
        return this.authorization.evaluators().from(this.createPermissions(evaluationRequest, evaluationContext, this.authorization), evaluationContext).evaluate();
    }

    private EvaluationContext createEvaluationContext(final PolicyEvaluationRequest representation, KeycloakIdentity identity) {
        return new KeycloakEvaluationContext(identity, this.authorization.getKeycloakSession()){

            @Override
            public Attributes getAttributes() {
                HashMap attributes = new HashMap(super.getAttributes().toMap());
                Map givenAttributes = (Map)representation.getContext().get("attributes");
                if (givenAttributes != null) {
                    givenAttributes.forEach((key, entryValue) -> {
                        if (entryValue != null) {
                            ArrayList<String> values = new ArrayList<String>();
                            for (String value : entryValue.split(",")) {
                                values.add(value);
                            }
                            attributes.put(key, values);
                        }
                    });
                }
                return Attributes.from(attributes);
            }
        };
    }

    private List<ResourcePermission> createPermissions(PolicyEvaluationRequest representation, EvaluationContext evaluationContext, AuthorizationProvider authorization) {
        List resources = representation.getResources();
        return resources.stream().flatMap(resource -> {
            HashSet givenScopes;
            StoreFactory storeFactory = authorization.getStoreFactory();
            if (resource == null) {
                resource = new ResourceRepresentation();
            }
            if ((givenScopes = resource.getScopes()) == null) {
                givenScopes = new HashSet();
            }
            Set<String> scopeNames = givenScopes.stream().map(ScopeRepresentation::getName).collect(Collectors.toSet());
            if (resource.getId() != null) {
                Resource resourceModel = storeFactory.getResourceStore().findById(resource.getId(), this.resourceServer.getId());
                return Permissions.createResourcePermissions(resourceModel, scopeNames, authorization).stream();
            }
            if (resource.getType() != null) {
                return storeFactory.getResourceStore().findByType(resource.getType(), this.resourceServer.getId()).stream().flatMap(resource1 -> Permissions.createResourcePermissions(resource1, scopeNames, authorization).stream());
            }
            ScopeStore scopeStore = storeFactory.getScopeStore();
            List scopes = scopeNames.stream().map(scopeName -> scopeStore.findByName(scopeName, this.resourceServer.getId())).collect(Collectors.toList());
            ArrayList<ResourcePermission> collect = new ArrayList<ResourcePermission>();
            if (!scopes.isEmpty()) {
                collect.addAll(scopes.stream().map(scope -> new ResourcePermission(null, PolicyEvaluationService.asList(scope), this.resourceServer)).collect(Collectors.toList()));
            } else {
                collect.addAll(Permissions.all(this.resourceServer, evaluationContext.getIdentity(), authorization));
            }
            return collect.stream();
        }).collect(Collectors.toList());
    }

    private CloseableKeycloakIdentity createIdentity(PolicyEvaluationRequest representation) {
        UserModel userModel;
        KeycloakSession keycloakSession = this.authorization.getKeycloakSession();
        RealmModel realm = keycloakSession.getContext().getRealm();
        AccessToken accessToken = null;
        String subject = representation.getUserId();
        AuthenticatedClientSessionModel clientSession = null;
        UserSessionModel userSession = null;
        if (subject != null && (userModel = keycloakSession.users().getUserById(subject, realm)) != null) {
            String clientId = representation.getClientId();
            if (clientId == null) {
                clientId = this.resourceServer.getId();
            }
            if (clientId != null) {
                ClientModel clientModel = realm.getClientById(clientId);
                String id = KeycloakModelUtils.generateId();
                AuthenticationSessionModel authSession = keycloakSession.authenticationSessions().createAuthenticationSession(id, realm, clientModel);
                authSession.setProtocol("openid-connect");
                authSession.setAuthenticatedUser(userModel);
                userSession = keycloakSession.sessions().createUserSession(id, realm, userModel, userModel.getUsername(), "127.0.0.1", "passwd", false, null, null);
                AuthenticationManager.setRolesAndMappersInSession(authSession);
                clientSession = TokenManager.attachAuthenticationSession(keycloakSession, userSession, authSession);
                HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
                for (String roleId : clientSession.getRoles()) {
                    RoleModel role = realm.getRoleById(roleId);
                    if (role == null) continue;
                    requestedRoles.add(role);
                }
                accessToken = new TokenManager().createClientAccessToken(keycloakSession, requestedRoles, realm, clientModel, userModel, userSession, clientSession);
            }
        }
        if (accessToken == null) {
            accessToken = new AccessToken();
            accessToken.subject(representation.getUserId());
            accessToken.issuedFor(representation.getClientId());
            accessToken.audience(new String[]{representation.getClientId()});
            accessToken.issuer(Urls.realmIssuer(keycloakSession.getContext().getUri().getBaseUri(), realm.getName()));
            accessToken.setRealmAccess(new AccessToken.Access());
        }
        AccessToken.Access realmAccess = accessToken.getRealmAccess();
        Map claims = accessToken.getOtherClaims();
        Map givenAttributes = (Map)representation.getContext().get("attributes");
        if (givenAttributes != null) {
            givenAttributes.forEach((key, value) -> claims.put(key, PolicyEvaluationService.asList(value)));
        }
        if (representation.getRoleIds() != null) {
            representation.getRoleIds().forEach(roleName -> realmAccess.addRole(roleName));
        }
        return new CloseableKeycloakIdentity(accessToken, keycloakSession, userSession);
    }

    private static class CloseableKeycloakIdentity
    extends KeycloakIdentity {
        private UserSessionModel userSession;

        public CloseableKeycloakIdentity(AccessToken accessToken, KeycloakSession keycloakSession, UserSessionModel userSession) {
            super(accessToken, keycloakSession);
            this.userSession = userSession;
        }

        public void close() {
            if (this.userSession != null) {
                this.keycloakSession.sessions().removeUserSession(this.realm, this.userSession);
            }
        }
    }

    static class Decision
    extends DecisionResultCollector {
        Throwable error;
        List<Result> results;

        Decision() {
        }

        protected void onComplete(List<Result> results) {
            this.results = results;
        }

        public void onError(Throwable cause) {
            this.error = cause;
        }
    }
}

