/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.authorization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.OAuthErrorException;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.common.KeycloakEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.PermissionTicketAwareDecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.common.util.Base64Url;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionTicketToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.Cors;
import org.keycloak.util.JsonSerialization;

public class AuthorizationTokenService {
    public static final String CLAIM_TOKEN_FORMAT_ID_TOKEN = "http://openid.net/specs/openid-connect-core-1_0.html#IDToken";
    private static final Logger logger = Logger.getLogger(AuthorizationTokenService.class);
    private static Map<String, BiFunction<AuthorizationRequest, AuthorizationProvider, KeycloakEvaluationContext>> SUPPORTED_CLAIM_TOKEN_FORMATS = new HashMap<String, BiFunction<AuthorizationRequest, AuthorizationProvider, KeycloakEvaluationContext>>();
    private final TokenManager tokenManager;
    private final EventBuilder event;
    private final HttpRequest httpRequest;
    private final AuthorizationProvider authorization;
    private final Cors cors;

    public AuthorizationTokenService(AuthorizationProvider authorization, TokenManager tokenManager, EventBuilder event, HttpRequest httpRequest, Cors cors) {
        this.tokenManager = tokenManager;
        this.event = event;
        this.httpRequest = httpRequest;
        this.authorization = authorization;
        this.cors = cors;
    }

    public Response authorize(AuthorizationRequest request) {
        if (request == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Invalid authorization request.", Response.Status.BAD_REQUEST);
        }
        if (this.isPublicClientRequestingEntitlemesWithClaims(request)) {
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Public clients are not allowed to send claims", Response.Status.FORBIDDEN);
        }
        try {
            PermissionTicketToken ticket = this.getPermissionTicket(request);
            request.setClaims(ticket.getClaims());
            ResourceServer resourceServer = this.getResourceServer(ticket);
            KeycloakEvaluationContext evaluationContext = this.createEvaluationContext(request);
            KeycloakIdentity identity = (KeycloakIdentity)KeycloakIdentity.class.cast(evaluationContext.getIdentity());
            List<Result> evaluation = ticket.getResources().isEmpty() && request.getRpt() == null ? this.evaluateAllPermissions(resourceServer, evaluationContext, identity) : (!request.getPermissions().getResources().isEmpty() ? this.evaluatePermissions(request, ticket, resourceServer, evaluationContext, identity) : this.evaluateUserManagedPermissions(request, ticket, resourceServer, evaluationContext, identity));
            List<Permission> permissions = Permissions.permits(evaluation, request.getMetadata(), this.authorization, resourceServer);
            if (permissions.isEmpty()) {
                if (request.isSubmitRequest()) {
                    throw new CorsErrorResponseException(this.cors, "access_denied", "request_submitted", Response.Status.FORBIDDEN);
                }
                throw new CorsErrorResponseException(this.cors, "access_denied", "not_authorized", Response.Status.FORBIDDEN);
            }
            ClientModel targetClient = this.authorization.getRealm().getClientById(resourceServer.getId());
            AuthorizationResponse response = new AuthorizationResponse(this.createRequestingPartyToken(identity, permissions, request, targetClient), request.getRpt() != null);
            return Cors.add(this.httpRequest, Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)response)).allowedOrigins(this.getKeycloakSession().getContext().getUri(), targetClient).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
        }
        catch (CorsErrorResponseException | ErrorResponseException cause) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error while evaluating permissions", (Throwable)cause);
            }
            throw cause;
        }
        catch (Exception cause) {
            logger.error((Object)"Unexpected error while evaluating permissions", (Throwable)cause);
            throw new CorsErrorResponseException(this.cors, "server_error", "Unexpected error while evaluating permissions", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean isPublicClientRequestingEntitlemesWithClaims(AuthorizationRequest request) {
        return request.getClaimToken() != null && this.getKeycloakSession().getContext().getClient().isPublicClient() && request.getTicket() == null;
    }

    private List<Result> evaluatePermissions(AuthorizationRequest authorizationRequest, PermissionTicketToken ticket, ResourceServer resourceServer, KeycloakEvaluationContext evaluationContext, KeycloakIdentity identity) {
        return this.authorization.evaluators().from(this.createPermissions(ticket, authorizationRequest, resourceServer, identity, this.authorization), (EvaluationContext)evaluationContext).evaluate();
    }

    private List<Result> evaluateUserManagedPermissions(AuthorizationRequest request, PermissionTicketToken ticket, ResourceServer resourceServer, KeycloakEvaluationContext evaluationContext, KeycloakIdentity identity) {
        return ((PermissionTicketAwareDecisionResultCollector)this.authorization.evaluators().from(this.createPermissions(ticket, request, resourceServer, identity, this.authorization), (EvaluationContext)evaluationContext).evaluate((Decision)new PermissionTicketAwareDecisionResultCollector(request, ticket, (Identity)identity, resourceServer, this.authorization))).results();
    }

    private List<Result> evaluateAllPermissions(ResourceServer resourceServer, KeycloakEvaluationContext evaluationContext, KeycloakIdentity identity) {
        return this.authorization.evaluators().from(Permissions.all(resourceServer, identity, this.authorization), (EvaluationContext)evaluationContext).evaluate();
    }

    private AccessTokenResponse createRequestingPartyToken(KeycloakIdentity identity, List<Permission> entitlements, AuthorizationRequest request, ClientModel targetClient) {
        KeycloakSession keycloakSession = this.getKeycloakSession();
        AccessToken accessToken = identity.getAccessToken();
        UserSessionModel userSessionModel = keycloakSession.sessions().getUserSession(this.getRealm(), accessToken.getSessionState());
        ClientModel client = this.getRealm().getClientByClientId(accessToken.getIssuedFor());
        AuthenticatedClientSessionModel clientSession = userSessionModel.getAuthenticatedClientSessionByClient(client.getId());
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.getRealm(), clientSession.getClient(), this.event, keycloakSession, userSessionModel, clientSession).generateAccessToken().generateRefreshToken();
        AccessToken rpt = responseBuilder.getAccessToken();
        rpt.issuedFor(client.getClientId());
        AccessToken.Authorization authorization = new AccessToken.Authorization();
        authorization.setPermissions(entitlements);
        authorization.setClaims(request.getClaims());
        rpt.setAuthorization(authorization);
        RefreshToken refreshToken = responseBuilder.getRefreshToken();
        refreshToken.issuedFor(client.getClientId());
        refreshToken.setAuthorization(authorization);
        if (!rpt.hasAudience(targetClient.getClientId())) {
            rpt.audience(new String[]{targetClient.getClientId()});
        }
        return responseBuilder.build();
    }

    private PermissionTicketToken getPermissionTicket(AuthorizationRequest request) {
        if (request.getTicket() != null) {
            return this.verifyPermissionTicket(request);
        }
        PermissionTicketToken permissions = request.getPermissions();
        permissions.audience(new String[]{request.getAudience()});
        return permissions;
    }

    private ResourceServer getResourceServer(PermissionTicketToken ticket) {
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
        String[] audience = ticket.getAudience();
        if (audience == null || audience.length == 0) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "You must provide the audience", Response.Status.BAD_REQUEST);
        }
        ClientModel clientModel = this.getRealm().getClientByClientId(audience[0]);
        if (clientModel == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Unknown resource server id.", Response.Status.BAD_REQUEST);
        }
        ResourceServer resourceServer = resourceServerStore.findById(clientModel.getId());
        if (resourceServer == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Client does not support permissions", Response.Status.BAD_REQUEST);
        }
        return resourceServer;
    }

    private KeycloakEvaluationContext createEvaluationContext(AuthorizationRequest authorizationRequest) {
        BiFunction<AuthorizationRequest, AuthorizationProvider, KeycloakEvaluationContext> evaluationContextProvider;
        String claimTokenFormat = authorizationRequest.getClaimTokenFormat();
        if (claimTokenFormat == null) {
            claimTokenFormat = CLAIM_TOKEN_FORMAT_ID_TOKEN;
        }
        if ((evaluationContextProvider = SUPPORTED_CLAIM_TOKEN_FORMATS.get(claimTokenFormat)) == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Claim token format [" + claimTokenFormat + "] not supported", Response.Status.BAD_REQUEST);
        }
        return evaluationContextProvider.apply(authorizationRequest, this.authorization);
    }

    private List<ResourcePermission> createPermissions(PermissionTicketToken ticket, AuthorizationRequest request, ResourceServer resourceServer, KeycloakIdentity identity, AuthorizationProvider authorization) {
        String rpt;
        Integer n;
        Integer n2;
        Set scopes;
        StoreFactory storeFactory = authorization.getStoreFactory();
        LinkedHashMap permissionsToEvaluate = new LinkedHashMap();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        AuthorizationRequest.Metadata metadata = request.getMetadata();
        Integer limit = metadata != null ? metadata.getLimit() : null;
        for (PermissionTicketToken.ResourcePermission requestedResource : ticket.getResources()) {
            if (limit != null && limit <= 0) break;
            HashSet<String> requestedScopes = requestedResource.getScopes();
            if (requestedResource.getScopes() == null) {
                requestedScopes = new HashSet<String>();
            }
            ArrayList<Resource> existingResources = new ArrayList<Resource>();
            if (requestedResource.getResourceId() != null) {
                Resource resource2 = resourceStore.findById(requestedResource.getResourceId(), resourceServer.getId());
                if (resource2 != null) {
                    existingResources.add(resource2);
                } else {
                    Resource resource;
                    Resource ownerResource = resourceStore.findByName(requestedResource.getResourceId(), identity.getId(), resourceServer.getId());
                    if (ownerResource != null) {
                        existingResources.add(ownerResource);
                    }
                    if (!identity.isResourceServer() && (resource = resourceStore.findByName(requestedResource.getResourceId(), resourceServer.getId())) != null) {
                        existingResources.add(resource);
                    }
                }
            }
            if (existingResources.isEmpty() && (requestedScopes == null || requestedScopes.isEmpty())) {
                throw new CorsErrorResponseException(this.cors, "invalid_resource", "Resource with id [" + requestedResource.getResourceId() + "] does not exist.", Response.Status.FORBIDDEN);
            }
            String clientAdditionalScopes = request.getScope();
            if (clientAdditionalScopes != null) {
                requestedScopes.addAll(Arrays.asList(clientAdditionalScopes.split(" ")));
            }
            if (!existingResources.isEmpty()) {
                for (Resource resource : existingResources) {
                    scopes = (HashSet)permissionsToEvaluate.get(resource.getId());
                    if (scopes == null) {
                        scopes = new HashSet();
                        permissionsToEvaluate.put(resource.getId(), scopes);
                        if (limit != null) {
                            n2 = limit;
                            n = limit = Integer.valueOf(limit - 1);
                        }
                    }
                    scopes.addAll(requestedScopes);
                }
                continue;
            }
            List resources = resourceStore.findByScope(new ArrayList(requestedScopes), ticket.getAudience()[0]);
            for (Resource resource4 : resources) {
                permissionsToEvaluate.put(resource4.getId(), requestedScopes);
                if (limit == null) continue;
                n2 = limit;
                n = limit = Integer.valueOf(limit - 1);
            }
            permissionsToEvaluate.put("$KC_SCOPE_PERMISSION", requestedScopes);
        }
        if ((rpt = request.getRpt()) != null) {
            List permissions;
            AccessToken.Authorization authorizationData;
            AccessToken requestingPartyToken;
            if (!Tokens.verifySignature(this.getKeycloakSession(), this.getRealm(), rpt)) {
                throw new CorsErrorResponseException(this.cors, "invalid_rpt", "RPT signature is invalid", Response.Status.FORBIDDEN);
            }
            try {
                requestingPartyToken = (AccessToken)new JWSInput(rpt).readJsonContent(AccessToken.class);
            }
            catch (JWSInputException e) {
                throw new CorsErrorResponseException(this.cors, "invalid_rpt", "Invalid RPT", Response.Status.FORBIDDEN);
            }
            if (requestingPartyToken.isActive() && (authorizationData = requestingPartyToken.getAuthorization()) != null && (permissions = authorizationData.getPermissions()) != null) {
                for (Permission permission : permissions) {
                    Set scopePermission;
                    if (limit != null && limit <= 0) break;
                    Resource resource = resourceStore.findById(permission.getResourceId(), ticket.getAudience()[0]);
                    if (resource == null) continue;
                    scopes = (Set)permissionsToEvaluate.get(resource.getId());
                    if (scopes == null) {
                        scopes = new HashSet();
                        permissionsToEvaluate.put(resource.getId(), scopes);
                        if (limit != null) {
                            n2 = limit;
                            n = limit = Integer.valueOf(limit - 1);
                        }
                    }
                    if ((scopePermission = permission.getScopes()) == null) continue;
                    scopes.addAll(scopePermission);
                }
            }
        }
        ScopeStore scopeStore = storeFactory.getScopeStore();
        return permissionsToEvaluate.entrySet().stream().flatMap(entry -> {
            String key = (String)entry.getKey();
            if ("$KC_SCOPE_PERMISSION".equals(key)) {
                List scopes = ((Set)entry.getValue()).stream().map(scopeName -> scopeStore.findByName(scopeName, resourceServer.getId())).filter(scope -> Objects.nonNull(scope)).collect(Collectors.toList());
                return Arrays.asList(new ResourcePermission(null, scopes, resourceServer)).stream();
            }
            Resource entryResource = resourceStore.findById(key, resourceServer.getId());
            return Permissions.createResourcePermissions(entryResource, (Set)entry.getValue(), authorization).stream();
        }).collect(Collectors.toList());
    }

    private PermissionTicketToken verifyPermissionTicket(AuthorizationRequest request) {
        String ticketString = request.getTicket();
        if (ticketString == null || !Tokens.verifySignature(this.getKeycloakSession(), this.getRealm(), ticketString)) {
            throw new CorsErrorResponseException(this.cors, "invalid_ticket", "Ticket verification failed", Response.Status.FORBIDDEN);
        }
        try {
            PermissionTicketToken ticket = (PermissionTicketToken)new JWSInput(ticketString).readJsonContent(PermissionTicketToken.class);
            if (!ticket.isActive()) {
                throw new CorsErrorResponseException(this.cors, "invalid_ticket", "Invalid permission ticket.", Response.Status.FORBIDDEN);
            }
            return ticket;
        }
        catch (JWSInputException e) {
            throw new CorsErrorResponseException(this.cors, "invalid_ticket", "Could not parse permission ticket.", Response.Status.FORBIDDEN);
        }
    }

    private KeycloakSession getKeycloakSession() {
        return this.authorization.getKeycloakSession();
    }

    private RealmModel getRealm() {
        return this.getKeycloakSession().getContext().getRealm();
    }

    static {
        SUPPORTED_CLAIM_TOKEN_FORMATS.put("urn:ietf:params:oauth:token-type:jwt", (authorizationRequest, authorization) -> {
            String claimToken = authorizationRequest.getClaimToken();
            if (claimToken != null) {
                try {
                    Map claims = (Map)JsonSerialization.readValue((byte[])Base64Url.decode((String)authorizationRequest.getClaimToken()), Map.class);
                    authorizationRequest.setClaims(claims);
                    return new KeycloakEvaluationContext(new KeycloakIdentity(authorization.getKeycloakSession(), (IDToken)Tokens.getAccessToken(authorizationRequest.getAccessToken(), authorization.getKeycloakSession())), (Map<String, List<String>>)claims, authorization.getKeycloakSession());
                }
                catch (IOException cause) {
                    throw new RuntimeException("Failed to map claims from claim token [" + claimToken + "]", cause);
                }
            }
            throw new RuntimeException("Claim token can not be null");
        });
        SUPPORTED_CLAIM_TOKEN_FORMATS.put(CLAIM_TOKEN_FORMAT_ID_TOKEN, (authorizationRequest, authorization) -> {
            try {
                KeycloakSession keycloakSession = authorization.getKeycloakSession();
                RealmModel realm = authorization.getRealm();
                String accessToken = authorizationRequest.getAccessToken();
                if (accessToken == null) {
                    throw new RuntimeException("Claim token can not be null and must be a valid IDToken");
                }
                IDToken idToken = new TokenManager().verifyIDTokenSignature(keycloakSession, realm, accessToken);
                return new KeycloakEvaluationContext(new KeycloakIdentity(keycloakSession, idToken), (Map<String, List<String>>)authorizationRequest.getClaims(), keycloakSession);
            }
            catch (OAuthErrorException cause) {
                throw new RuntimeException("Failed to verify ID token", cause);
            }
        });
    }
}

