/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.error;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.Config;
import org.keycloak.forms.login.freemarker.model.UrlBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.theme.FreeMarkerUtil;
import org.keycloak.theme.Theme;
import org.keycloak.theme.beans.LocaleBean;
import org.keycloak.theme.beans.MessageBean;
import org.keycloak.theme.beans.MessageFormatterMethod;
import org.keycloak.theme.beans.MessageType;
import org.keycloak.utils.MediaType;
import org.keycloak.utils.MediaTypeMatcher;

@Provider
public class KeycloakErrorHandler
implements ExceptionMapper<Throwable> {
    private static final Logger logger = Logger.getLogger(KeycloakErrorHandler.class);
    private static final Pattern realmNamePattern = Pattern.compile(".*/realms/([^/]+).*");
    @Context
    private KeycloakSession session;
    @Context
    private HttpHeaders headers;
    @Context
    private HttpResponse response;

    public Response toResponse(Throwable throwable) {
        KeycloakTransaction tx = (KeycloakTransaction)ResteasyProviderFactory.getContextData(KeycloakTransaction.class);
        tx.setRollbackOnly();
        int statusCode = this.getStatusCode(throwable);
        if (statusCode >= 500 && statusCode <= 599) {
            logger.error((Object)"Uncaught server error", throwable);
        }
        if (!MediaTypeMatcher.isHtmlRequest(this.headers)) {
            return Response.status((int)statusCode).build();
        }
        try {
            RealmModel realm = this.resolveRealm();
            Theme theme = this.session.theme().getTheme(Theme.Type.LOGIN);
            Locale locale = this.session.getContext().resolveLocale(null);
            FreeMarkerUtil freeMarker = new FreeMarkerUtil();
            Map<String, Object> attributes = this.initAttributes(realm, theme, locale, statusCode);
            String templateName = "error.ftl";
            String content = freeMarker.processTemplate(attributes, templateName, theme);
            return Response.status((int)statusCode).type(MediaType.TEXT_HTML_UTF_8_TYPE).entity((Object)content).build();
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to create error page", t);
            return Response.serverError().build();
        }
    }

    private int getStatusCode(Throwable throwable) {
        int status = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        if (throwable instanceof WebApplicationException) {
            WebApplicationException ex = (WebApplicationException)throwable;
            status = ex.getResponse().getStatus();
        }
        if (throwable instanceof Failure) {
            Failure f = (Failure)throwable;
            status = f.getErrorCode();
        }
        return status;
    }

    private RealmModel resolveRealm() {
        RealmManager realmManager = new RealmManager(this.session);
        String path = this.session.getContext().getUri().getPath();
        Matcher m = realmNamePattern.matcher(path);
        String realmName = m.matches() ? m.group(1) : Config.getAdminRealm();
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            realm = realmManager.getRealmByName(Config.getAdminRealm());
        }
        this.session.getContext().setRealm(realm);
        return realm;
    }

    private Map<String, Object> initAttributes(RealmModel realm, Theme theme, Locale locale, int statusCode) throws IOException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Properties messagesBundle = theme.getMessages(locale);
        attributes.put("statusCode", statusCode);
        attributes.put("realm", realm);
        attributes.put("url", new UrlBean(realm, theme, this.session.getContext().getUri().getBaseUri(), null));
        attributes.put("locale", new LocaleBean(realm, locale, this.session.getContext().getUri().getBaseUriBuilder(), messagesBundle));
        String errorKey = statusCode == 404 ? "pageNotFound" : "internalServerError";
        String errorMessage = messagesBundle.getProperty(errorKey);
        attributes.put("message", new MessageBean(errorMessage, MessageType.ERROR));
        try {
            attributes.put("msg", new MessageFormatterMethod(locale, theme.getMessages(locale)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            attributes.put("properties", theme.getProperties());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return attributes;
    }
}

