/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.Set;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;

public class Parameter
extends ModelElement {
    private final String name;
    private final Type type;
    private final boolean mappingTarget;
    private final boolean targetType;

    public Parameter(String name, Type type, boolean mappingTarget, boolean targetType) {
        this.name = name;
        this.type = type;
        this.mappingTarget = mappingTarget;
        this.targetType = targetType;
    }

    public Parameter(String name, Type type) {
        this(name, type, false, false);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isMappingTarget() {
        return this.mappingTarget;
    }

    public String toString() {
        return (this.mappingTarget ? "@MappingTarget " : "") + (this.targetType ? "@TargetType " : "") + this.type.toString() + " " + this.name;
    }

    @Override
    public Set<Type> getImportTypes() {
        return Collections.asSet(this.type);
    }

    public boolean isTargetType() {
        return this.targetType;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

