/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Arrays;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Strings;

public class PropertyEntry {
    private final String[] fullName;
    private final ExecutableElement readAccessor;
    private final ExecutableElement writeAccessor;
    private final ExecutableElement presenceChecker;
    private final Type type;

    private PropertyEntry(String[] fullName, ExecutableElement readAccessor, ExecutableElement writeAccessor, ExecutableElement presenceChecker, Type type) {
        this.fullName = fullName;
        this.readAccessor = readAccessor;
        this.writeAccessor = writeAccessor;
        this.presenceChecker = presenceChecker;
        this.type = type;
    }

    public static PropertyEntry forTargetReference(String[] fullName, ExecutableElement readAccessor, ExecutableElement writeAccessor, Type type) {
        return new PropertyEntry(fullName, readAccessor, writeAccessor, null, type);
    }

    public static PropertyEntry forSourceReference(String name, ExecutableElement readAccessor, ExecutableElement presenceChecker, Type type) {
        return new PropertyEntry(new String[]{name}, readAccessor, null, presenceChecker, type);
    }

    public String getName() {
        return this.fullName[this.fullName.length - 1];
    }

    public ExecutableElement getReadAccessor() {
        return this.readAccessor;
    }

    public ExecutableElement getWriteAccessor() {
        return this.writeAccessor;
    }

    public ExecutableElement getPresenceChecker() {
        return this.presenceChecker;
    }

    public Type getType() {
        return this.type;
    }

    public String getFullName() {
        return Strings.join(Arrays.asList(this.fullName), ".");
    }
}

