/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.mapstruct.ap.internal.model.GeneratedType;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.ServicesEntry;
import org.mapstruct.ap.internal.option.OptionsHelper;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.writer.ModelWriter;

public class MapperServiceProcessor
implements ModelElementProcessor<Mapper, Void> {
    @Override
    public Void process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Mapper mapper) {
        boolean spiGenerationNeeded;
        if (context.getOptions().isAlwaysGenerateSpi()) {
            spiGenerationNeeded = true;
        } else {
            String componentModel = MapperConfiguration.getInstanceOn(mapperTypeElement).componentModel();
            String effectiveComponentModel = OptionsHelper.getEffectiveComponentModel(context.getOptions(), componentModel);
            spiGenerationNeeded = "default".equals(effectiveComponentModel);
        }
        if (!context.isErroneous() && spiGenerationNeeded && mapper.hasCustomImplementation()) {
            this.writeToSourceFile(context.getFiler(), mapper);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return 10000;
    }

    private void writeToSourceFile(Filer filer, Mapper model) {
        ModelWriter modelWriter = new ModelWriter();
        ServicesEntry servicesEntry = this.getServicesEntry(model.getDecorator() == null ? model : model.getDecorator());
        this.createSourceFile(servicesEntry, modelWriter, filer);
    }

    private ServicesEntry getServicesEntry(GeneratedType model) {
        String mapperName = model.getInterfaceName() != null ? model.getInterfaceName() : model.getSuperClassName();
        return new ServicesEntry(model.getInterfacePackage(), mapperName, model.getPackageName(), model.getName());
    }

    private void createSourceFile(ServicesEntry model, ModelWriter modelWriter, Filer filer) {
        FileObject sourceFile;
        String fileName = model.getPackageName() + "." + model.getName();
        try {
            sourceFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + fileName, new Element[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        modelWriter.writeModel(sourceFile, model);
    }
}

