/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.assignment;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.assignment.Assignment;
import org.mapstruct.ap.internal.model.assignment.WrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.prism.NullValueCheckStrategyPrism;

public class SetterWrapperForCollectionsAndMaps
extends WrapperForCollectionsAndMaps {
    private final boolean includeSourceNullCheck;
    private final Type targetType;
    private final TypeFactory typeFactory;
    private final boolean targetImmutable;

    public SetterWrapperForCollectionsAndMaps(Assignment decoratedAssignment, List<Type> thrownTypesToExclude, Type targetType, NullValueCheckStrategyPrism nvms, TypeFactory typeFactory, boolean fieldAssignment, boolean targetImmutable) {
        super(decoratedAssignment, thrownTypesToExclude, targetType, fieldAssignment);
        this.includeSourceNullCheck = NullValueCheckStrategyPrism.ALWAYS == nvms;
        this.targetType = targetType;
        this.typeFactory = typeFactory;
        this.targetImmutable = targetImmutable;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> imported = super.getImportTypes();
        if (this.isDirectAssignment()) {
            if (this.targetType.getImplementationType() != null) {
                imported.addAll(this.targetType.getImplementationType().getImportTypes());
            } else {
                imported.addAll(this.targetType.getImportTypes());
            }
            if (this.isEnumSet()) {
                imported.add(this.typeFactory.getType(EnumSet.class));
            }
        }
        return imported;
    }

    public boolean isIncludeSourceNullCheck() {
        return this.includeSourceNullCheck;
    }

    public boolean isDirectAssignment() {
        return this.getType() == Assignment.AssignmentType.DIRECT;
    }

    public boolean isEnumSet() {
        return "java.util.EnumSet".equals(this.targetType.getFullyQualifiedName());
    }

    public boolean isTargetImmutable() {
        return this.targetImmutable;
    }
}

