/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.SourceMethod;

public class MethodMatcher {
    private final SourceMethod candidateMethod;
    private final Types typeUtils;
    private final TypeFactory typeFactory;

    MethodMatcher(Types typeUtils, TypeFactory typeFactory, SourceMethod candidateMethod) {
        this.typeUtils = typeUtils;
        this.candidateMethod = candidateMethod;
        this.typeFactory = typeFactory;
    }

    boolean matches(List<Type> sourceTypes, Type resultType) {
        Type returnClassType;
        HashMap<TypeVariable, TypeMirror> genericTypesMap = new HashMap<TypeVariable, TypeMirror>();
        if (this.candidateMethod.getParameters().size() == sourceTypes.size()) {
            int i = 0;
            for (Parameter parameter : this.candidateMethod.getParameters()) {
                Type sourceType;
                if ((sourceType = sourceTypes.get(i++)) != null && this.matchSourceType(sourceType, parameter.getType(), genericTypesMap)) continue;
                return false;
            }
        } else {
            return false;
        }
        Parameter targetTypeParameter = this.candidateMethod.getTargetTypeParameter();
        if (targetTypeParameter != null && !this.matchSourceType(returnClassType = this.typeFactory.classTypeOf(resultType), targetTypeParameter.getType(), genericTypesMap)) {
            return false;
        }
        if (!this.matchResultType(resultType, genericTypesMap)) {
            return false;
        }
        if (this.candidateMethod.getExecutable().getTypeParameters().size() != genericTypesMap.size()) {
            return false;
        }
        for (Map.Entry entry : genericTypesMap.entrySet()) {
            if (this.isWithinBounds((TypeMirror)entry.getValue(), this.getTypeParamFromCandidate((TypeMirror)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private boolean matchSourceType(Type sourceType, Type candidateSourceType, Map<TypeVariable, TypeMirror> genericTypesMap) {
        TypeMatcher parameterMatcher;
        if (!this.isJavaLangObject(candidateSourceType.getTypeMirror()) && !((Boolean)(parameterMatcher = new TypeMatcher(Assignability.VISITED_ASSIGNABLE_FROM, genericTypesMap)).visit(candidateSourceType.getTypeMirror(), sourceType.getTypeMirror())).booleanValue()) {
            if (sourceType.isPrimitive()) {
                TypeMirror boxedType = this.typeUtils.boxedClass((PrimitiveType)sourceType.getTypeMirror()).asType();
                if (!((Boolean)parameterMatcher.visit(candidateSourceType.getTypeMirror(), boxedType)).booleanValue()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean matchResultType(Type resultType, Map<TypeVariable, TypeMirror> genericTypesMap) {
        Assignability visitedAssignability;
        TypeMatcher returnTypeMatcher;
        Type candidateResultType = this.candidateMethod.getResultType();
        if (!(this.isJavaLangObject(candidateResultType.getTypeMirror()) || candidateResultType.isVoid() || ((Boolean)(returnTypeMatcher = new TypeMatcher(visitedAssignability = this.candidateMethod.getReturnType().isVoid() ? Assignability.VISITED_ASSIGNABLE_FROM : Assignability.VISITED_ASSIGNABLE_TO, genericTypesMap)).visit(candidateResultType.getTypeMirror(), resultType.getTypeMirror())).booleanValue())) {
            if (resultType.isPrimitive()) {
                TypeMirror boxedType = this.typeUtils.boxedClass((PrimitiveType)resultType.getTypeMirror()).asType();
                TypeMatcher boxedReturnTypeMatcher = new TypeMatcher(visitedAssignability, genericTypesMap);
                if (!((Boolean)boxedReturnTypeMatcher.visit(candidateResultType.getTypeMirror(), boxedType)).booleanValue()) {
                    return false;
                }
            } else if (candidateResultType.getTypeMirror().getKind().isPrimitive()) {
                TypeMatcher boxedReturnTypeMatcher = new TypeMatcher(visitedAssignability, genericTypesMap);
                TypeMirror boxedCandidateReturnType = this.typeUtils.boxedClass((PrimitiveType)candidateResultType.getTypeMirror()).asType();
                if (!((Boolean)boxedReturnTypeMatcher.visit(boxedCandidateReturnType, resultType.getTypeMirror())).booleanValue()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isJavaLangObject(TypeMirror type) {
        return type.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)type).asElement()).getQualifiedName().contentEquals(Object.class.getName());
    }

    private TypeParameterElement getTypeParamFromCandidate(TypeMirror t) {
        for (TypeParameterElement typeParameterElement : this.candidateMethod.getExecutable().getTypeParameters()) {
            if (!typeParameterElement.asType().equals(t)) continue;
            return typeParameterElement;
        }
        return null;
    }

    private boolean isWithinBounds(TypeMirror t, TypeParameterElement tpe) {
        List<? extends TypeMirror> bounds;
        List<? extends TypeMirror> list = bounds = tpe != null ? tpe.getBounds() : null;
        if (t != null && bounds != null) {
            for (TypeMirror typeMirror : bounds) {
                if (typeMirror.getKind() == TypeKind.DECLARED && this.typeUtils.isSubtype(t, typeMirror)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private class TypeMatcher
    extends SimpleTypeVisitor6<Boolean, TypeMirror> {
        private final Assignability assignability;
        private final Map<TypeVariable, TypeMirror> genericTypesMap;
        private final TypeMatcher inverse;

        TypeMatcher(Assignability assignability, Map<TypeVariable, TypeMirror> genericTypesMap) {
            super(Boolean.FALSE);
            this.assignability = assignability;
            this.genericTypesMap = genericTypesMap;
            this.inverse = new TypeMatcher(this, genericTypesMap);
        }

        TypeMatcher(TypeMatcher inverse, Map<TypeVariable, TypeMirror> genericTypesMap) {
            super(Boolean.FALSE);
            this.assignability = inverse.assignability.invert();
            this.genericTypesMap = genericTypesMap;
            this.inverse = inverse;
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType t, TypeMirror p) {
            return MethodMatcher.this.typeUtils.isSameType(t, p);
        }

        @Override
        public Boolean visitArray(ArrayType t, TypeMirror p) {
            if (p.getKind().equals((Object)TypeKind.ARRAY)) {
                return t.getComponentType().accept(this, ((ArrayType)p).getComponentType());
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, TypeMirror p) {
            if (p.getKind() == TypeKind.DECLARED) {
                DeclaredType t1 = (DeclaredType)p;
                if (this.assignabilityMatches(t, t1) && t.getTypeArguments().size() == t1.getTypeArguments().size()) {
                    for (int i = 0; i < t.getTypeArguments().size(); ++i) {
                        if (((Boolean)this.visit(t.getTypeArguments().get(i), t1.getTypeArguments().get(i))).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (p.getKind() == TypeKind.WILDCARD) {
                return (Boolean)this.inverse.visit(p, t);
            }
            return Boolean.FALSE;
        }

        private boolean assignabilityMatches(DeclaredType visited, DeclaredType param) {
            if (this.assignability == Assignability.VISITED_ASSIGNABLE_TO) {
                return MethodMatcher.this.typeUtils.isAssignable(this.toRawType(visited), this.toRawType(param));
            }
            return MethodMatcher.this.typeUtils.isAssignable(this.toRawType(param), this.toRawType(visited));
        }

        private DeclaredType toRawType(DeclaredType t) {
            return MethodMatcher.this.typeUtils.getDeclaredType((TypeElement)t.asElement(), new TypeMirror[0]);
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable t, TypeMirror p) {
            if (this.genericTypesMap.containsKey(t)) {
                TypeMirror p1 = this.genericTypesMap.get(t);
                return MethodMatcher.this.typeUtils.isSameType(p, p1);
            }
            TypeMirror lowerBound = t.getLowerBound();
            TypeMirror upperBound = t.getUpperBound();
            if ((this.isNullType(lowerBound) || MethodMatcher.this.typeUtils.isSubtype(lowerBound, p)) && (this.isNullType(upperBound) || MethodMatcher.this.typeUtils.isSubtype(p, upperBound))) {
                this.genericTypesMap.put(t, p);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        private boolean isNullType(TypeMirror type) {
            return type == null || type.getKind() == TypeKind.NULL;
        }

        @Override
        public Boolean visitWildcard(WildcardType t, TypeMirror p) {
            TypeMirror extendsBound = t.getExtendsBound();
            if (!this.isNullType(extendsBound)) {
                switch (extendsBound.getKind()) {
                    case DECLARED: {
                        return (Boolean)this.visit(extendsBound, p);
                    }
                    case TYPEVAR: {
                        return MethodMatcher.this.isWithinBounds(p, MethodMatcher.this.getTypeParamFromCandidate(extendsBound));
                    }
                }
                return Boolean.FALSE;
            }
            TypeMirror superBound = t.getSuperBound();
            if (!this.isNullType(superBound)) {
                switch (superBound.getKind()) {
                    case DECLARED: {
                        return MethodMatcher.this.typeUtils.isSubtype(superBound, p) || MethodMatcher.this.typeUtils.isSameType(p, superBound);
                    }
                    case TYPEVAR: {
                        TypeParameterElement typeParameter = MethodMatcher.this.getTypeParamFromCandidate(superBound);
                        if (!MethodMatcher.this.isWithinBounds(p, typeParameter)) {
                            return Boolean.FALSE;
                        }
                        TypeMirror superBoundAsDeclared = typeParameter.getBounds().get(0);
                        return MethodMatcher.this.typeUtils.isSubtype(superBoundAsDeclared, p) || MethodMatcher.this.typeUtils.isSameType(p, superBoundAsDeclared);
                    }
                }
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }

    private static enum Assignability {
        VISITED_ASSIGNABLE_FROM,
        VISITED_ASSIGNABLE_TO;


        Assignability invert() {
            return this == VISITED_ASSIGNABLE_FROM ? VISITED_ASSIGNABLE_TO : VISITED_ASSIGNABLE_FROM;
        }
    }
}

