/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.PropertyMapping;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.model.source.TargetReference;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Extractor;

public class NestedTargetPropertyMappingHolder {
    private static final Extractor<SourceReference, Parameter> SOURCE_PARAM_EXTRACTOR = new Extractor<SourceReference, Parameter>(){

        @Override
        public Parameter apply(SourceReference sourceReference) {
            return sourceReference.getParameter();
        }
    };
    private static final Extractor<SourceReference, PropertyEntry> PROPERTY_EXTRACTOR = new Extractor<SourceReference, PropertyEntry>(){

        @Override
        public PropertyEntry apply(SourceReference sourceReference) {
            return sourceReference.getPropertyEntries().isEmpty() ? null : Collections.first(sourceReference.getPropertyEntries());
        }
    };
    private final List<Parameter> processedSourceParameters;
    private final Set<String> handledTargets;
    private final List<PropertyMapping> propertyMappings;
    private final Map<PropertyEntry, List<Mapping>> unprocessedDefinedTarget;
    private final boolean errorOccurred;

    public NestedTargetPropertyMappingHolder(List<Parameter> processedSourceParameters, Set<String> handledTargets, List<PropertyMapping> propertyMappings, Map<PropertyEntry, List<Mapping>> unprocessedDefinedTarget, boolean errorOccurred) {
        this.processedSourceParameters = processedSourceParameters;
        this.handledTargets = handledTargets;
        this.propertyMappings = propertyMappings;
        this.unprocessedDefinedTarget = unprocessedDefinedTarget;
        this.errorOccurred = errorOccurred;
    }

    public List<Parameter> getProcessedSourceParameters() {
        return this.processedSourceParameters;
    }

    public Set<String> getHandledTargets() {
        return this.handledTargets;
    }

    public List<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public Map<PropertyEntry, List<Mapping>> getUnprocessedDefinedTarget() {
        return this.unprocessedDefinedTarget;
    }

    public boolean hasErrorOccurred() {
        return this.errorOccurred;
    }

    private static class GroupedSourceReferences {
        private final Map<PropertyEntry, List<Mapping>> groupedBySourceReferences;
        private final List<Mapping> nonNested;
        private final List<Mapping> notProcessedAppliesToAll;
        private final List<Mapping> sourceParameterMappings;

        private GroupedSourceReferences(Map<PropertyEntry, List<Mapping>> groupedBySourceReferences, List<Mapping> nonNested, List<Mapping> notProcessedAppliesToAll, List<Mapping> sourceParameterMappings) {
            this.groupedBySourceReferences = groupedBySourceReferences;
            this.nonNested = nonNested;
            this.notProcessedAppliesToAll = notProcessedAppliesToAll;
            this.sourceParameterMappings = sourceParameterMappings;
        }
    }

    private static class GroupedTargetReferences {
        private final Map<PropertyEntry, List<Mapping>> poppedTargetReferences;
        private final Map<PropertyEntry, List<Mapping>> singleTargetReferences;
        private final boolean errorOccurred;

        private GroupedTargetReferences(Map<PropertyEntry, List<Mapping>> poppedTargetReferences, Map<PropertyEntry, List<Mapping>> singleTargetReferences, boolean errorOccurred) {
            this.poppedTargetReferences = poppedTargetReferences;
            this.singleTargetReferences = singleTargetReferences;
            this.errorOccurred = errorOccurred;
        }
    }

    private static class GroupedBySourceParameters {
        private final Map<Parameter, List<Mapping>> groupedBySourceParameter;
        private final List<Mapping> notProcessedAppliesToAll;

        private GroupedBySourceParameters(Map<Parameter, List<Mapping>> groupedBySourceParameter, List<Mapping> notProcessedAppliesToAll) {
            this.groupedBySourceParameter = groupedBySourceParameter;
            this.notProcessedAppliesToAll = notProcessedAppliesToAll;
        }
    }

    public static class Builder {
        private Method method;
        private MappingBuilderContext mappingContext;
        private Set<String> existingVariableNames;
        private List<PropertyMapping> propertyMappings;
        private Set<String> handledTargets;

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.mappingContext = mappingContext;
            return this;
        }

        public Builder existingVariableNames(Set<String> existingVariableNames) {
            this.existingVariableNames = existingVariableNames;
            return this;
        }

        public NestedTargetPropertyMappingHolder build() {
            ArrayList<Parameter> processedSourceParameters = new ArrayList<Parameter>();
            this.handledTargets = new HashSet<String>();
            this.propertyMappings = new ArrayList<PropertyMapping>();
            GroupedTargetReferences groupedByTP = this.groupByTargetReferences(this.method.getMappingOptions());
            LinkedHashMap<PropertyEntry, List<Mapping>> unprocessedDefinedTarget = new LinkedHashMap<PropertyEntry, List<Mapping>>();
            for (Map.Entry entryByTP : groupedByTP.poppedTargetReferences.entrySet()) {
                PropertyEntry targetProperty = (PropertyEntry)entryByTP.getKey();
                GroupedBySourceParameters groupedBySourceParam = this.groupBySourceParameter((List)entryByTP.getValue(), (List)groupedByTP.singleTargetReferences.get(targetProperty));
                boolean multipleSourceParametersForTP = groupedBySourceParam.groupedBySourceParameter.keySet().size() > 1;
                unprocessedDefinedTarget.put(targetProperty, groupedBySourceParam.notProcessedAppliesToAll);
                for (Map.Entry<Parameter, List<Mapping>> entry : groupedBySourceParam.groupedBySourceParameter.entrySet()) {
                    Parameter sourceParameter = (Parameter)entry.getKey();
                    GroupedSourceReferences groupedSourceReferences = this.groupByPoppedSourceReferences(entry, (List)groupedByTP.singleTargetReferences.get(targetProperty));
                    boolean forceUpdateMethod = multipleSourceParametersForTP || groupedSourceReferences.groupedBySourceReferences.size() > 1;
                    boolean forceUpdateMethodOrNonNestedReferencesPresent = forceUpdateMethod || !groupedSourceReferences.nonNested.isEmpty();
                    for (Map.Entry entryBySP : groupedSourceReferences.groupedBySourceReferences.entrySet()) {
                        SourceReference sourceRef;
                        PropertyEntry sourceEntry = (PropertyEntry)entryBySP.getKey();
                        MappingOptions sourceMappingOptions = MappingOptions.forMappingsOnly(this.groupByTargetName((List)entryBySP.getValue()), multipleSourceParametersForTP, forceUpdateMethodOrNonNestedReferencesPresent);
                        PropertyMapping propertyMapping = this.createPropertyMappingForNestedTarget(sourceMappingOptions, targetProperty, sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).type(sourceEntry.getType()).readAccessor(sourceEntry.getReadAccessor()).presenceChecker(sourceEntry.getPresenceChecker()).name(targetProperty.getName()).build(), forceUpdateMethodOrNonNestedReferencesPresent);
                        if (propertyMapping != null) {
                            this.propertyMappings.add(propertyMapping);
                        }
                        this.handledTargets.add(((PropertyEntry)entryByTP.getKey()).getName());
                    }
                    if (!groupedSourceReferences.nonNested.isEmpty()) {
                        boolean forceUpdateMethodForNonNested;
                        SourceReference reference;
                        MappingOptions nonNestedOptions = MappingOptions.forMappingsOnly(this.groupByTargetName(groupedSourceReferences.nonNested), true);
                        PropertyMapping propertyMapping = this.createPropertyMappingForNestedTarget(nonNestedOptions, targetProperty, reference = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty.getName()).build(), forceUpdateMethodForNonNested = multipleSourceParametersForTP || !groupedSourceReferences.groupedBySourceReferences.isEmpty());
                        if (propertyMapping != null) {
                            this.propertyMappings.add(propertyMapping);
                        }
                        this.handledTargets.add(((PropertyEntry)entryByTP.getKey()).getName());
                    }
                    this.handleSourceParameterMappings(groupedSourceReferences.sourceParameterMappings, targetProperty, sourceParameter, multipleSourceParametersForTP);
                    unprocessedDefinedTarget.put(targetProperty, groupedSourceReferences.notProcessedAppliesToAll);
                }
            }
            return new NestedTargetPropertyMappingHolder(processedSourceParameters, this.handledTargets, this.propertyMappings, unprocessedDefinedTarget, groupedByTP.errorOccurred);
        }

        private void handleSourceParameterMappings(List<Mapping> sourceParameterMappings, PropertyEntry targetProperty, Parameter sourceParameter, boolean forceUpdateMethod) {
            if (!sourceParameterMappings.isEmpty()) {
                SourceReference reference;
                MappingOptions nonNestedOptions = MappingOptions.forMappingsOnly(new HashMap<String, List<Mapping>>(), false, true);
                PropertyMapping propertyMapping = this.createPropertyMappingForNestedTarget(nonNestedOptions, targetProperty, reference = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty.getName()).build(), forceUpdateMethod);
                if (propertyMapping != null) {
                    this.propertyMappings.add(propertyMapping);
                }
                this.handledTargets.add(targetProperty.getName());
            }
        }

        private GroupedTargetReferences groupByTargetReferences(MappingOptions mappingOptions) {
            Map<String, List<Mapping>> mappings = mappingOptions.getMappings();
            LinkedHashMap mappingsKeyedByProperty = new LinkedHashMap();
            LinkedHashMap singleTargetReferences = new LinkedHashMap();
            boolean errorOccurred = false;
            for (List<Mapping> mapping : mappings.values()) {
                Mapping firstMapping = Collections.first(mapping);
                TargetReference targetReference = firstMapping.getTargetReference();
                if (!targetReference.isValid()) {
                    errorOccurred = true;
                    continue;
                }
                PropertyEntry property = Collections.first(targetReference.getPropertyEntries());
                Mapping newMapping = firstMapping.popTargetReference();
                if (newMapping != null) {
                    if (!mappingsKeyedByProperty.containsKey(property)) {
                        mappingsKeyedByProperty.put(property, new ArrayList());
                    }
                    ((List)mappingsKeyedByProperty.get(property)).add(newMapping);
                    continue;
                }
                if (!singleTargetReferences.containsKey(property)) {
                    singleTargetReferences.put(property, new ArrayList());
                }
                ((List)singleTargetReferences.get(property)).add(firstMapping);
            }
            return new GroupedTargetReferences(mappingsKeyedByProperty, singleTargetReferences, errorOccurred);
        }

        private GroupedBySourceParameters groupBySourceParameter(List<Mapping> mappings, List<Mapping> singleTargetReferences) {
            LinkedHashMap mappingsKeyedByParameter = new LinkedHashMap();
            ArrayList<Mapping> appliesToAll = new ArrayList<Mapping>();
            for (Mapping mapping : mappings) {
                if (mapping.getSourceReference() != null && mapping.getSourceReference().isValid()) {
                    Parameter parameter = mapping.getSourceReference().getParameter();
                    if (!mappingsKeyedByParameter.containsKey(parameter)) {
                        mappingsKeyedByParameter.put(parameter, new ArrayList());
                    }
                    ((List)mappingsKeyedByParameter.get(parameter)).add(mapping);
                    continue;
                }
                appliesToAll.add(mapping);
            }
            this.populateWithSingleTargetReferences(mappingsKeyedByParameter, singleTargetReferences, SOURCE_PARAM_EXTRACTOR);
            for (Map.Entry entry : mappingsKeyedByParameter.entrySet()) {
                ((List)entry.getValue()).addAll(appliesToAll);
            }
            ArrayList<Mapping> notProcessAppliesToAll = mappingsKeyedByParameter.isEmpty() ? appliesToAll : new ArrayList<Mapping>();
            return new GroupedBySourceParameters(mappingsKeyedByParameter, notProcessAppliesToAll);
        }

        private GroupedSourceReferences groupByPoppedSourceReferences(Map.Entry<Parameter, List<Mapping>> entryByParam, List<Mapping> singleTargetReferences) {
            List<Mapping> mappings = entryByParam.getValue();
            ArrayList<Mapping> nonNested = new ArrayList<Mapping>();
            ArrayList<Mapping> appliesToAll = new ArrayList<Mapping>();
            ArrayList<Mapping> sourceParameterMappings = new ArrayList<Mapping>();
            LinkedHashMap mappingsKeyedByProperty = new LinkedHashMap();
            for (Mapping mapping : mappings) {
                Mapping newMapping = mapping.popSourceReference();
                if (newMapping != null) {
                    PropertyEntry property = Collections.first(mapping.getSourceReference().getPropertyEntries());
                    if (!mappingsKeyedByProperty.containsKey(property)) {
                        mappingsKeyedByProperty.put(property, new ArrayList());
                    }
                    ((List)mappingsKeyedByProperty.get(property)).add(newMapping);
                    continue;
                }
                if (mapping.getSourceReference() == null) {
                    appliesToAll.add(mapping);
                    continue;
                }
                nonNested.add(mapping);
            }
            boolean hasNoMappings = mappingsKeyedByProperty.isEmpty() && nonNested.isEmpty();
            Parameter sourceParameter = entryByParam.getKey();
            List<Mapping> singleTargetReferencesToUse = this.extractSingleTargetReferencesToUseAndPopulateSourceParameterMappings(singleTargetReferences, sourceParameterMappings, hasNoMappings, sourceParameter);
            this.populateWithSingleTargetReferences(mappingsKeyedByProperty, singleTargetReferencesToUse, PROPERTY_EXTRACTOR);
            for (Map.Entry entry : mappingsKeyedByProperty.entrySet()) {
                ((List)entry.getValue()).addAll(appliesToAll);
            }
            ArrayList<Mapping> notProcessedAppliesToAll = new ArrayList<Mapping>();
            if (mappingsKeyedByProperty.isEmpty() && !nonNested.isEmpty()) {
                nonNested.addAll(appliesToAll);
            } else if (mappingsKeyedByProperty.isEmpty() && nonNested.isEmpty()) {
                notProcessedAppliesToAll.addAll(appliesToAll);
            }
            return new GroupedSourceReferences(mappingsKeyedByProperty, nonNested, notProcessedAppliesToAll, sourceParameterMappings);
        }

        private List<Mapping> extractSingleTargetReferencesToUseAndPopulateSourceParameterMappings(List<Mapping> singleTargetReferences, List<Mapping> sourceParameterMappings, boolean hasNoMappings, Parameter sourceParameter) {
            ArrayList<Mapping> singleTargetReferencesToUse = null;
            if (singleTargetReferences != null) {
                singleTargetReferencesToUse = new ArrayList<Mapping>(singleTargetReferences.size());
                for (Mapping mapping : singleTargetReferences) {
                    if (mapping.getSourceReference() == null || !mapping.getSourceReference().isValid() || !sourceParameter.equals(mapping.getSourceReference().getParameter())) continue;
                    if (hasNoMappings && mapping.getSourceReference().getPropertyEntries().isEmpty()) {
                        sourceParameterMappings.add(mapping);
                        continue;
                    }
                    singleTargetReferencesToUse.add(mapping);
                }
            }
            return singleTargetReferencesToUse;
        }

        private Map<String, List<Mapping>> groupByTargetName(List<Mapping> mappingList) {
            LinkedHashMap<String, List<Mapping>> result = new LinkedHashMap<String, List<Mapping>>();
            for (Mapping mapping : mappingList) {
                if (!result.containsKey(mapping.getTargetName())) {
                    result.put(mapping.getTargetName(), new ArrayList());
                }
                ((List)result.get(mapping.getTargetName())).add(mapping);
            }
            return result;
        }

        private PropertyMapping createPropertyMappingForNestedTarget(MappingOptions mappingOptions, PropertyEntry targetProperty, SourceReference sourceReference, boolean forceUpdateMethod) {
            PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.mappingContext)).sourceMethod(this.method)).targetProperty(targetProperty)).targetPropertyName(targetProperty.getName())).sourceReference(sourceReference).existingVariableNames(this.existingVariableNames)).dependsOn(mappingOptions.collectNestedDependsOn())).forgeMethodWithMappingOptions(mappingOptions).forceUpdateMethod(forceUpdateMethod).forgedNamedBased(false).build();
            return propertyMapping;
        }

        private <K> void populateWithSingleTargetReferences(Map<K, List<Mapping>> map, List<Mapping> singleTargetReferences, Extractor<SourceReference, K> keyExtractor) {
            if (singleTargetReferences != null) {
                for (Mapping mapping : singleTargetReferences) {
                    K key;
                    if (mapping.getSourceReference() == null || !mapping.getSourceReference().isValid() || (key = keyExtractor.apply(mapping.getSourceReference())) == null || map.containsKey(key)) continue;
                    map.put(key, new ArrayList());
                }
            }
        }
    }
}

