/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.Services;
import org.mapstruct.ap.spi.AccessorNamingStrategy;
import org.mapstruct.ap.spi.AstModifyingAnnotationProcessor;
import org.mapstruct.ap.spi.BuilderProvider;
import org.mapstruct.ap.spi.DefaultAccessorNamingStrategy;
import org.mapstruct.ap.spi.DefaultBuilderProvider;
import org.mapstruct.ap.spi.FreeBuilderAccessorNamingStrategy;
import org.mapstruct.ap.spi.ImmutablesAccessorNamingStrategy;
import org.mapstruct.ap.spi.ImmutablesBuilderProvider;
import org.mapstruct.ap.spi.MapStructProcessingEnvironment;

public class AnnotationProcessorContext
implements MapStructProcessingEnvironment {
    private List<AstModifyingAnnotationProcessor> astModifyingAnnotationProcessors = Collections.unmodifiableList(AnnotationProcessorContext.findAstModifyingAnnotationProcessors());
    private BuilderProvider builderProvider;
    private AccessorNamingStrategy accessorNamingStrategy;
    private boolean initialized;
    private AccessorNamingUtils accessorNaming;
    private Elements elementUtils;
    private Types typeUtils;

    public AnnotationProcessorContext(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    private void initialize() {
        DefaultBuilderProvider defaultBuilderProvider;
        DefaultAccessorNamingStrategy defaultAccessorNamingStrategy;
        if (this.initialized) {
            return;
        }
        if (this.elementUtils.getTypeElement("org.immutables.value.Value.Immutable") != null) {
            defaultAccessorNamingStrategy = new ImmutablesAccessorNamingStrategy();
            defaultBuilderProvider = new ImmutablesBuilderProvider();
        } else if (this.elementUtils.getTypeElement("org.inferred.freebuilder.FreeBuilder") != null) {
            defaultAccessorNamingStrategy = new FreeBuilderAccessorNamingStrategy();
            defaultBuilderProvider = new DefaultBuilderProvider();
        } else {
            defaultAccessorNamingStrategy = new DefaultAccessorNamingStrategy();
            defaultBuilderProvider = new DefaultBuilderProvider();
        }
        this.accessorNamingStrategy = Services.get(AccessorNamingStrategy.class, defaultAccessorNamingStrategy);
        this.accessorNamingStrategy.init(this);
        this.builderProvider = Services.get(BuilderProvider.class, defaultBuilderProvider);
        this.builderProvider.init(this);
        this.accessorNaming = new AccessorNamingUtils(this.accessorNamingStrategy);
        this.initialized = true;
    }

    private static List<AstModifyingAnnotationProcessor> findAstModifyingAnnotationProcessors() {
        ArrayList<AstModifyingAnnotationProcessor> processors = new ArrayList<AstModifyingAnnotationProcessor>();
        ServiceLoader<AstModifyingAnnotationProcessor> loader = ServiceLoader.load(AstModifyingAnnotationProcessor.class, AnnotationProcessorContext.class.getClassLoader());
        Iterator<AstModifyingAnnotationProcessor> it = loader.iterator();
        while (it.hasNext()) {
            processors.add(it.next());
        }
        return processors;
    }

    @Override
    public Elements getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public Types getTypeUtils() {
        return this.typeUtils;
    }

    public List<AstModifyingAnnotationProcessor> getAstModifyingAnnotationProcessors() {
        return this.astModifyingAnnotationProcessors;
    }

    public AccessorNamingUtils getAccessorNaming() {
        this.initialize();
        return this.accessorNaming;
    }

    public AccessorNamingStrategy getAccessorNamingStrategy() {
        this.initialize();
        return this.accessorNamingStrategy;
    }

    public BuilderProvider getBuilderProvider() {
        this.initialize();
        return this.builderProvider;
    }
}

