/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.type.TypeKind;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.Constructor;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.version.VersionInformation;

public abstract class GeneratedType
extends ModelElement {
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private final String packageName;
    private final String name;
    private final Type mapperDefinitionType;
    private final List<Annotation> annotations;
    private final List<MappingMethod> methods;
    private final SortedSet<Type> extraImportedTypes;
    private final boolean suppressGeneratorTimestamp;
    private final boolean suppressGeneratorVersionComment;
    private final VersionInformation versionInformation;
    private final Accessibility accessibility;
    private List<Field> fields;
    private Constructor constructor;
    private final Type generatedType;
    private final boolean generatedTypeAvailable;

    protected GeneratedType(TypeFactory typeFactory, String packageName, String name, Type mapperDefinitionType, List<MappingMethod> methods, List<Field> fields, Options options, VersionInformation versionInformation, boolean suppressGeneratorTimestamp, Accessibility accessibility, SortedSet<Type> extraImportedTypes, Constructor constructor) {
        this.packageName = packageName;
        this.name = name;
        this.mapperDefinitionType = mapperDefinitionType;
        this.extraImportedTypes = extraImportedTypes;
        this.annotations = new ArrayList<Annotation>();
        this.methods = methods;
        this.fields = fields;
        this.suppressGeneratorTimestamp = suppressGeneratorTimestamp;
        this.suppressGeneratorVersionComment = options.isSuppressGeneratorVersionComment();
        this.versionInformation = versionInformation;
        this.accessibility = accessibility;
        if (versionInformation.isSourceVersionAtLeast9() && typeFactory.isTypeAvailable("javax.annotation.processing.Generated")) {
            this.generatedType = typeFactory.getType("javax.annotation.processing.Generated");
            this.generatedTypeAvailable = true;
        } else if (typeFactory.isTypeAvailable("javax.annotation.Generated")) {
            this.generatedType = typeFactory.getType("javax.annotation.Generated");
            this.generatedTypeAvailable = true;
        } else {
            this.generatedType = null;
            this.generatedTypeAvailable = false;
        }
        this.constructor = constructor;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean hasPackageName() {
        return !Strings.isEmpty(this.packageName);
    }

    public String getName() {
        return this.name;
    }

    public Type getMapperDefinitionType() {
        return this.mapperDefinitionType;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public List<MappingMethod> getMethods() {
        return this.methods;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public boolean isSuppressGeneratorTimestamp() {
        return this.suppressGeneratorTimestamp;
    }

    public boolean isSuppressGeneratorVersionComment() {
        return this.suppressGeneratorVersionComment;
    }

    public boolean isGeneratedTypeAvailable() {
        return this.generatedTypeAvailable;
    }

    public VersionInformation getVersionInformation() {
        return this.versionInformation;
    }

    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public SortedSet<Type> getImportTypes() {
        TreeSet<Type> importedTypes = new TreeSet<Type>();
        this.addIfImportRequired(importedTypes, this.generatedType);
        this.addIfImportRequired(importedTypes, this.mapperDefinitionType);
        for (MappingMethod mappingMethod : this.methods) {
            for (Type type : mappingMethod.getImportTypes()) {
                this.addIfImportRequired(importedTypes, type);
            }
        }
        for (Field field : this.fields) {
            if (!field.isTypeRequiresImport()) continue;
            for (Type type : field.getImportTypes()) {
                this.addIfImportRequired(importedTypes, type);
            }
        }
        for (Annotation annotation : this.annotations) {
            this.addIfImportRequired(importedTypes, annotation.getType());
        }
        for (Type extraImport : this.extraImportedTypes) {
            this.addIfImportRequired(importedTypes, extraImport);
        }
        if (this.constructor != null) {
            for (Type type : this.constructor.getImportTypes()) {
                this.addIfImportRequired(importedTypes, type);
            }
        }
        return importedTypes;
    }

    public SortedSet<String> getImportTypeNames() {
        TreeSet<String> importTypeNames = new TreeSet<String>();
        for (Type type : this.getImportTypes()) {
            importTypeNames.add(type.getImportName());
        }
        return importTypeNames;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void removeConstructor() {
        this.constructor = null;
    }

    protected void addIfImportRequired(Collection<Type> collection, Type typeToAdd) {
        if (typeToAdd == null) {
            return;
        }
        for (Type type : typeToAdd.getImportTypes()) {
            if (!this.needsImportDeclaration(type)) continue;
            collection.add(type);
        }
    }

    private boolean needsImportDeclaration(Type typeToAdd) {
        if (!typeToAdd.isToBeImported()) {
            return false;
        }
        if (typeToAdd.getTypeMirror().getKind() != TypeKind.DECLARED && !typeToAdd.isArrayType()) {
            return false;
        }
        if (typeToAdd.getPackageName() != null) {
            if (typeToAdd.getPackageName().equals(JAVA_LANG_PACKAGE)) {
                return false;
            }
            if (typeToAdd.getPackageName().equals(this.packageName) && (typeToAdd.getTypeElement() != null ? !typeToAdd.getTypeElement().getNestingKind().isNested() : typeToAdd.getComponentType() != null && !typeToAdd.getComponentType().getTypeElement().getNestingKind().isNested())) {
                return false;
            }
        }
        return true;
    }

    protected static abstract class GeneratedTypeBuilder<T extends GeneratedTypeBuilder> {
        private T myself;
        protected TypeFactory typeFactory;
        protected ElementUtils elementUtils;
        protected Options options;
        protected VersionInformation versionInformation;
        protected SortedSet<Type> extraImportedTypes;
        protected List<MappingMethod> methods;

        GeneratedTypeBuilder(Class<T> selfType) {
            this.myself = (GeneratedTypeBuilder)selfType.cast(this);
        }

        public T elementUtils(ElementUtils elementUtils) {
            this.elementUtils = elementUtils;
            return this.myself;
        }

        public T typeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this.myself;
        }

        public T options(Options options) {
            this.options = options;
            return this.myself;
        }

        public T versionInformation(VersionInformation versionInformation) {
            this.versionInformation = versionInformation;
            return this.myself;
        }

        public T extraImports(SortedSet<Type> extraImportedTypes) {
            this.extraImportedTypes = extraImportedTypes;
            return this.myself;
        }

        public T methods(List<MappingMethod> methods) {
            this.methods = methods;
            return this.myself;
        }
    }
}

