/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.ParameterBinding;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionContext;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;

public class TypeSelector
implements MethodSelector {
    private FormattingMessager messager;

    public TypeSelector(FormattingMessager messager) {
        this.messager = messager;
    }

    @Override
    public <T extends Method> List<SelectedMethod<T>> getMatchingMethods(List<SelectedMethod<T>> methods, SelectionContext context) {
        if (methods.isEmpty()) {
            return methods;
        }
        Type returnType = context.getReturnType();
        ArrayList<SelectedMethod<T>> result = new ArrayList<SelectedMethod<T>>();
        List<ParameterBinding> availableBindings = context.getAvailableParameterBindings();
        for (SelectedMethod<T> method : methods) {
            SelectedMethod<T> matchingMethod;
            List<List<ParameterBinding>> parameterBindingPermutations = TypeSelector.getCandidateParameterBindingPermutations(availableBindings, method.getMethod().getParameters());
            if (parameterBindingPermutations == null || (matchingMethod = this.getMatchingParameterBinding(returnType, context, method, parameterBindingPermutations)) == null) continue;
            result.add(matchingMethod);
        }
        return result;
    }

    private <T extends Method> SelectedMethod<T> getMatchingParameterBinding(Type returnType, SelectionContext context, SelectedMethod<T> selectedMethodInfo, List<List<ParameterBinding>> parameterAssignmentVariants) {
        ArrayList<List<ParameterBinding>> matchingParameterAssignmentVariants = new ArrayList<List<ParameterBinding>>(parameterAssignmentVariants);
        Object selectedMethod = selectedMethodInfo.getMethod();
        matchingParameterAssignmentVariants.removeIf(parameterAssignments -> !selectedMethod.matches(TypeSelector.extractTypes(parameterAssignments), returnType));
        if (matchingParameterAssignmentVariants.isEmpty()) {
            return null;
        }
        if (matchingParameterAssignmentVariants.size() == 1) {
            selectedMethodInfo.setParameterBindings(Collections.first(matchingParameterAssignmentVariants));
            return selectedMethodInfo;
        }
        List<Parameter> methodParameters = selectedMethod.getParameters();
        matchingParameterAssignmentVariants.removeIf(parameterBindings -> this.parameterBindingNotMatchesParameterVariableNames((List<ParameterBinding>)parameterBindings, methodParameters));
        if (matchingParameterAssignmentVariants.isEmpty()) {
            this.messager.printMessage((Element)selectedMethod.getExecutable(), Message.LIFECYCLEMETHOD_AMBIGUOUS_PARAMETERS, context.getMappingMethod());
            return null;
        }
        selectedMethodInfo.setParameterBindings(Collections.first(matchingParameterAssignmentVariants));
        return selectedMethodInfo;
    }

    private boolean parameterBindingNotMatchesParameterVariableNames(List<ParameterBinding> parameterBindings, List<Parameter> parameters) {
        if (parameterBindings.size() != parameters.size()) {
            return true;
        }
        int i = 0;
        for (ParameterBinding parameterBinding : parameterBindings) {
            Parameter parameter = parameters.get(i++);
            if (parameterBinding.getVariableName() == null || parameter.getName().equals(parameterBinding.getVariableName())) continue;
            return true;
        }
        return false;
    }

    private static List<List<ParameterBinding>> getCandidateParameterBindingPermutations(List<ParameterBinding> availableParams, List<Parameter> methodParameters) {
        if (methodParameters.size() > availableParams.size()) {
            return null;
        }
        ArrayList<List<ParameterBinding>> bindingPermutations = new ArrayList<List<ParameterBinding>>(1);
        bindingPermutations.add(new ArrayList(methodParameters.size()));
        for (Parameter methodParam : methodParameters) {
            List<ParameterBinding> candidateBindings = TypeSelector.findCandidateBindingsForParameter(availableParams, methodParam);
            if (candidateBindings.isEmpty()) {
                return null;
            }
            if (candidateBindings.size() == 1) {
                for (List list : bindingPermutations) {
                    list.add(Collections.first(candidateBindings));
                }
                continue;
            }
            ArrayList newVariants = new ArrayList(bindingPermutations.size() * candidateBindings.size());
            for (List list : bindingPermutations) {
                for (ParameterBinding binding : candidateBindings) {
                    ArrayList<ParameterBinding> extendedVariant = new ArrayList<ParameterBinding>(methodParameters.size());
                    extendedVariant.addAll(list);
                    extendedVariant.add(binding);
                    newVariants.add(extendedVariant);
                }
            }
            bindingPermutations = newVariants;
        }
        return bindingPermutations;
    }

    private static List<ParameterBinding> findCandidateBindingsForParameter(List<ParameterBinding> candidateParameters, Parameter parameter) {
        ArrayList<ParameterBinding> result = new ArrayList<ParameterBinding>(candidateParameters.size());
        for (ParameterBinding candidate : candidateParameters) {
            if (parameter.isTargetType() != candidate.isTargetType() || parameter.isMappingTarget() != candidate.isMappingTarget() || parameter.isMappingContext() != candidate.isMappingContext() || parameter.isTargetPropertyName() != candidate.isTargetPropertyName()) continue;
            result.add(candidate);
        }
        return result;
    }

    private static List<Type> extractTypes(List<ParameterBinding> parameters) {
        return parameters.stream().map(ParameterBinding::getType).collect(Collectors.toList());
    }
}

