/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.discovery.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class JsonUtils {
    private static Gson gson = new Gson();

    public static JsonElement getAsArray(Set<String> value) {
        return gson.toJsonTree(value, new TypeToken<Set<String>>(){}.getType());
    }

    public static Date getAsDate(JsonObject o, String member) {
        if (o.has(member)) {
            JsonElement e = o.get(member);
            if (e != null && e.isJsonPrimitive()) {
                return new Date((long)e.getAsInt() * 1000L);
            }
            return null;
        }
        return null;
    }

    public static JWEAlgorithm getAsJweAlgorithm(JsonObject o, String member) {
        String s = JsonUtils.getAsString(o, member);
        if (s != null) {
            return JWEAlgorithm.parse((String)s);
        }
        return null;
    }

    public static EncryptionMethod getAsJweEncryptionMethod(JsonObject o, String member) {
        String s = JsonUtils.getAsString(o, member);
        if (s != null) {
            return EncryptionMethod.parse((String)s);
        }
        return null;
    }

    public static JWSAlgorithm getAsJwsAlgorithm(JsonObject o, String member) {
        String s = JsonUtils.getAsString(o, member);
        if (s != null) {
            return JWSAlgorithm.parse((String)s);
        }
        return null;
    }

    public static String getAsString(JsonObject o, String member) {
        if (o.has(member)) {
            JsonElement e = o.get(member);
            if (e != null && e.isJsonPrimitive()) {
                return e.getAsString();
            }
            return null;
        }
        return null;
    }

    public static Boolean getAsBoolean(JsonObject o, String member) {
        if (o.has(member)) {
            JsonElement e = o.get(member);
            if (e != null && e.isJsonPrimitive()) {
                return e.getAsBoolean();
            }
            return null;
        }
        return null;
    }

    public static Set<String> getAsStringSet(JsonObject o, String member) throws JsonSyntaxException {
        if (o.has(member)) {
            if (o.get(member).isJsonArray()) {
                return (Set)gson.fromJson(o.get(member), new TypeToken<Set<String>>(){}.getType());
            }
            return Sets.newHashSet((Object[])new String[]{o.get(member).getAsString()});
        }
        return null;
    }

    public static List<String> getAsStringList(JsonObject o, String member) throws JsonSyntaxException {
        if (o.has(member)) {
            if (o.get(member).isJsonArray()) {
                return (List)gson.fromJson(o.get(member), new TypeToken<List<String>>(){}.getType());
            }
            return Lists.newArrayList((Object[])new String[]{o.get(member).getAsString()});
        }
        return null;
    }

    public static List<JWSAlgorithm> getAsJwsAlgorithmList(JsonObject o, String member) {
        List<String> strings = JsonUtils.getAsStringList(o, member);
        if (strings != null) {
            ArrayList<JWSAlgorithm> algs = new ArrayList<JWSAlgorithm>();
            for (String alg : strings) {
                algs.add(JWSAlgorithm.parse((String)alg));
            }
            return algs;
        }
        return null;
    }

    public static List<JWEAlgorithm> getAsJweAlgorithmList(JsonObject o, String member) {
        List<String> strings = JsonUtils.getAsStringList(o, member);
        if (strings != null) {
            ArrayList<JWEAlgorithm> algs = new ArrayList<JWEAlgorithm>();
            for (String alg : strings) {
                algs.add(JWEAlgorithm.parse((String)alg));
            }
            return algs;
        }
        return null;
    }

    public static List<EncryptionMethod> getAsEncryptionMethodList(JsonObject o, String member) {
        List<String> strings = JsonUtils.getAsStringList(o, member);
        if (strings != null) {
            ArrayList<EncryptionMethod> algs = new ArrayList<EncryptionMethod>();
            for (String alg : strings) {
                algs.add(EncryptionMethod.parse((String)alg));
            }
            return algs;
        }
        return null;
    }
}

