/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;

@Entity
@Table(name="access_token")
@NamedQueries(value={@NamedQuery(name="OAuth2AccessTokenEntity.getAll", query="select a from OAuth2AccessTokenEntity a"), @NamedQuery(name="OAuth2AccessTokenEntity.getAllExpiredByDate", query="select a from OAuth2AccessTokenEntity a where a.expiration <= :date"), @NamedQuery(name="OAuth2AccessTokenEntity.getByRefreshToken", query="select a from OAuth2AccessTokenEntity a where a.refreshToken = :refreshToken"), @NamedQuery(name="OAuth2AccessTokenEntity.getByClient", query="select a from OAuth2AccessTokenEntity a where a.client = :client"), @NamedQuery(name="OAuth2AccessTokenEntity.getByAuthentication", query="select a from OAuth2AccessTokenEntity a where a.authenticationHolder.authentication = :authentication"), @NamedQuery(name="OAuth2AccessTokenEntity.getByIdToken", query="select a from OAuth2AccessTokenEntity a where a.idToken = :idToken"), @NamedQuery(name="OAuth2AccessTokenEntity.getByTokenValue", query="select a from OAuth2AccessTokenEntity a where a.value = :tokenValue")})
public class OAuth2AccessTokenEntity
implements OAuth2AccessToken {
    public static String ID_TOKEN_FIELD_NAME = "id_token";
    private Long id;
    private ClientDetailsEntity client;
    private AuthenticationHolderEntity authenticationHolder;
    private JWT jwtValue;
    private OAuth2AccessTokenEntity idToken;
    private Date expiration;
    private String tokenType = "Bearer";
    private OAuth2RefreshTokenEntity refreshToken;
    private Set<String> scope;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Transient
    public Map<String, Object> getAdditionalInformation() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.getIdToken() != null) {
            map.put(ID_TOKEN_FIELD_NAME, this.getIdTokenString());
        }
        return map;
    }

    @ManyToOne
    @JoinColumn(name="auth_holder_id")
    public AuthenticationHolderEntity getAuthenticationHolder() {
        return this.authenticationHolder;
    }

    public void setAuthenticationHolder(AuthenticationHolderEntity authenticationHolder) {
        this.authenticationHolder = authenticationHolder;
    }

    @ManyToOne
    @JoinColumn(name="client_id")
    public ClientDetailsEntity getClient() {
        return this.client;
    }

    public void setClient(ClientDetailsEntity client) {
        this.client = client;
    }

    @Basic
    @Column(name="token_value")
    public String getValue() {
        return this.jwtValue.serialize();
    }

    public void setValue(String value) throws ParseException {
        this.setJwt(JWTParser.parse((String)value));
    }

    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    @Basic
    @Column(name="token_type")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @ManyToOne
    @JoinColumn(name="refresh_token_id")
    public OAuth2RefreshTokenEntity getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setRefreshToken(OAuth2RefreshToken refreshToken) {
        if (!(refreshToken instanceof OAuth2RefreshTokenEntity)) {
            throw new IllegalArgumentException("Not a storable refresh token entity!");
        }
        this.setRefreshToken((OAuth2RefreshTokenEntity)refreshToken);
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(joinColumns={@JoinColumn(name="owner_id")}, name="token_scope")
    public Set<String> getScope() {
        return this.scope;
    }

    public void setScope(Set<String> scope) {
        this.scope = scope;
    }

    @Transient
    public boolean isExpired() {
        return this.getExpiration() == null ? false : System.currentTimeMillis() > this.getExpiration().getTime();
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="id_token_id")
    public OAuth2AccessTokenEntity getIdToken() {
        return this.idToken;
    }

    public void setIdToken(OAuth2AccessTokenEntity idToken) {
        this.idToken = idToken;
    }

    @Transient
    public String getIdTokenString() {
        if (this.idToken != null) {
            return this.idToken.getValue();
        }
        return null;
    }

    @Transient
    public JWT getJwt() {
        return this.jwtValue;
    }

    public void setJwt(JWT jwt) {
        this.jwtValue = jwt;
    }

    @Transient
    public int getExpiresIn() {
        if (this.getExpiration() == null) {
            return -1;
        }
        int secondsRemaining = (int)((this.getExpiration().getTime() - System.currentTimeMillis()) / 1000L);
        if (this.isExpired()) {
            return 0;
        }
        return secondsRemaining;
    }
}

