/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;

@Entity
@Table(name="refresh_token")
@NamedQueries(value={@NamedQuery(name="OAuth2RefreshTokenEntity.getAll", query="select r from OAuth2RefreshTokenEntity r"), @NamedQuery(name="OAuth2RefreshTokenEntity.getAllExpiredByDate", query="select r from OAuth2RefreshTokenEntity r where r.expiration <= :date"), @NamedQuery(name="OAuth2RefreshTokenEntity.getByClient", query="select r from OAuth2RefreshTokenEntity r where r.client = :client"), @NamedQuery(name="OAuth2RefreshTokenEntity.getByTokenValue", query="select r from OAuth2RefreshTokenEntity r where r.value = :tokenValue"), @NamedQuery(name="OAuth2RefreshTokenEntity.getByAuthentication", query="select r from OAuth2RefreshTokenEntity r where r.authenticationHolder.authentication = :authentication")})
public class OAuth2RefreshTokenEntity
implements OAuth2RefreshToken {
    private Long id;
    private AuthenticationHolderEntity authenticationHolder;
    private ClientDetailsEntity client;
    private JWT jwt;
    private Date expiration;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="auth_holder_id")
    public AuthenticationHolderEntity getAuthenticationHolder() {
        return this.authenticationHolder;
    }

    public void setAuthenticationHolder(AuthenticationHolderEntity authenticationHolder) {
        this.authenticationHolder = authenticationHolder;
    }

    @Basic
    @Column(name="token_value")
    public String getValue() {
        return this.jwt.serialize();
    }

    public void setValue(String value) throws ParseException {
        this.setJwt(JWTParser.parse((String)value));
    }

    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    @Transient
    public boolean isExpired() {
        return this.getExpiration() == null ? false : System.currentTimeMillis() > this.getExpiration().getTime();
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="client_id")
    public ClientDetailsEntity getClient() {
        return this.client;
    }

    public void setClient(ClientDetailsEntity client) {
        this.client = client;
    }

    @Transient
    public JWT getJwt() {
        return this.jwt;
    }

    public void setJwt(JWT jwt) {
        this.jwt = jwt;
    }
}

