/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.mitre.discovery.util.JsonUtils;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.RegisteredClient;

public class ClientDetailsEntityJsonProcessor {
    private static JsonParser parser = new JsonParser();

    public static ClientDetailsEntity parse(String jsonString) {
        JsonElement jsonEl = parser.parse(jsonString);
        return ClientDetailsEntityJsonProcessor.parse(jsonEl);
    }

    public static ClientDetailsEntity parse(JsonElement jsonEl) {
        if (jsonEl.isJsonObject()) {
            String scope;
            JsonObject o = jsonEl.getAsJsonObject();
            ClientDetailsEntity c = new ClientDetailsEntity();
            c.setClientId(JsonUtils.getAsString(o, "client_id"));
            c.setClientSecret(JsonUtils.getAsString(o, "client_secret"));
            c.setRedirectUris(JsonUtils.getAsStringSet(o, "redirect_uris"));
            c.setClientName(JsonUtils.getAsString(o, "client_name"));
            c.setClientUri(JsonUtils.getAsString(o, "client_uri"));
            c.setLogoUri(JsonUtils.getAsString(o, "logo_uri"));
            c.setContacts(JsonUtils.getAsStringSet(o, "contacts"));
            c.setTosUri(JsonUtils.getAsString(o, "tos_uri"));
            String authMethod = JsonUtils.getAsString(o, "token_endpoint_auth_method");
            if (authMethod != null) {
                c.setTokenEndpointAuthMethod(ClientDetailsEntity.AuthMethod.getByValue(authMethod));
            }
            if ((scope = JsonUtils.getAsString(o, "scope")) != null) {
                c.setScope(Sets.newHashSet((Iterable)Splitter.on((String)" ").split((CharSequence)scope)));
            }
            c.setGrantTypes(JsonUtils.getAsStringSet(o, "grant_types"));
            c.setResponseTypes(JsonUtils.getAsStringSet(o, "response_types"));
            c.setPolicyUri(JsonUtils.getAsString(o, "policy_uri"));
            c.setJwksUri(JsonUtils.getAsString(o, "jwks_uri"));
            String appType = JsonUtils.getAsString(o, "application_type");
            if (appType != null) {
                c.setApplicationType(ClientDetailsEntity.AppType.getByValue(appType));
            }
            c.setSectorIdentifierUri(JsonUtils.getAsString(o, "sector_identifier_uri"));
            String subjectType = JsonUtils.getAsString(o, "subject_type");
            if (subjectType != null) {
                c.setSubjectType(ClientDetailsEntity.SubjectType.getByValue(subjectType));
            }
            c.setRequestObjectSigningAlg(JsonUtils.getAsJwsAlgorithm(o, "request_object_signing_alg"));
            c.setUserInfoSignedResponseAlg(JsonUtils.getAsJwsAlgorithm(o, "userinfo_signed_response_alg"));
            c.setUserInfoEncryptedResponseAlg(JsonUtils.getAsJweAlgorithm(o, "userinfo_encrypted_response_alg"));
            c.setUserInfoEncryptedResponseEnc(JsonUtils.getAsJweEncryptionMethod(o, "userinfo_encrypted_response_enc"));
            c.setIdTokenSignedResponseAlg(JsonUtils.getAsJwsAlgorithm(o, "id_token_signed_response_alg"));
            c.setIdTokenEncryptedResponseAlg(JsonUtils.getAsJweAlgorithm(o, "id_token_encrypted_response_alg"));
            c.setIdTokenEncryptedResponseEnc(JsonUtils.getAsJweEncryptionMethod(o, "id_token_encrypted_response_enc"));
            c.setTokenEndpointAuthSigningAlg(JsonUtils.getAsJwsAlgorithm(o, "token_endpoint_auth_signing_alg"));
            if (o.has("default_max_age") && o.get("default_max_age").isJsonPrimitive()) {
                c.setDefaultMaxAge(o.get("default_max_age").getAsInt());
            }
            if (o.has("require_auth_time") && o.get("require_auth_time").isJsonPrimitive()) {
                c.setRequireAuthTime(o.get("require_auth_time").getAsBoolean());
            }
            c.setDefaultACRvalues(JsonUtils.getAsStringSet(o, "default_acr_values"));
            c.setInitiateLoginUri(JsonUtils.getAsString(o, "initiate_login_uri"));
            c.setPostLogoutRedirectUri(JsonUtils.getAsString(o, "post_logout_redirect_uri"));
            c.setRequestUris(JsonUtils.getAsStringSet(o, "request_uris"));
            return c;
        }
        return null;
    }

    public static RegisteredClient parseRegistered(String jsonString) {
        JsonElement jsonEl = parser.parse(jsonString);
        return ClientDetailsEntityJsonProcessor.parseRegistered(jsonEl);
    }

    public static RegisteredClient parseRegistered(JsonElement jsonEl) {
        if (jsonEl.isJsonObject()) {
            JsonObject o = jsonEl.getAsJsonObject();
            ClientDetailsEntity c = ClientDetailsEntityJsonProcessor.parse(jsonEl);
            RegisteredClient rc = new RegisteredClient(c);
            rc.setRegistrationAccessToken(JsonUtils.getAsString(o, "registration_access_token"));
            rc.setRegistrationClientUri(JsonUtils.getAsString(o, "registration_client_uri"));
            rc.setClientIdIssuedAt(JsonUtils.getAsDate(o, "client_id_issued_at"));
            rc.setClientSecretExpiresAt(JsonUtils.getAsDate(o, "client_secret_expires_at"));
            return rc;
        }
        return null;
    }

    public static JsonObject serialize(RegisteredClient c) {
        JsonObject o = new JsonObject();
        o.addProperty("client_id", c.getClientId());
        if (c.getClientSecret() != null) {
            o.addProperty("client_secret", c.getClientSecret());
            if (c.getClientSecretExpiresAt() == null) {
                o.addProperty("client_secret_expires_at", (Number)0);
            } else {
                o.addProperty("client_secret_expires_at", (Number)(c.getClientSecretExpiresAt().getTime() / 1000L));
            }
        }
        if (c.getClientIdIssuedAt() != null) {
            o.addProperty("client_id_issued_at", (Number)(c.getClientIdIssuedAt().getTime() / 1000L));
        } else if (c.getCreatedAt() != null) {
            o.addProperty("client_id_issued_at", (Number)(c.getCreatedAt().getTime() / 1000L));
        }
        if (c.getRegistrationAccessToken() != null) {
            o.addProperty("registration_access_token", c.getRegistrationAccessToken());
        }
        if (c.getRegistrationClientUri() != null) {
            o.addProperty("registration_client_uri", c.getRegistrationClientUri());
        }
        o.add("redirect_uris", JsonUtils.getAsArray(c.getRedirectUris()));
        o.addProperty("client_name", c.getClientName());
        o.addProperty("client_uri", c.getClientUri());
        o.addProperty("logo_uri", c.getLogoUri());
        o.add("contacts", JsonUtils.getAsArray(c.getContacts()));
        o.addProperty("tos_uri", c.getTosUri());
        o.addProperty("token_endpoint_auth_method", c.getTokenEndpointAuthMethod() != null ? c.getTokenEndpointAuthMethod().getValue() : null);
        o.addProperty("scope", c.getScope() != null ? Joiner.on((String)" ").join(c.getScope()) : null);
        o.add("grant_types", JsonUtils.getAsArray(c.getGrantTypes()));
        o.add("response_types", JsonUtils.getAsArray(c.getResponseTypes()));
        o.addProperty("policy_uri", c.getPolicyUri());
        o.addProperty("jwks_uri", c.getJwksUri());
        o.addProperty("application_type", c.getApplicationType() != null ? c.getApplicationType().getValue() : null);
        o.addProperty("sector_identifier_uri", c.getSectorIdentifierUri());
        o.addProperty("subject_type", c.getSubjectType() != null ? c.getSubjectType().getValue() : null);
        o.addProperty("request_object_signing_alg", c.getRequestObjectSigningAlg() != null ? c.getRequestObjectSigningAlg().getName() : null);
        o.addProperty("userinfo_signed_response_alg", c.getUserInfoSignedResponseAlg() != null ? c.getUserInfoSignedResponseAlg().getName() : null);
        o.addProperty("userinfo_encrypted_response_alg", c.getUserInfoEncryptedResponseAlg() != null ? c.getUserInfoEncryptedResponseAlg().getName() : null);
        o.addProperty("userinfo_encrypted_response_enc", c.getUserInfoEncryptedResponseEnc() != null ? c.getUserInfoEncryptedResponseEnc().getName() : null);
        o.addProperty("id_token_signed_response_alg", c.getIdTokenSignedResponseAlg() != null ? c.getIdTokenSignedResponseAlg().getName() : null);
        o.addProperty("id_token_encrypted_response_alg", c.getIdTokenEncryptedResponseAlg() != null ? c.getIdTokenEncryptedResponseAlg().getName() : null);
        o.addProperty("id_token_encrypted_response_enc", c.getIdTokenEncryptedResponseEnc() != null ? c.getIdTokenEncryptedResponseEnc().getName() : null);
        o.addProperty("token_endpoint_auth_signing_alg", c.getTokenEndpointAuthSigningAlg() != null ? c.getTokenEndpointAuthSigningAlg().getName() : null);
        o.addProperty("default_max_age", (Number)c.getDefaultMaxAge());
        o.addProperty("require_auth_time", c.getRequireAuthTime());
        o.add("default_acr_values", JsonUtils.getAsArray(c.getDefaultACRvalues()));
        o.addProperty("initiate_login_uri", c.getInitiateLoginUri());
        o.addProperty("post_logout_redirect_uri", c.getPostLogoutRedirectUri());
        o.add("request_uris", JsonUtils.getAsArray(c.getRequestUris()));
        return o;
    }
}

