/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.config;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.util.StringUtils;

public class ConfigurationPropertiesBean {
    private static Logger logger = LoggerFactory.getLogger(ConfigurationPropertiesBean.class);
    private String issuer;
    private String topbarTitle;
    private String logoImageUrl;
    private Long regTokenLifeTime;
    private boolean forceHttps = false;

    @PostConstruct
    public void checkForHttps() {
        if (!StringUtils.startsWithIgnoreCase((String)this.issuer, (String)"https")) {
            if (this.forceHttps) {
                logger.error("Configured issuer url is not using https scheme. Server will be shut down!");
                throw new BeanCreationException("Issuer is not using https scheme as required: " + this.issuer);
            }
            logger.warn("Configured issuer url is not using https scheme.");
        }
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String iss) {
        this.issuer = iss;
    }

    public String getTopbarTitle() {
        return this.topbarTitle;
    }

    public void setTopbarTitle(String topbarTitle) {
        this.topbarTitle = topbarTitle;
    }

    public String getLogoImageUrl() {
        return this.logoImageUrl;
    }

    public void setLogoImageUrl(String logoImageUrl) {
        this.logoImageUrl = logoImageUrl;
    }

    public Long getRegTokenLifeTime() {
        return this.regTokenLifeTime;
    }

    public void setRegTokenLifeTime(Long regTokenLifeTime) {
        this.regTokenLifeTime = regTokenLifeTime;
    }

    public boolean isForceHttps() {
        return this.forceHttps;
    }

    public void setForceHttps(boolean forceHttps) {
        this.forceHttps = forceHttps;
    }
}

