/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.module.jsr310;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import org.modelmapper.Converter;
import org.modelmapper.internal.Errors;
import org.modelmapper.module.jsr310.Jsr310ModuleConfig;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

public class ToTemporalConverter
implements ConditionalConverter<Object, Temporal> {
    private Jsr310ModuleConfig config;
    private final LocalDateTimeConverter localDateTimeConverter = new LocalDateTimeConverter();
    private final ZonedDateTimeConverter zonedDateTimeConverter = new ZonedDateTimeConverter();
    private final LocalDateConverter localDateConverter = new LocalDateConverter();
    private final OffsetDateTimeConverter offsetDateTimeConverter = new OffsetDateTimeConverter();
    private final InstantConverter instantConverter = new InstantConverter();

    public ToTemporalConverter(Jsr310ModuleConfig config) {
        this.config = config;
    }

    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Temporal.class.isAssignableFrom(destinationType) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    public Temporal convert(MappingContext<Object, Temporal> mappingContext) {
        if (mappingContext.getSource() == null) {
            return null;
        }
        Class destinationType = mappingContext.getDestinationType();
        if (LocalDateTime.class.equals((Object)destinationType)) {
            return this.localDateTimeConverter.convert((MappingContext)mappingContext);
        }
        if (LocalDate.class.equals((Object)destinationType)) {
            return this.localDateConverter.convert((MappingContext)mappingContext);
        }
        if (OffsetDateTime.class.equals((Object)destinationType)) {
            return this.offsetDateTimeConverter.convert((MappingContext)mappingContext);
        }
        if (Instant.class.equals((Object)destinationType)) {
            return this.instantConverter.convert((MappingContext)mappingContext);
        }
        if (ZonedDateTime.class.equals((Object)destinationType)) {
            return this.zonedDateTimeConverter.convert((MappingContext)mappingContext);
        }
        throw new Errors().addMessage("Unsupported mapping types[%s->%s]", new Object[]{mappingContext.getSourceType().getName(), destinationType.getName()}).toMappingException();
    }

    private LocalDate convertLocalDate(MappingContext<?, ?> mappingContext) {
        Object source = mappingContext.getSource();
        Class<?> sourceType = source.getClass();
        if (sourceType.equals(String.class)) {
            return LocalDate.parse((String)source, this.config.getDateFormatter());
        }
        return this.convertInstant(mappingContext).atZone(this.config.getZoneId()).toLocalDate();
    }

    private LocalDateTime convertLocalDateTime(MappingContext<?, ?> mappingContext) {
        Object source = mappingContext.getSource();
        Class<?> sourceType = source.getClass();
        if (sourceType.equals(String.class)) {
            return LocalDateTime.parse((String)source, this.config.getDateTimeFormatter());
        }
        return this.convertInstant(mappingContext).atZone(this.config.getZoneId()).toLocalDateTime();
    }

    private ZonedDateTime convertZonedDateTime(MappingContext<?, ?> mappingContext) {
        Object source = mappingContext.getSource();
        Class<?> sourceType = source.getClass();
        if (sourceType.equals(String.class)) {
            return ZonedDateTime.parse((String)source, this.config.getDateTimeOffsetFormatter());
        }
        return this.convertInstant(mappingContext).atZone(this.config.getZoneId());
    }

    private OffsetDateTime convertOffsetDateTime(MappingContext<?, ?> mappingContext) {
        Object source = mappingContext.getSource();
        Class<?> sourceType = source.getClass();
        if (sourceType.equals(String.class)) {
            return OffsetDateTime.parse((String)source, this.config.getDateTimeOffsetFormatter());
        }
        return this.convertInstant(mappingContext).atZone(this.config.getZoneId()).toOffsetDateTime();
    }

    private Instant convertInstant(MappingContext<?, ?> mappingContext) {
        Object source = mappingContext.getSource();
        Class<?> sourceType = source.getClass();
        if (sourceType.equals(String.class)) {
            return LocalDateTime.parse((String)source, this.config.getDateTimeFormatter()).atZone(this.config.getZoneId()).toInstant();
        }
        if (Date.class.isAssignableFrom(sourceType)) {
            return Instant.ofEpochMilli(((Date)source).getTime());
        }
        if (Calendar.class.isAssignableFrom(sourceType)) {
            return Instant.ofEpochMilli(((Calendar)source).getTime().getTime());
        }
        if (Number.class.isAssignableFrom(sourceType)) {
            return Instant.ofEpochMilli(((Number)source).longValue());
        }
        throw new Errors().addMessage("Unsupported mapping types[%s->%s]", new Object[]{sourceType.getName(), mappingContext.getDestinationType().getName()}).toMappingException();
    }

    private class InstantConverter
    implements Converter<Object, Temporal> {
        private InstantConverter() {
        }

        public Temporal convert(MappingContext<Object, Temporal> mappingContext) {
            return ToTemporalConverter.this.convertInstant(mappingContext);
        }
    }

    private class OffsetDateTimeConverter
    implements Converter<Object, Temporal> {
        private OffsetDateTimeConverter() {
        }

        public Temporal convert(MappingContext<Object, Temporal> mappingContext) {
            return ToTemporalConverter.this.convertOffsetDateTime(mappingContext);
        }
    }

    private class LocalDateConverter
    implements Converter<Object, Temporal> {
        private LocalDateConverter() {
        }

        public Temporal convert(MappingContext<Object, Temporal> mappingContext) {
            return ToTemporalConverter.this.convertLocalDate(mappingContext);
        }
    }

    private class ZonedDateTimeConverter
    implements Converter<Object, Temporal> {
        private ZonedDateTimeConverter() {
        }

        public Temporal convert(MappingContext<Object, Temporal> mappingContext) {
            return ToTemporalConverter.this.convertZonedDateTime(mappingContext);
        }
    }

    private class LocalDateTimeConverter
    implements Converter<Object, Temporal> {
        private LocalDateTimeConverter() {
        }

        public Temporal convert(MappingContext<Object, Temporal> mappingContext) {
            return ToTemporalConverter.this.convertLocalDateTime(mappingContext);
        }
    }
}

