/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ninja.Context;
import ninja.Cookie;
import ninja.Result;
import ninja.Route;
import ninja.session.FlashScope;
import ninja.session.Session;
import ninja.utils.ResponseStreams;
import ninja.utils.SwissKnife;
import ninja.validation.Validation;
import ninja.validation.ValidationImpl;
import org.apache.commons.fileupload.FileItemIterator;

public class FakeContext
implements Context {
    private String requestContentType;
    private String requestPath;
    private String contextPath;
    @Deprecated
    private String requestUri;
    private String hostname;
    private String remoteAddr;
    private String scheme;
    private FlashScope flashScope;
    private Session session;
    private List<Cookie> addedCookies = new ArrayList<Cookie>();
    private Map<String, String> cookieValues = new HashMap<String, String>();
    private ListMultimap<String, String> params = ArrayListMultimap.create();
    private Map<String, String> pathParams = new HashMap<String, String>();
    private ListMultimap<String, String> headers = ArrayListMultimap.create();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Object body;
    private Validation validation = new ValidationImpl();
    private String acceptContentType;
    private String acceptEncoding;
    private String acceptLanguage;
    private String acceptCharset;

    public FakeContext setRequestContentType(String requestContentType) {
        this.requestContentType = requestContentType;
        return this;
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    @Deprecated
    public FakeContext setRequestUri(String requestUri) {
        this.requestUri = requestUri;
        return this;
    }

    @Deprecated
    public String getRequestUri() {
        return this.requestUri;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public FakeContext setFlashCookie(FlashScope flashCookie) {
        this.flashScope = flashCookie;
        return this;
    }

    public FakeContext setSessionCookie(Session sessionCookie) {
        this.session = sessionCookie;
        return this;
    }

    public Session getSessionCookie() {
        return this.session;
    }

    public FlashScope getFlashCookie() {
        return this.flashScope;
    }

    public Session getSession() {
        return this.session;
    }

    public FlashScope getFlashScope() {
        return this.flashScope;
    }

    public FakeContext addParameter(String key, String value) {
        this.params.put((Object)key, (Object)value);
        return this;
    }

    public String getParameter(String key) {
        return (String)Iterables.getFirst((Iterable)this.params.get((Object)key), null);
    }

    public List<String> getParameterValues(String name) {
        return this.params.get((Object)name);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Integer getParameterAsInteger(String key) {
        String value = this.getParameter(key);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public Integer getParameterAsInteger(String key, Integer defaultValue) {
        String value = this.getParameter(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public <T> T getParameterAs(String key, Class<T> clazz) {
        return this.getParameterAs(key, clazz, null);
    }

    public <T> T getParameterAs(String key, Class<T> clazz, T defaultValue) {
        try {
            return (T)SwissKnife.convert((String)key, clazz);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public FakeContext addPathParameter(String key, String value) {
        this.pathParams.put(key, value);
        return this;
    }

    public String getPathParameter(String key) {
        return this.pathParams.get(key);
    }

    public Integer getPathParameterAsInteger(String key) {
        String value = this.getParameter(key);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public Map<String, String[]> getParameters() {
        return Maps.transformValues((Map)this.params.asMap(), (Function)new Function<Collection<String>, String[]>(){

            public String[] apply(Collection<String> s) {
                return s.toArray(new String[s.size()]);
            }
        });
    }

    public FakeContext addHeader(String name, String value) {
        this.headers.put((Object)name, (Object)value);
        return this;
    }

    public String getHeader(String name) {
        return (String)Iterables.getFirst((Iterable)this.headers.get((Object)name), null);
    }

    public List<String> getHeaders(String name) {
        return this.headers.get((Object)name);
    }

    public Map<String, List<String>> getHeaders() {
        Map rawHeaders = this.headers.asMap();
        return rawHeaders;
    }

    public FakeContext addCookieValue(String name, String value) {
        this.cookieValues.put(name, value);
        return this;
    }

    public String getCookieValue(String name) {
        return this.cookieValues.get(name);
    }

    public FakeContext setBody(Object body) {
        this.body = body;
        return this;
    }

    public <T> T parseBody(Class<T> classOfT) {
        return classOfT.cast(this.body);
    }

    public boolean isMultipart() {
        return false;
    }

    public FileItemIterator getFileItemIterator() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public boolean isAsync() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public void handleAsync() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public void returnResultAsync(Result result) {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public void asyncRequestComplete() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public Result controllerReturned() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public ResponseStreams finalizeHeaders(Result result) {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public ResponseStreams finalizeHeadersWithoutFlashAndSessionCookie(Result result) {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public Route getRoute() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public FakeContext setRequestPath(String path) {
        this.requestPath = path;
        return this;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public Validation getValidation() {
        return this.validation;
    }

    public String getPathParameterEncoded(String name) {
        return this.getPathParameterEncoded(name);
    }

    public void setAcceptContentType(String acceptContentType) {
        this.acceptContentType = acceptContentType;
    }

    public String getAcceptContentType() {
        return this.acceptContentType;
    }

    public void setAcceptEncoding(String acceptEncoding) {
        this.acceptEncoding = acceptEncoding;
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public void setAcceptCharset(String acceptCharset) {
        this.acceptCharset = acceptCharset;
    }

    public String getAcceptCharset() {
        return this.acceptCharset;
    }

    public Cookie getCookie(String cookieName) {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public boolean hasCookie(String cookieName) {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public List<Cookie> getCookies() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public String getMethod() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public <T> T getAttribute(String name, Class<T> clazz) {
        return clazz.cast(this.getAttribute(name));
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean isRequestJson() {
        String contentType = this.getRequestContentType();
        if (contentType == null || contentType.isEmpty()) {
            return false;
        }
        return contentType.startsWith("application/json");
    }

    public boolean isRequestXml() {
        String contentType = this.getRequestContentType();
        if (contentType == null || contentType.isEmpty()) {
            return false;
        }
        return contentType.startsWith("application/xml");
    }
}

