/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaTestBrowser {
    private final Logger LOG = LoggerFactory.getLogger(NinjaTestBrowser.class);
    private DefaultHttpClient httpClient = new DefaultHttpClient();

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public List<Cookie> getCookies() {
        return this.httpClient.getCookieStore().getCookies();
    }

    public Cookie getCookieWithName(String name) {
        List<Cookie> cookies = this.getCookies();
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public HttpResponse makeRequestAndGetResponse(String url, Map<String, String> headers) {
        CloseableHttpResponse response = null;
        try {
            HttpGet getRequest = new HttpGet(url);
            for (Map.Entry<String, String> header : headers.entrySet()) {
                getRequest.addHeader(header.getKey(), header.getValue());
            }
            response = this.httpClient.execute((HttpUriRequest)getRequest);
            getRequest.reset();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String makeRequest(String url) {
        return this.makeRequest(url, null);
    }

    public String makeRequest(String url, Map<String, String> headers) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            String output;
            HttpGet getRequest = new HttpGet(url);
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    getRequest.addHeader(header.getKey(), header.getValue());
                }
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)getRequest);
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            getRequest.releaseConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    this.LOG.error("Failed to close resource", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    public String makePostRequestWithFormParameters(String url, Map<String, String> headers, Map<String, String> formParameters) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            String output;
            HttpPost postRequest = new HttpPost(url);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    postRequest.addHeader(entry.getKey(), entry.getValue());
                }
            }
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            if (formParameters != null) {
                for (Map.Entry<String, String> entry : formParameters.entrySet()) {
                    formparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
            }
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(formparams);
            postRequest.setEntity((HttpEntity)urlEncodedFormEntity);
            CloseableHttpResponse closeableHttpResponse = this.httpClient.execute((HttpUriRequest)postRequest);
            br = new BufferedReader(new InputStreamReader(closeableHttpResponse.getEntity().getContent(), "UTF-8"));
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            postRequest.releaseConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    this.LOG.error("Failed to close resource", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    public String uploadFile(String url, String paramName, File fileToUpload) {
        String response = null;
        try {
            this.httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            HttpPost post = new HttpPost(url);
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart(paramName, (ContentBody)new FileBody(fileToUpload));
            post.setEntity((HttpEntity)entity);
            response = EntityUtils.toString((HttpEntity)this.httpClient.execute((HttpUriRequest)post).getEntity(), (String)"UTF-8");
            post.releaseConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public String makeJsonRequest(String url) {
        HashMap headers = Maps.newHashMap();
        headers.put("accept", "application/json; charset=utf-8");
        return this.makeRequest(url, headers);
    }

    public String makeXmlRequest(String url) {
        HashMap headers = Maps.newHashMap();
        headers.put("accept", "application/xml; charset=utf-8");
        return this.makeRequest(url, headers);
    }

    public String postJson(String url, Object object) {
        try {
            this.httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            HttpPost post = new HttpPost(url);
            StringEntity entity = new StringEntity(new ObjectMapper().writeValueAsString(object), "utf-8");
            entity.setContentType("application/json; charset=utf-8");
            post.setEntity((HttpEntity)entity);
            post.releaseConnection();
            return EntityUtils.toString((HttpEntity)this.httpClient.execute((HttpUriRequest)post).getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String postXml(String url, Object object) {
        try {
            this.httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            HttpPost post = new HttpPost(url);
            StringEntity entity = new StringEntity(new XmlMapper().writeValueAsString(object), "utf-8");
            entity.setContentType("application/xml; charset=utf-8");
            post.setEntity((HttpEntity)entity);
            post.releaseConnection();
            return EntityUtils.toString((HttpEntity)this.httpClient.execute((HttpUriRequest)post).getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }
}

