/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import java.util.List;
import org.openl.binding.IBoundNode;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.ATargetBoundNode;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.NodeUsage;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.rules.types.impl.OverloadedMethodsDispatcherTable;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.ExecutableMethod;
import org.openl.types.impl.MethodDelegator;
import org.openl.util.CollectionUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;

public class MethodUsagesSearcher {
    public static List<MethodUsage> findAllMethods(IBoundNode boundNode, String sourceString, int startIndex) {
        ArrayList<MethodUsage> methods = new ArrayList<MethodUsage>();
        MethodUsagesSearcher.findAllMethods(boundNode, methods, sourceString, startIndex);
        return methods;
    }

    private static void findAllMethods(IBoundNode boundNode, List<MethodUsage> methods, String sourceString, int startIndex) {
        IBoundNode targetNode;
        if (boundNode instanceof MethodBoundNode) {
            IOpenMethod method;
            IBoundNode[] methodBoundNode = (IBoundNode[])boundNode;
            ILocation location = methodBoundNode.getSyntaxNode().getSourceLocation();
            IMethodCaller methodCaller = methodBoundNode.getMethodCaller();
            if (methodCaller != null && ((method = methodCaller instanceof IOpenMethod ? (IOpenMethod)methodCaller : methodCaller.getMethod()) instanceof ExecutableMethod || method instanceof MatchingOpenMethodDispatcher || method instanceof MethodDelegator) && location != null && location.isTextLocation()) {
                TextInfo info = new TextInfo(sourceString);
                int pstart = location.getStart().getAbsolutePosition(info) + startIndex;
                int pend = pstart + method.getName().length() - 1;
                methods.add(new MethodUsage(pstart, pend, method));
            }
        }
        if (CollectionUtils.isNotEmpty((Object[])boundNode.getChildren())) {
            for (IBoundNode child : boundNode.getChildren()) {
                MethodUsagesSearcher.findAllMethods(child, methods, sourceString, startIndex);
            }
        }
        if (boundNode instanceof ATargetBoundNode && (targetNode = boundNode.getTargetNode()) != null) {
            MethodUsagesSearcher.findAllMethods(targetNode, methods, sourceString, startIndex);
        }
    }

    public static class MethodUsage
    implements NodeUsage {
        private int startPos;
        private int endPos;
        private IOpenMethod method;

        public MethodUsage(int startPos, int endPos, IOpenMethod method) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.method = method;
        }

        @Override
        public int getStart() {
            return this.startPos;
        }

        @Override
        public int getEnd() {
            return this.endPos;
        }

        public IOpenMethod getMethod() {
            return this.method;
        }

        private static String getTableUri(IOpenMethod method) {
            try {
                if (method instanceof ExecutableRulesMethod) {
                    return ((ExecutableRulesMethod)method).getSyntaxNode().getUri();
                }
                if (method instanceof OverloadedMethodsDispatcherTable) {
                    return ((OverloadedMethodsDispatcherTable)method).getDispatcherTable().getUri();
                }
                if (method instanceof MatchingOpenMethodDispatcher) {
                    MatchingOpenMethodDispatcher matchingOpenMethodDispatcher = (MatchingOpenMethodDispatcher)method;
                    if (matchingOpenMethodDispatcher.getCandidates().size() == 1) {
                        return MethodUsage.getTableUri(matchingOpenMethodDispatcher.getCandidates().get(0));
                    }
                    return matchingOpenMethodDispatcher.getDispatcherTable().getUri();
                }
                if (method.getInfo() != null) {
                    return method.getInfo().getSourceUrl();
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String getUri() {
            return MethodUsage.getTableUri(this.method);
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.RULE;
        }

        @Override
        public String getDescription() {
            StringBuilder buff = new StringBuilder();
            MethodUtil.printMethod((IOpenMethodHeader)this.method, (StringBuilder)buff);
            return buff.toString();
        }
    }
}

