/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.binding;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.domain.IDomain;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.ValueMetaInfo;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.convertor.IObjectToDataConvertor;
import org.openl.rules.convertor.ObjectToDataConvertorFactory;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.dt.element.ArrayHolder;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.Log;
import org.openl.util.StringPool;
import org.openl.util.StringTool;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;
import org.openl.vm.IRuntimeEnv;

public class RuleRowHelper {
    public static final String ARRAY_ELEMENTS_SEPARATOR_ESCAPER = "\\";
    public static final String ARRAY_ELEMENTS_SEPARATOR = ",";
    public static final String CONSTRUCTOR = "constructor";

    public static int calculateHeight(ILogicalTable table) {
        int height = table.getHeight();
        int last = -1;
        for (int i = 0; i < height; ++i) {
            String source = ((ILogicalTable)table.getRow(i)).getSource().getCell(0, 0).getStringValue();
            if (source == null || source.trim().length() == 0) continue;
            last = i;
        }
        return last + 1;
    }

    public static String[] extractElementsFromCommaSeparatedArray(ILogicalTable cell) {
        String[] tokens = null;
        String src = cell.getSource().getCell(0, 0).getStringValue();
        if (src != null) {
            tokens = StringTool.splitAndEscape((String)src, (String)ARRAY_ELEMENTS_SEPARATOR, (String)ARRAY_ELEMENTS_SEPARATOR_ESCAPER);
        }
        return tokens;
    }

    public static Object loadCommaSeparatedParam(IOpenClass paramType, String paramName, String ruleName, ILogicalTable cell, OpenlToolAdaptor openlAdaptor) throws SyntaxNodeException {
        Object arrayValues;
        String[] tokens = RuleRowHelper.extractElementsFromCommaSeparatedArray(cell);
        if (tokens != null) {
            ArrayList<Object> values = new ArrayList<Object>(tokens.length);
            for (String token : tokens) {
                String str = StringPool.intern((String)token);
                Object res = RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, cell, openlAdaptor, str, true);
                if (res == null) {
                    res = paramType.nullObject();
                    if (!openlAdaptor.getBindingContext().isExecutionMode()) {
                        RuleRowHelper.setCellMetaInfo(cell, paramName, paramType, true);
                    }
                }
                values.add(res);
            }
            int valuesArraySize = values.size();
            arrayValues = paramType.getAggregateInfo().makeIndexedAggregate(paramType, new int[]{valuesArraySize});
            for (int i = 0; i < valuesArraySize; ++i) {
                Array.set(arrayValues, i, values.get(i));
            }
        } else {
            arrayValues = paramType.getAggregateInfo().makeIndexedAggregate(paramType, new int[]{0});
            if (!openlAdaptor.getBindingContext().isExecutionMode()) {
                RuleRowHelper.setCellMetaInfo(cell, paramName, paramType, true);
            }
        }
        return arrayValues;
    }

    public static IOpenClass getType(String typeCode, IBindingContext bindingContext) {
        if (typeCode.endsWith("[]")) {
            int dims = 0;
            String baseCode = typeCode;
            while (baseCode.endsWith("[]")) {
                baseCode = baseCode.substring(0, baseCode.length() - 2);
                ++dims;
            }
            IOpenClass baseType = bindingContext.findType("org.openl.this", baseCode);
            if (baseType == null) {
                return null;
            }
            return baseType.getAggregateInfo().getIndexedAggregateType(baseType, dims);
        }
        return bindingContext.findType("org.openl.this", typeCode);
    }

    public static void loadParams(Object[] array, int from, Object[] paramValues, Object target, Object[] params, IRuntimeEnv env) {
        for (int i = 0; i < paramValues.length; ++i) {
            Object value = paramValues[i];
            if (value instanceof IOpenMethod) {
                value = ((IOpenMethod)value).invoke(target, params, env);
            } else if (value instanceof ArrayHolder) {
                value = ((ArrayHolder)value).invoke(target, params, env);
            }
            array[i + from] = value;
        }
    }

    public static Object loadSingleParam(IOpenClass paramType, String paramName, String ruleName, ILogicalTable table, OpenlToolAdaptor openlAdapter) throws SyntaxNodeException {
        ICell theCell;
        ICell theValueCell = theCell = table.getSource().getCell(0, 0);
        if (theCell.getRegion() != null) {
            theValueCell = theCell.getTopLeftCellFromRegion();
        }
        if (String.class.equals((Object)paramType.getInstanceClass())) {
            String src = theValueCell.getStringValue();
            if (src != null) {
                src = src.length() <= 4 ? src.intern() : src;
            }
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, table, openlAdapter, src, false);
        }
        if (theValueCell.hasNativeType() && theValueCell.getNativeType() == 0) {
            try {
                Object res = RuleRowHelper.loadNativeValue(theValueCell, paramType, openlAdapter.getBindingContext(), paramName, ruleName, table);
                if (res != null) {
                    RuleRowHelper.validateValue(res, paramType);
                    if (!openlAdapter.getBindingContext().isExecutionMode()) {
                        RuleRowHelper.setCellMetaInfo(table, paramName, paramType, false);
                    }
                    return res;
                }
            }
            catch (Throwable t) {
                String message = t.getMessage();
                if (message == null) {
                    message = "Can't load cell value";
                }
                throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)t, (ILocation)LocationUtils.createTextInterval((String)theValueCell.getStringValue()), (IOpenSourceCodeModule)new GridCellSourceCodeModule(table.getSource(), openlAdapter.getBindingContext()));
            }
        }
        String src = theValueCell.getStringValue();
        return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, table, openlAdapter, src, false);
    }

    private static Object loadNativeValue(ICell cell, IOpenClass paramType, IBindingContext bindingContext, String paramName, String ruleName, ILogicalTable table) {
        Class expectedType = paramType.getInstanceClass();
        Object res = null;
        if (BigDecimal.class.isAssignableFrom(expectedType) || BigDecimalValue.class.isAssignableFrom(expectedType)) {
            IObjectToDataConvertor objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, String.class);
            res = objectConvertor.convert(cell.getStringValue(), bindingContext);
        } else {
            double value = cell.getNativeNumber();
            IObjectToDataConvertor objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Double.TYPE);
            if (objectConvertor != ObjectToDataConvertorFactory.NO_Convertor) {
                res = objectConvertor.convert(value, bindingContext);
            } else {
                objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Double.class);
                if (objectConvertor != ObjectToDataConvertorFactory.NO_Convertor) {
                    res = objectConvertor.convert(value, bindingContext);
                } else {
                    objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Date.class);
                    if (objectConvertor != ObjectToDataConvertorFactory.NO_Convertor) {
                        Date dateValue = cell.getNativeDate();
                        res = objectConvertor.convert(dateValue, bindingContext);
                    } else if ((double)((int)value) == value && (objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Integer.class)) != ObjectToDataConvertorFactory.NO_Convertor) {
                        res = objectConvertor.convert((int)value, bindingContext);
                    }
                }
            }
        }
        if (res != null && res instanceof IMetaHolder) {
            RuleRowHelper.setMetaInfo((IMetaHolder)res, table, paramName, ruleName, bindingContext);
        }
        return res;
    }

    private static Object loadSingleParam(IOpenClass paramType, String paramName, String ruleName, ILogicalTable cell, OpenlToolAdaptor openlAdapter, String source, boolean isPartOfArray) throws SyntaxNodeException {
        if (source != null && (source = source.trim()).length() != 0) {
            Object result;
            if (openlAdapter.getHeader() != null) {
                IOpenMethodHeader old_header = openlAdapter.getHeader();
                OpenMethodHeader newHeader = new OpenMethodHeader(old_header.getName(), paramType, old_header.getSignature(), old_header.getDeclaringClass());
                openlAdapter.setHeader((IOpenMethodHeader)newHeader);
                if (source.startsWith("{") && source.endsWith("}")) {
                    GridCellSourceCodeModule srcCode = new GridCellSourceCodeModule(cell.getSource(), openlAdapter.getBindingContext());
                    return openlAdapter.makeMethod(srcCode);
                }
                if (source.startsWith("=") && (source.length() > 2 || source.length() == 2 && Character.isLetterOrDigit(source.charAt(1)))) {
                    GridCellSourceCodeModule gridSource = new GridCellSourceCodeModule(cell.getSource(), openlAdapter.getBindingContext());
                    SubTextSourceCodeModule code = new SubTextSourceCodeModule((IOpenSourceCodeModule)gridSource, 1);
                    return openlAdapter.makeMethod((IOpenSourceCodeModule)code);
                }
            }
            Class expectedType = paramType.getInstanceClass();
            if (!openlAdapter.getBindingContext().isExecutionMode()) {
                RuleRowHelper.setCellMetaInfo(cell, paramName, paramType, isPartOfArray);
            }
            try {
                IBindingContext bindingContext = openlAdapter.getBindingContext();
                result = String2DataConvertorFactory.parse(expectedType, source, bindingContext);
            }
            catch (Exception e) {
                String message = String.format("Cannot parse cell value '%s'", source);
                GridCellSourceCodeModule cellSourceCodeModule = new GridCellSourceCodeModule(cell.getSource(), openlAdapter.getBindingContext());
                if (e instanceof CompositeSyntaxNodeException) {
                    throw SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)cellSourceCodeModule);
                }
                throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, null, (IOpenSourceCodeModule)cellSourceCodeModule);
            }
            if (result instanceof IMetaHolder) {
                RuleRowHelper.setMetaInfo((IMetaHolder)result, cell, paramName, ruleName, openlAdapter.getBindingContext());
            }
            try {
                RuleRowHelper.validateValue(result, paramType);
            }
            catch (Exception e) {
                String message = String.format("Invalid cell value '%s'", source);
                GridCellSourceCodeModule cellSourceCodeModule = new GridCellSourceCodeModule(cell.getSource(), openlAdapter.getBindingContext());
                throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, null, (IOpenSourceCodeModule)cellSourceCodeModule);
            }
            return result;
        }
        if (!openlAdapter.getBindingContext().isExecutionMode()) {
            RuleRowHelper.setCellMetaInfo(cell, paramName, paramType, false);
        }
        return null;
    }

    public static boolean isFormula(ILogicalTable valuesTable) {
        String stringValue = valuesTable.getSource().getCell(0, 0).getStringValue();
        if (stringValue != null) {
            stringValue = stringValue.trim();
            return stringValue.startsWith("=");
        }
        return false;
    }

    public static void setCellMetaInfo(ILogicalTable logicalCell, String paramName, IOpenClass paramType, boolean isMultiValue) {
        CellMetaInfo meta = new CellMetaInfo(CellMetaInfo.Type.DT_DATA_CELL, paramName, paramType, isMultiValue);
        ICell cell = logicalCell.getSource().getCell(0, 0);
        cell.setMetaInfo(meta);
    }

    public static void setCellMetaInfoWithNodeUsage(ILogicalTable logicalCell, IdentifierNode identifier, IMetaInfo metaInfo, NodeType nodeType) {
        if (metaInfo != null) {
            SimpleNodeUsage nodeUsage = new SimpleNodeUsage(identifier, metaInfo.getDisplayName(0), metaInfo.getSourceUrl(), nodeType);
            CellMetaInfo meta = new CellMetaInfo(CellMetaInfo.Type.DT_CA_CODE, null, (IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(nodeUsage));
            ICell cell = logicalCell.getSource().getCell(0, 0);
            cell.setMetaInfo(meta);
        }
    }

    private static void setMetaInfo(IMetaHolder holder, ILogicalTable cell, String paramName, String ruleName, IBindingContext bindingContext) {
        if (!bindingContext.isExecutionMode()) {
            ValueMetaInfo valueMetaInfo = new ValueMetaInfo();
            valueMetaInfo.setShortName(paramName);
            valueMetaInfo.setFullName(ruleName == null ? paramName : ruleName + "." + paramName);
            valueMetaInfo.setSource((IOpenSourceCodeModule)new GridCellSourceCodeModule(cell.getSource(), bindingContext));
            holder.setMetaInfo((IMetaInfo)valueMetaInfo);
        }
    }

    public static void validateValue(Object value, IOpenClass paramType) throws Exception {
        IDomain domain = paramType.getDomain();
        if (domain != null) {
            try {
                boolean contains = domain.selectObject(value);
                if (!contains) {
                    throw new OpenLCompilationException(String.format("The value '%s' is outside of domain %s", value, domain.toString()));
                }
            }
            catch (RuntimeException e) {
                throw new OpenLCompilationException(e.getMessage(), e.getCause());
            }
        }
    }

    private static Object loadEmptyCellParams(ILogicalTable dataTable, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, IOpenClass paramType) {
        if (!openlAdaptor.getBindingContext().isExecutionMode()) {
            if (paramType.isArray()) {
                IOpenClass arrayType = paramType.getAggregateInfo().getComponentType(paramType);
                RuleRowHelper.setCellMetaInfo(dataTable, paramName, arrayType, true);
            } else {
                RuleRowHelper.setCellMetaInfo(dataTable, paramName, paramType, false);
            }
        }
        return null;
    }

    public static Object loadParam(ILogicalTable dataTable, IOpenClass paramType, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, boolean indexed) throws SyntaxNodeException {
        boolean oneCellTable;
        if (!indexed) {
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
        }
        int height = RuleRowHelper.calculateHeight(dataTable = LogicalTableHelper.make1ColumnTable(dataTable));
        boolean bl = oneCellTable = height == 1;
        if (height == 0) {
            return RuleRowHelper.loadEmptyCellParams(dataTable, paramName, ruleName, openlAdaptor, paramType);
        }
        if (oneCellTable && !paramType.isArray()) {
            try {
                return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
            }
            catch (Exception e) {
                Log.debug((Object)e);
            }
        }
        IOpenClass arrayType = paramType.getAggregateInfo().getComponentType(paramType);
        boolean isFormula = RuleRowHelper.isFormula(dataTable);
        if (oneCellTable && !isFormula) {
            return RuleRowHelper.loadCommaSeparatedArrayParams(dataTable, paramName, ruleName, openlAdaptor, arrayType);
        }
        if (oneCellTable && isFormula) {
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
        }
        return RuleRowHelper.loadSimpleArrayParams(dataTable, paramName, ruleName, openlAdaptor, arrayType);
    }

    private static Object loadCommaSeparatedArrayParams(ILogicalTable dataTable, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, IOpenClass paramType) throws SyntaxNodeException {
        ILogicalTable paramSource = (ILogicalTable)dataTable.getRow(0);
        Object params = RuleRowHelper.loadCommaSeparatedParam(paramType, paramName, ruleName, paramSource, openlAdaptor);
        Class<?> paramClass = params.getClass();
        if (paramClass.isArray() && !paramClass.getComponentType().isPrimitive()) {
            return RuleRowHelper.processAsObjectParams(paramType, (Object[])params);
        }
        return params;
    }

    private static Object processAsObjectParams(IOpenClass paramType, Object[] paramsArray) {
        ArrayList<CompositeMethod> methodsList = null;
        int paramsLength = paramsArray.length;
        Object ary = paramType.getAggregateInfo().makeIndexedAggregate(paramType, new int[]{paramsLength});
        for (int i = 0; i < paramsLength; ++i) {
            if (paramsArray[i] instanceof CompositeMethod) {
                methodsList = new ArrayList<CompositeMethod>(RuleRowHelper.addMethod((List<CompositeMethod>)methodsList, (CompositeMethod)paramsArray[i]));
                continue;
            }
            Array.set(ary, i, paramsArray[i]);
        }
        return methodsList == null ? ary : new ArrayHolder(paramType, methodsList.toArray(new CompositeMethod[methodsList.size()]));
    }

    private static List<CompositeMethod> addMethod(List<CompositeMethod> methods, CompositeMethod method) {
        if (methods == null) {
            methods = new ArrayList<CompositeMethod>();
        }
        methods.add(method);
        return methods;
    }

    private static Object loadSimpleArrayParams(ILogicalTable dataTable, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, IOpenClass paramType) throws SyntaxNodeException {
        int height = RuleRowHelper.calculateHeight(dataTable);
        ArrayList<CompositeMethod> methodsList = null;
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < height; ++i) {
            ILogicalTable cell = (ILogicalTable)dataTable.getRow(i);
            Object parameter = RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, cell, openlAdaptor);
            if (parameter instanceof CompositeMethod) {
                methodsList = new ArrayList<CompositeMethod>(RuleRowHelper.addMethod(methodsList, (CompositeMethod)parameter));
                continue;
            }
            if (parameter == null) continue;
            values.add(parameter);
        }
        Object ary = paramType.getAggregateInfo().makeIndexedAggregate(paramType, new int[]{values.size()});
        for (int i = 0; i < values.size(); ++i) {
            Array.set(ary, i, values.get(i));
        }
        return methodsList == null ? ary : new ArrayHolder(paramType, methodsList.toArray(new CompositeMethod[methodsList.size()]));
    }
}

