/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openl.binding.IBindingContext;
import org.openl.meta.StringValue;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;

public class CellsHeaderExtractor {
    private String[] rowNames;
    private String[] columnNames;
    private Set<String> dependentSpreadsheetTypes;
    private final ILogicalTable columnNamesTable;
    private final ILogicalTable rowNamesTable;
    private final String spreadsheetSignature;
    static final String DEPENDENT_CSR_REGEX = "^.*\\s*:\\s*SpreadsheetResult[^\\s\\[\\]].*";
    private static final Pattern CSR_IN_RETURN_PATTERN = Pattern.compile("\\s*Spreadsheet\\s*SpreadsheetResult([^\\s\\[\\]]+).+");
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("\\((.+)\\)");
    private static final Pattern CSR_TYPE_PATTERN = Pattern.compile("\\s*SpreadsheetResult([^\\s\\[\\]]+).+");

    public CellsHeaderExtractor(String spreadsheetSignature, ILogicalTable columnNamesTable, ILogicalTable rowNamesTable) {
        this.spreadsheetSignature = spreadsheetSignature;
        this.columnNamesTable = columnNamesTable;
        this.rowNamesTable = rowNamesTable;
    }

    public void extract() {
        this.extractRowNames();
        this.extractColumnNames();
    }

    public ILogicalTable getColumnNamesTable() {
        return this.columnNamesTable;
    }

    public int getWidth() {
        return this.columnNamesTable == null ? 0 : this.columnNamesTable.getWidth();
    }

    public ILogicalTable getRowNamesTable() {
        return this.rowNamesTable;
    }

    public int getHeight() {
        return this.rowNamesTable == null ? 0 : this.rowNamesTable.getHeight();
    }

    public String[] getRowNames() {
        if (this.rowNames == null) {
            this.extractRowNames();
        }
        return (String[])this.rowNames.clone();
    }

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            this.extractColumnNames();
        }
        return (String[])this.columnNames.clone();
    }

    public Set<String> getDependentSignatureSpreadsheetTypes() {
        if (this.dependentSpreadsheetTypes == null) {
            this.dependentSpreadsheetTypes = new HashSet<String>();
            this.dependentSpreadsheetTypes.addAll(CellsHeaderExtractor.getSignatureDependencies(this.spreadsheetSignature));
        }
        return this.dependentSpreadsheetTypes;
    }

    public StringValue getRowNameForHeader(String value, int row, IBindingContext bindingContext) {
        StringValue sv = null;
        if (value != null) {
            String shortName = String.format("srow%d", row);
            IGridTable nameCell = ((ILogicalTable)((ILogicalTable)this.rowNamesTable.getRow(row)).getColumn(0)).getSource();
            sv = new StringValue(value, shortName, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule(nameCell, bindingContext));
        }
        return sv;
    }

    public StringValue getColumnNameForHeader(String value, int column, IBindingContext bindingContext) {
        StringValue stringValue = null;
        if (value != null) {
            String shortName = String.format("scol%d", column);
            IGridTable nameCell = ((ILogicalTable)((ILogicalTable)this.columnNamesTable.getColumn(column)).getRow(0)).getSource();
            stringValue = new StringValue(value, shortName, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule(nameCell, bindingContext));
        }
        return stringValue;
    }

    private List<String> getDependencies(String[] cellNames) {
        ArrayList<String> dependentSpreadsheets = new ArrayList<String>();
        for (String cellName : cellNames) {
            if (cellName == null || !cellName.matches(DEPENDENT_CSR_REGEX)) continue;
            String[] res = cellName.split(SpreadsheetResult.class.getSimpleName());
            String dependentMethodName = res[res.length - 1];
            dependentMethodName = dependentMethodName.replace("[]", "");
            dependentSpreadsheets.add(dependentMethodName);
        }
        return dependentSpreadsheets;
    }

    static List<String> getSignatureDependencies(String signature) {
        ArrayList<String> dependentSpreadsheets = new ArrayList<String>();
        Matcher matcher = CSR_IN_RETURN_PATTERN.matcher(signature);
        if (matcher.matches()) {
            dependentSpreadsheets.add(matcher.group(1));
        }
        if ((matcher = PARAMETERS_PATTERN.matcher(signature)).find()) {
            String allParams = matcher.group(1);
            for (String param : allParams.split("\\s*,\\s*")) {
                Matcher paramMatcher = CSR_TYPE_PATTERN.matcher(param);
                if (!paramMatcher.matches()) continue;
                dependentSpreadsheets.add(paramMatcher.group(1));
            }
        }
        return dependentSpreadsheets;
    }

    private String[] extractRowNames() {
        int height = this.getHeight();
        this.rowNames = new String[height];
        for (int row = 0; row < height; ++row) {
            this.rowNames[row] = this.getRowName(row, (ILogicalTable)this.rowNamesTable.getRow(row));
        }
        return this.rowNames;
    }

    private String[] extractColumnNames() {
        int width = this.getWidth();
        this.columnNames = new String[width];
        for (int col = 0; col < width; ++col) {
            this.columnNames[col] = this.getColumnName(col, (ILogicalTable)this.columnNamesTable.getColumn(col));
        }
        return this.columnNames;
    }

    private String getRowName(int row, ILogicalTable rowNameCell) {
        IGridTable nameCell = ((ILogicalTable)rowNameCell.getColumn(0)).getSource();
        String value = nameCell.getCell(0, 0).getStringValue();
        return value;
    }

    private String getColumnName(int column, ILogicalTable columnNameCell) {
        IGridTable nameCell = ((ILogicalTable)columnNameCell.getRow(0)).getSource();
        String value = nameCell.getCell(0, 0).getStringValue();
        return value;
    }
}

