/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openl.binding.BindingDependencies;
import org.openl.rules.annotations.Executable;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.calc.CustomSpreadsheetResultField;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetBoundNode;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.SpreadsheetInvoker;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.result.DefaultResultBuilder;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.Point;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.Invokable;
import org.openl.vm.IRuntimeEnv;

@Executable
public class Spreadsheet
extends ExecutableRulesMethod {
    public static final String SPREADSHEETRESULT_TYPE_PREFIX = "SpreadsheetResult";
    private IResultBuilder resultBuilder;
    private SpreadsheetCell[][] cells;
    private String[] rowNames;
    private String[] columnNames;
    private String[] rowTitles;
    private String[] columnTitles;
    private SpreadsheetOpenClass spreadsheetType;
    private Invokable invoker;
    private IOpenClass spreadsheetCustomType;
    private boolean customSpreadsheetType;
    Constructor<?> constructor;
    Map<String, Point> fieldsCoordinates = null;

    public Spreadsheet() {
        super(null, null);
    }

    public Spreadsheet(IOpenMethodHeader header, SpreadsheetBoundNode boundNode, boolean customSpreadsheetType) {
        super(header, boundNode);
        this.initProperties(this.getSyntaxNode().getTableProperties());
        this.customSpreadsheetType = customSpreadsheetType;
    }

    public Spreadsheet(IOpenMethodHeader header, SpreadsheetBoundNode boundNode) {
        this(header, boundNode, false);
    }

    public synchronized Constructor<?> getResultConstructor() throws SecurityException, NoSuchMethodException {
        if (this.constructor == null) {
            this.constructor = this.getType().getInstanceClass().getConstructor(Object[][].class, String[].class, String[].class, String[].class, String[].class, Map.class);
        }
        return this.constructor;
    }

    public IOpenClass getType() {
        if (this.isCustomSpreadsheetType()) {
            return this.getCustomSpreadsheetResultType();
        }
        return super.getType();
    }

    public boolean isCustomSpreadsheetType() {
        return this.customSpreadsheetType;
    }

    private synchronized IOpenClass getCustomSpreadsheetResultType() {
        if (this.spreadsheetCustomType == null) {
            this.initCustomSpreadsheetResultType();
        }
        return this.spreadsheetCustomType;
    }

    private void initCustomSpreadsheetResultType() {
        Map spreadsheetOpenClassFields = this.getSpreadsheetType().getFields();
        spreadsheetOpenClassFields.remove("this");
        String typeName = SPREADSHEETRESULT_TYPE_PREFIX + this.getName();
        Map<String, Point> fieldCoordinates = this.getFieldsCoordinates();
        CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = new CustomSpreadsheetResultOpenClass(typeName, this.getRowNames(), this.getColumnNames(), this.getRowTitles(), this.getColumnTitles(), fieldCoordinates);
        for (IOpenField field : spreadsheetOpenClassFields.values()) {
            CustomSpreadsheetResultField customSpreadsheetResultField = new CustomSpreadsheetResultField(this.spreadsheetCustomType, field.getName(), field.getType());
            customSpreadsheetResultOpenClass.addField((IOpenField)customSpreadsheetResultField);
        }
        this.spreadsheetCustomType = customSpreadsheetResultOpenClass;
    }

    public SpreadsheetCell[][] getCells() {
        return this.cells;
    }

    public BindingDependencies getDependencies() {
        RulesBindingDependencies bindingDependencies = new RulesBindingDependencies();
        this.getBoundNode().updateDependency(bindingDependencies);
        return bindingDependencies;
    }

    public IResultBuilder getResultBuilder() {
        return this.resultBuilder;
    }

    public String getSourceUrl() {
        return this.getSyntaxNode().getUri();
    }

    public SpreadsheetOpenClass getSpreadsheetType() {
        return this.spreadsheetType;
    }

    public int getHeight() {
        return this.cells.length;
    }

    public void setCells(SpreadsheetCell[][] cells) {
        this.cells = cells;
    }

    public void setColumnNames(String[] colNames) {
        this.columnNames = colNames;
    }

    public void setResultBuilder(IResultBuilder resultBuilder) {
        this.resultBuilder = resultBuilder;
    }

    public void setRowNames(String[] rowNames) {
        this.rowNames = rowNames;
    }

    public void setRowTitles(String[] rowTitles) {
        this.rowTitles = rowTitles;
    }

    public String[] getRowTitles() {
        return this.rowTitles;
    }

    public void setColumnTitles(String[] columnTitles) {
        this.columnTitles = columnTitles;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public void setSpreadsheetType(SpreadsheetOpenClass spreadsheetType) {
        this.spreadsheetType = spreadsheetType;
    }

    public int getWidth() {
        return this.cells.length == 0 ? 0 : this.cells[0].length;
    }

    public String[] getRowNames() {
        return this.rowNames;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    protected Object innerInvoke(Object target, Object[] params, IRuntimeEnv env) {
        return this.getInvoker().invoke(target, params, env);
    }

    protected Invokable createInvoker() {
        return new SpreadsheetInvoker(this);
    }

    protected synchronized Invokable getInvoker() {
        if (this.invoker == null) {
            this.invoker = this.createInvoker();
        }
        return this.invoker;
    }

    public List<SpreadsheetCell> listNonEmptyCells(SpreadsheetHeaderDefinition definition) {
        ArrayList<SpreadsheetCell> list = new ArrayList<SpreadsheetCell>();
        int row = definition.getRow();
        int col = definition.getColumn();
        if (row >= 0) {
            for (int i = 0; i < this.getWidth(); ++i) {
                if (this.cells[row][i].isEmpty()) continue;
                list.add(this.cells[row][i]);
            }
        } else {
            for (int i = 0; i < this.getHeight(); ++i) {
                if (this.cells[i][col].isEmpty()) continue;
                list.add(this.cells[i][col]);
            }
        }
        return list;
    }

    @Deprecated
    public int height() {
        return this.getHeight();
    }

    @Deprecated
    public int width() {
        return this.getWidth();
    }

    public void setInvoker(SpreadsheetInvoker invoker) {
        this.invoker = invoker;
    }

    public synchronized Map<String, Point> getFieldsCoordinates() {
        if (this.fieldsCoordinates == null) {
            this.fieldsCoordinates = DefaultResultBuilder.getFieldsCoordinates(this.getSpreadsheetType().getFields());
        }
        return this.fieldsCoordinates;
    }
}

