/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLSystemProperties;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetBuilder;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.lang.xls.binding.AMethodBasedNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ILogicalTable;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;

public class SpreadsheetBoundNode
extends AMethodBasedNode
implements IMemberBoundNode {
    private SpreadsheetBuilder builder;
    IBindingContext bindingContext;

    public SpreadsheetBoundNode(TableSyntaxNode tableSyntaxNode, OpenL openl, IOpenMethodHeader header, ModuleOpenClass module) {
        super(tableSyntaxNode, openl, header, module);
    }

    protected Spreadsheet createSpreadsheet() {
        boolean isCustomSpreadsheetType = this.getType().getInstanceClass().equals(SpreadsheetResult.class) && !(this.getType() instanceof CustomSpreadsheetResultOpenClass) && OpenLSystemProperties.isCustomSpreadsheetType(this.bindingContext.getExternalParams());
        return new Spreadsheet(this.getHeader(), this, isCustomSpreadsheetType);
    }

    @Override
    protected ExecutableRulesMethod createMethodShell() {
        Spreadsheet spreadsheet = this.createSpreadsheet();
        spreadsheet.setSpreadsheetType(this.builder.getPopulatedSpreadsheetOpenClass());
        this.builder.populateRowAndColumnNames(spreadsheet);
        if (spreadsheet.isCustomSpreadsheetType()) {
            IOpenClass type = null;
            try {
                type = spreadsheet.getType();
                this.bindingContext.addType("org.openl.this", type);
            }
            catch (Exception e) {
                String message = String.format("Can't define type %s", type != null ? type.getName() : spreadsheet.getName());
                SyntaxNodeException exception = SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ISyntaxNode)this.getTableSyntaxNode());
                this.getTableSyntaxNode().addError(exception);
                BindHelper.processError((SyntaxNodeException)exception, (IBindingContext)this.bindingContext);
            }
        }
        return spreadsheet;
    }

    public void preBind(IBindingContext bindingContext) throws SyntaxNodeException {
        TableSyntaxNode tableSyntaxNode = this.getTableSyntaxNode();
        this.validateTableBody(tableSyntaxNode, bindingContext);
        IOpenMethodHeader header = this.getHeader();
        this.bindingContext = bindingContext;
        this.builder = new SpreadsheetBuilder(tableSyntaxNode, bindingContext, header);
        this.builder.populateSpreadsheetOpenClass();
    }

    @Override
    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        super.finalizeBind(bindingContext);
        ILogicalTable tableBody = this.getTableSyntaxNode().getTableBody();
        this.getTableSyntaxNode().getSubTables().put("business", tableBody);
        this.builder.finalizeBuild(this.getSpreadsheet());
    }

    private void validateTableBody(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) throws SyntaxNodeException {
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        if (tableBody == null) {
            throw SyntaxNodeExceptionUtils.createError((String)"Table has no body! Try to merge header cell horizontally to identify table.", (ISyntaxNode)this.getTableSyntaxNode());
        }
        int height = tableBody.getHeight();
        int width = tableBody.getWidth();
        if (height < 2 || width < 2) {
            String message = "Spreadsheet has empty body. Spreadsheet table should has at least 2x3 cells.";
            BindHelper.processWarn((String)message, (ISyntaxNode)tableSyntaxNode, (IBindingContext)bindingContext);
        }
    }

    public Spreadsheet getSpreadsheet() {
        return (Spreadsheet)this.getMethod();
    }

    public void updateDependency(BindingDependencies dependencies) {
        if (this.getSpreadsheet().getCells() != null) {
            for (SpreadsheetCell[] cellArray : this.getSpreadsheet().getCells()) {
                if (cellArray == null) continue;
                for (SpreadsheetCell cell : cellArray) {
                    CompositeMethod method;
                    if (cell == null || (method = (CompositeMethod)cell.getMethod()) == null) continue;
                    method.updateDependency(dependencies);
                }
            }
        }
    }

    @Override
    public void removeDebugInformation(IBindingContext cxt) throws Exception {
        if (cxt.isExecutionMode()) {
            super.removeDebugInformation(cxt);
            this.builder.removeDebugInformation();
            this.builder = null;
            this.bindingContext = null;
        }
    }
}

