/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.element;

import org.openl.rules.calc.ASpreadsheetField;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetCellType;
import org.openl.rules.calc.element.SpreadsheetStructureBuilderHolder;
import org.openl.rules.table.Point;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class SpreadsheetCellField
extends ASpreadsheetField {
    protected SpreadsheetCell cell;
    private SpreadsheetStructureBuilderHolder structureBuilderContainer;

    public static SpreadsheetCellField createSpreadsheetCellField(SpreadsheetStructureBuilderHolder structureBuilderContainer, IOpenClass declaringClass, String name, SpreadsheetCell cell) {
        if (cell.getKind() == SpreadsheetCellType.METHOD) {
            return new SpreadsheetCellField(structureBuilderContainer, declaringClass, name, cell);
        }
        return new ConstSpreadsheetCellField(structureBuilderContainer, declaringClass, name, cell);
    }

    SpreadsheetCellField(SpreadsheetStructureBuilderHolder structureBuilderContainer, IOpenClass declaringClass, String name, SpreadsheetCell cell) {
        super(declaringClass, name, cell.getType());
        this.cell = cell;
        this.structureBuilderContainer = structureBuilderContainer;
    }

    public Object get(Object target, IRuntimeEnv env) {
        SpreadsheetResultCalculator result = (SpreadsheetResultCalculator)target;
        return result.getValue(this.cell.getRowIndex(), this.cell.getColumnIndex());
    }

    public SpreadsheetCell getCell() {
        return this.cell;
    }

    public IOpenClass getType() {
        IOpenClass t = this.cell.getType();
        if (t == null) {
            t = this.structureBuilderContainer.getSpreadsheetStructureBuilder().makeType(this.cell);
        }
        return t;
    }

    public boolean isWritable() {
        return false;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        throw new UnsupportedOperationException("Can not write to spreadsheet cell result");
    }

    public Point getRelativeCoordinates() {
        return new Point(this.getCell().getColumnIndex(), this.getCell().getRowIndex());
    }

    public Point getAbsoluteCoordinates() {
        return new Point(this.getCell().getSourceCell().getAbsoluteColumn(), this.getCell().getSourceCell().getAbsoluteRow());
    }

    static class ConstSpreadsheetCellField
    extends SpreadsheetCellField {
        ConstSpreadsheetCellField(SpreadsheetStructureBuilderHolder structureBuilderContainer, IOpenClass declaringClass, String name, SpreadsheetCell cell) {
            super(structureBuilderContainer, declaringClass, name, cell);
        }

        @Override
        public Object get(Object target, IRuntimeEnv env) {
            return this.cell.getValue();
        }
    }
}

