/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch.algorithm;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openl.rules.cmatch.algorithm.IMatchAlgorithmCompiler;
import org.openl.rules.cmatch.algorithm.IMatchAlgorithmCompilerBuilder;
import org.openl.rules.cmatch.algorithm.MatchAlgorithmCompilerBuilder;
import org.openl.rules.cmatch.algorithm.ScoreAlgorithmCompilerBuilder;
import org.openl.rules.cmatch.algorithm.WeightAlgorithmCompilerBuilder;

public class MatchAlgorithmFactory {
    private static final Map<String, IMatchAlgorithmCompilerBuilder> builders = new LinkedHashMap<String, IMatchAlgorithmCompilerBuilder>();
    private static IMatchAlgorithmCompilerBuilder defaultBuilder = null;

    public static IMatchAlgorithmCompiler getAlgorithm(String nameOfAlgorithm) {
        IMatchAlgorithmCompilerBuilder builder = null;
        if (nameOfAlgorithm == null) {
            if (defaultBuilder == null) {
                throw new IllegalArgumentException("Default algorithm builder was not defined!");
            }
            builder = defaultBuilder;
        } else {
            builder = builders.get(nameOfAlgorithm);
        }
        if (builder == null) {
            throw new IllegalArgumentException("Cannot find algorithm for name '" + nameOfAlgorithm + "'!");
        }
        return builder.build();
    }

    public static Collection<String> getAlgorithmNames() {
        return Collections.unmodifiableSet(builders.keySet());
    }

    public static IMatchAlgorithmCompilerBuilder getDefaultBuilder() {
        return defaultBuilder;
    }

    public static void registerBuilder(String nameOfAlgorithm, IMatchAlgorithmCompilerBuilder builder) {
        builders.put(nameOfAlgorithm, builder);
    }

    public static void setDefaultBuilder(IMatchAlgorithmCompilerBuilder builder) {
        defaultBuilder = builder;
    }

    static {
        MatchAlgorithmCompilerBuilder matchBuilder = new MatchAlgorithmCompilerBuilder();
        MatchAlgorithmFactory.registerBuilder("MATCH", matchBuilder);
        MatchAlgorithmFactory.registerBuilder("WEIGHTED", new WeightAlgorithmCompilerBuilder());
        MatchAlgorithmFactory.registerBuilder("SCORE", new ScoreAlgorithmCompilerBuilder());
        MatchAlgorithmFactory.setDefaultBuilder(matchBuilder);
    }
}

