/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch.matcher;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openl.rules.cmatch.matcher.BooleanPrimitiveMatch;
import org.openl.rules.cmatch.matcher.ClassMatchBuilder;
import org.openl.rules.cmatch.matcher.ClassMinMaxBuilder;
import org.openl.rules.cmatch.matcher.EnumMatchBuilder;
import org.openl.rules.cmatch.matcher.IMatcher;
import org.openl.rules.cmatch.matcher.IMatcherBuilder;
import org.openl.rules.cmatch.matcher.NumberMatchBuilder;
import org.openl.rules.cmatch.matcher.NumberMaxBuilder;
import org.openl.rules.cmatch.matcher.NumberMinBuilder;
import org.openl.types.IOpenClass;

public class MatcherFactory {
    private static final Map<String, List<IMatcherBuilder>> matcherBuilders = new HashMap<String, List<IMatcherBuilder>>();

    public static IMatcher getMatcher(String operationName, IOpenClass type) {
        IMatcherBuilder builder;
        List<IMatcherBuilder> builders = matcherBuilders.get(operationName);
        if (builders == null) {
            return null;
        }
        IMatcher result = null;
        Iterator<IMatcherBuilder> iterator = builders.iterator();
        while (iterator.hasNext() && (result = (builder = iterator.next()).getInstanceIfSupports(type)) == null) {
        }
        return result;
    }

    public static void registerBuilder(IMatcherBuilder builder) {
        String operationName = builder.getName();
        List<IMatcherBuilder> builders = matcherBuilders.get(operationName);
        if (builders == null) {
            builders = new ArrayList<IMatcherBuilder>();
            matcherBuilders.put(operationName, builders);
        } else if (builders.contains(builder)) {
            throw new IllegalArgumentException("MatcherBuilder is registered already!");
        }
        builders.add(builder);
    }

    static {
        MatcherFactory.registerBuilder(new EnumMatchBuilder());
        MatcherFactory.registerBuilder(new NumberMatchBuilder());
        MatcherFactory.registerBuilder(new ClassMatchBuilder());
        MatcherFactory.registerBuilder(new BooleanPrimitiveMatch());
        MatcherFactory.registerBuilder(new NumberMinBuilder());
        MatcherFactory.registerBuilder(ClassMinMaxBuilder.minBuilder(Date.class));
        MatcherFactory.registerBuilder(new NumberMaxBuilder());
        MatcherFactory.registerBuilder(ClassMinMaxBuilder.maxBuilder(Date.class));
    }
}

