/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.openl.binding.IBindingContext;
import org.openl.rules.convertor.IString2DataConverterWithContext;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.util.StringTool;
import org.openl.util.StringUtils;

class String2ArrayConvertor<T>
implements IString2DataConvertor<T[]>,
IString2DataConverterWithContext<T[]> {
    public static final String ARRAY_ELEMENTS_SEPARATOR_ESCAPER = "\\";
    public static final String ARRAY_ELEMENTS_SEPARATOR = ",";
    private Class<T> componentType;

    public String2ArrayConvertor(Class<T> componentType) {
        this.componentType = componentType;
    }

    @Override
    public T[] parse(String data, String format, IBindingContext cxt) {
        if (data == null) {
            return null;
        }
        if (data.length() == 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        String[] elementValues = StringTool.splitAndEscape((String)data, (String)ARRAY_ELEMENTS_SEPARATOR, (String)ARRAY_ELEMENTS_SEPARATOR_ESCAPER);
        ArrayList elements = new ArrayList();
        IString2DataConvertor<T> convertor = String2DataConvertorFactory.getConvertor(this.componentType);
        for (String elementValue : elementValues) {
            Object element;
            if (elementValue.length() == 0) {
                element = null;
            } else if (convertor instanceof IString2DataConverterWithContext) {
                IString2DataConverterWithContext convertorCxt = (IString2DataConverterWithContext)((Object)convertor);
                element = convertorCxt.parse(elementValue, format, cxt);
            } else {
                element = convertor.parse(elementValue, format);
            }
            elements.add(element);
        }
        Object[] resultArray = (Object[])Array.newInstance(this.componentType, elements.size());
        Object[] result = elements.toArray(resultArray);
        return result;
    }

    @Override
    public String format(T[] data, String format) {
        if (data == null) {
            return null;
        }
        IString2DataConvertor<T> converter = String2DataConvertorFactory.getConvertor(this.componentType);
        Object[] elementResults = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            T element = data[i];
            elementResults[i] = converter.format(element, format);
        }
        String result = StringUtils.join((Object[])elementResults, (String)ARRAY_ELEMENTS_SEPARATOR);
        return result;
    }

    @Override
    public T[] parse(String data, String format) {
        if (data == null) {
            return null;
        }
        if (data.length() == 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        String[] elementValues = StringTool.splitAndEscape((String)data, (String)ARRAY_ELEMENTS_SEPARATOR, (String)ARRAY_ELEMENTS_SEPARATOR_ESCAPER);
        ArrayList elements = new ArrayList();
        IString2DataConvertor<T> converter = String2DataConvertorFactory.getConvertor(this.componentType);
        for (String elementValue : elementValues) {
            Object element = elementValue.length() == 0 ? null : (Object)converter.parse(elementValue, format);
            elements.add(element);
        }
        Object[] resultArray = (Object[])Array.newInstance(this.componentType, elements.size());
        Object[] result = elements.toArray(resultArray);
        return result;
    }
}

