/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.lang.reflect.Array;
import org.openl.binding.IBindingContext;
import org.openl.rules.convertor.IString2DataConverterWithContext;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.types.IOpenClass;

class String2ClassConvertor
implements IString2DataConvertor<Class<?>>,
IString2DataConverterWithContext<Class<?>> {
    public static final String ARRAY_SUFIX = "[]";

    String2ClassConvertor() {
    }

    @Override
    public String format(Class<?> data, String format) {
        if (data == null) {
            return null;
        }
        return data.toString();
    }

    @Override
    public Class<?> parse(String data, String format) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> parse(String data, String format, IBindingContext cxt) {
        if (data == null) {
            return null;
        }
        String typeName = data.endsWith(ARRAY_SUFIX) ? data.substring(0, data.length() - 2) : data;
        IOpenClass openClass = cxt.findType("org.openl.this", typeName);
        if (openClass == null) {
            throw new IllegalArgumentException("Type " + data + " is not found");
        }
        Class<?> clazz = openClass.getInstanceClass();
        if (data.endsWith(ARRAY_SUFIX)) {
            clazz = Array.newInstance(clazz, 0).getClass();
        }
        return clazz;
    }
}

