/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.LocaleDependConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class String2DateConvertor
implements IString2DataConvertor<Date> {
    private static final int YEAR_START_COUNT = 1900;
    private final Logger log = LoggerFactory.getLogger(String2DateConvertor.class);

    String2DateConvertor() {
    }

    @Override
    public String format(Date data, String format) {
        if (data == null) {
            return null;
        }
        DateFormat df = format == null ? DateFormat.getDateInstance(3) : new SimpleDateFormat(format);
        return df.format(data);
    }

    @Override
    public Date parse(String data, String format) {
        if (data == null) {
            return null;
        }
        if (data.length() == 0) {
            throw new IllegalArgumentException("Cannot convert an empty String to date type");
        }
        DateFormat df = format == null ? DateFormat.getDateInstance(3, LocaleDependConvertor.getLocale()) : new SimpleDateFormat(format, LocaleDependConvertor.getLocale());
        df.setLenient(false);
        df.getCalendar().set(0, 0, 0, 0, 0, 0);
        df.getCalendar().set(14, 0);
        try {
            return df.parse(data);
        }
        catch (ParseException e) {
            try {
                int value = Integer.parseInt(data);
                Calendar cc = Calendar.getInstance();
                cc.set(1900, 0, 1);
                cc.add(5, value - 1);
                return cc.getTime();
            }
            catch (NumberFormatException t) {
                this.log.debug(t.getMessage(), (Throwable)t);
                throw new IllegalArgumentException("Cannot convert \"" + data + "\" to date type");
            }
        }
    }
}

