/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.text.DecimalFormat;
import org.openl.rules.convertor.String2NumberConverter;

class String2FloatConvertor
extends String2NumberConverter<Float> {
    String2FloatConvertor() {
    }

    @Override
    public String format(Float data, String format) {
        if (data == null) {
            return null;
        }
        double number = Double.parseDouble(Float.toString(data.floatValue()));
        return this.getFormatter(format).format(number);
    }

    @Override
    Float convert(Number number, String data) {
        float value = number.floatValue();
        double dValue = number.doubleValue();
        if (!Double.isInfinite(dValue) && Float.isInfinite(value)) {
            throw new NumberFormatException("A number \"" + data + "\" is out of range.");
        }
        return Float.valueOf(value);
    }

    @Override
    DecimalFormat getFormatter(String format) {
        DecimalFormat formatter = super.getFormatter(format);
        formatter.setMinimumFractionDigits(1);
        return formatter;
    }
}

