/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.util.StringUtils;

public class DatatypeHelper {
    private static final int MAXIMUM_COLUMNS_COUNT = 3;
    private static final int TYPE_NAME_COLUMN = 0;
    private static final int FIELD_NAME_COLUMN = 1;
    private static final int DEFAULTS_COLUMN = 2;

    public static ILogicalTable getNormalizedDataPartTable(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        ILogicalTable dataPart = PropertiesHelper.getPropertiesTableSection(table) != null ? (ILogicalTable)table.getRows(2) : (ILogicalTable)table.getRows(1);
        if (dataPart == null) {
            return null;
        }
        if (dataPart.getHeight() == 1) {
            return dataPart;
        }
        if (dataPart.getWidth() == 1) {
            return (ILogicalTable)dataPart.transpose();
        }
        if (dataPart.getHeight() > 3) {
            return dataPart;
        }
        if (dataPart.getWidth() > 3) {
            return (ILogicalTable)dataPart.transpose();
        }
        if (dataPart.getWidth() == 3 && DatatypeHelper.isThirdColumnForDefaults(dataPart)) {
            return dataPart;
        }
        if (dataPart.getHeight() == 3 && DatatypeHelper.isThirdColumnForDefaults((ILogicalTable)dataPart.transpose())) {
            return (ILogicalTable)dataPart.transpose();
        }
        int verticalCount = DatatypeHelper.countTypes(dataPart, openl, cxt);
        if (verticalCount == dataPart.getHeight() && verticalCount >= dataPart.getWidth()) {
            return dataPart;
        }
        int horizontalCount = DatatypeHelper.countTypes((ILogicalTable)dataPart.transpose(), openl, cxt);
        if (verticalCount < horizontalCount) {
            return (ILogicalTable)dataPart.transpose();
        }
        return dataPart;
    }

    private static boolean isThirdColumnForDefaults(ILogicalTable table) {
        return DatatypeHelper.isDefault(table.getCell(2, 0)) || DatatypeHelper.isDefault(table.getCell(2, 1));
    }

    private static boolean isDefault(ICell cell) {
        String value = cell.getStringValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        char firstChar = value.charAt(0);
        return '0' <= firstChar && firstChar <= '9';
    }

    private static int countTypes(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        int height = table.getHeight();
        int count = 1;
        for (int i = 1; i < height; ++i) {
            try {
                IOpenClass type = DatatypeHelper.makeType((ILogicalTable)table.getRow(i), openl, cxt);
                if (type == null) continue;
                ++count;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return count;
    }

    private static IOpenClass makeType(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), cxt);
        return OpenLManager.makeType((OpenL)openl, (IOpenSourceCodeModule)source, (IBindingContextDelegator)((IBindingContextDelegator)cxt));
    }

    public static String getDatatypeName(TableSyntaxNode tsn) throws OpenLCompilationException {
        if (XlsNodeTypes.XLS_DATATYPE.equals((Object)tsn.getNodeType())) {
            IOpenSourceCodeModule src = tsn.getHeader().getModule();
            IdentifierNode[] parsedHeader = DatatypeHelper.tokenizeHeader(src);
            return parsedHeader[1].getIdentifier();
        }
        return null;
    }

    public static IdentifierNode[] tokenizeHeader(IOpenSourceCodeModule tableHeader) throws OpenLCompilationException {
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)tableHeader, (String)" \n\r");
        if (parsedHeader.length < 2) {
            String message = "Datatype table format: Datatype <typename>";
            throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)tableHeader);
        }
        return parsedHeader;
    }
}

