/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.IMetaInfo;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.datatype.binding.DatatypeHelper;
import org.openl.rules.datatype.gen.ByteCodeGeneratorHelper;
import org.openl.rules.datatype.gen.DefaultFieldDescription;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.RecursiveFieldDescription;
import org.openl.rules.datatype.gen.SimpleBeanByteCodeGenerator;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.utils.ParserUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.DatatypeOpenField;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.impl.InternalDatatypeClass;
import org.openl.util.StringTool;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;
import org.openl.util.text.TextInterval;

public class DatatypeTableBoundNode
implements IMemberBoundNode {
    private TableSyntaxNode tableSyntaxNode;
    private DatatypeOpenClass dataType;
    private IdentifierNode parentClassIdentifier;
    private String parentClassName;
    private ModuleOpenClass moduleOpenClass;
    private ILogicalTable table;
    private OpenL openl;

    public DatatypeTableBoundNode(TableSyntaxNode tableSyntaxNode, DatatypeOpenClass datatype, ModuleOpenClass moduleOpenClass, ILogicalTable table, OpenL openl) {
        this(tableSyntaxNode, datatype, moduleOpenClass, table, openl, null);
    }

    public DatatypeTableBoundNode(TableSyntaxNode tableSyntaxNode, DatatypeOpenClass datatype, ModuleOpenClass moduleOpenClass, ILogicalTable table, OpenL openl, IdentifierNode parentClassIdentifier) {
        this.tableSyntaxNode = tableSyntaxNode;
        this.dataType = datatype;
        this.table = table;
        this.openl = openl;
        this.parentClassIdentifier = parentClassIdentifier;
        this.parentClassName = parentClassIdentifier != null ? parentClassIdentifier.getIdentifier() : this.parentClassName;
        this.moduleOpenClass = moduleOpenClass;
    }

    private void addFields(IBindingContext cxt) throws Exception {
        ILogicalTable dataTable = DatatypeHelper.getNormalizedDataPartTable(this.table, this.openl, cxt);
        int tableHeight = 0;
        if (dataTable != null) {
            tableHeight = dataTable.getHeight();
        }
        LinkedHashMap<String, FieldDescription> fields = new LinkedHashMap<String, FieldDescription>();
        for (int i = 0; i < tableHeight; ++i) {
            ILogicalTable row = (ILogicalTable)dataTable.getRow(i);
            boolean firstField = i == 0;
            this.processRow(row, cxt, fields, firstField);
        }
        this.checkInheritedFieldsDuplication(cxt);
        if (this.beanClassCanBeGenerated(cxt)) {
            Class<?> beanClass = this.createBeanForDatatype(fields);
            this.dataType.setInstanceClass(beanClass);
            this.validateBeanForDatatype(beanClass, fields);
        }
    }

    private boolean beanClassCanBeGenerated(IBindingContext cxt) {
        IOpenClass parentClass;
        if (this.tableSyntaxNode.hasErrors()) {
            return false;
        }
        return this.parentClassName == null || (parentClass = cxt.findType("org.openl.this", this.parentClassName)).getInstanceClass() != null;
    }

    private Class<?> createBeanForDatatype(Map<String, FieldDescription> fields) throws SyntaxNodeException {
        SimpleBeanByteCodeGenerator beanGenerator;
        String datatypeName = this.dataType.getName();
        String beanName = this.getDatatypeBeanNameWithNamespace(datatypeName);
        IOpenClass superClass = this.dataType.getSuperClass();
        if (superClass != null) {
            Map<String, FieldDescription> parentFields = ByteCodeGeneratorHelper.convertFields(superClass.getFields());
            beanGenerator = new SimpleBeanByteCodeGenerator(beanName, fields, superClass.getInstanceClass(), parentFields);
        } else {
            beanGenerator = new SimpleBeanByteCodeGenerator(beanName, fields);
        }
        try {
            return beanGenerator.generateAndLoadBeanClass();
        }
        catch (RuntimeException e) {
            String errorMessage = String.format("Can't generate bean for datatype '%s': %s", datatypeName, e.getMessage());
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (Throwable)e, (ISyntaxNode)this.tableSyntaxNode);
        }
    }

    private void validateBeanForDatatype(Class<?> beanClass, Map<String, FieldDescription> fields) throws SyntaxNodeException {
        String datatypeName = this.dataType.getName();
        String beanName = this.getDatatypeBeanNameWithNamespace(datatypeName);
        IOpenClass superClass = this.dataType.getSuperClass();
        if (superClass != null && !beanClass.getSuperclass().equals(superClass.getInstanceClass())) {
            String errorMessage = String.format("Class '%s' is found in classloader. This class has invalid parent class. Please, regenerate your datatype classes.", datatypeName);
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode);
        }
        for (Map.Entry<String, FieldDescription> fieldEntry : fields.entrySet()) {
            String errorMessage;
            String fieldName = fieldEntry.getKey();
            FieldDescription fieldDescription = fieldEntry.getValue();
            try {
                beanClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                String errorMessage2 = String.format("Class '%s' is found in classloader. Field '%s' is missed. Please, regenerate your datatype classes.", beanName, fieldName);
                throw SyntaxNodeExceptionUtils.createError((String)errorMessage2, (ISyntaxNode)this.tableSyntaxNode);
            }
            String getterMethodName = StringTool.getGetterName((String)fieldName);
            try {
                Method getterMethod = beanClass.getMethod(getterMethodName, new Class[0]);
                if (!getterMethod.getReturnType().getCanonicalName().equals(fieldDescription.getCanonicalTypeName())) {
                    errorMessage = String.format("Class '%s' is found in classloader. Method '%s' returns invalid type. Please, regenerate your datatype classes.", beanName, getterMethodName);
                    throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode);
                }
            }
            catch (NoSuchMethodException e) {
                errorMessage = String.format("Class '%s' is found in classloader. Method '%s' is missed. Please, regenerate your datatype classes.", beanName, getterMethodName);
                throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode);
            }
            String setterMethodName = StringTool.getSetterName((String)fieldName);
            Method[] methods = beanClass.getMethods();
            boolean found = false;
            for (Method method : methods) {
                if (!method.getName().equals(setterMethodName) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].getCanonicalName().equals(fieldDescription.getCanonicalTypeName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            String errorMessage3 = String.format("Class '%s' is found in classloader. Method '%s(%s)' is missed. Please, regenerate your datatype classes.", beanName, setterMethodName, fieldDescription.getCanonicalTypeName());
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage3, (ISyntaxNode)this.tableSyntaxNode);
        }
    }

    private String getDatatypeBeanNameWithNamespace(String datatypeName) {
        return String.format("%s.%s", this.tableSyntaxNode.getTableProperties().getPropertyValue("datatypePackage"), datatypeName);
    }

    private void processRow(ILogicalTable row, IBindingContext cxt, Map<String, FieldDescription> fields, boolean firstField) throws OpenLCompilationException {
        GridCellSourceCodeModule rowSrc = new GridCellSourceCodeModule(row.getSource(), cxt);
        if (DatatypeTableBoundNode.canProcessRow(rowSrc)) {
            FieldDescription fieldDescription;
            String fieldName = this.getName(row, cxt);
            IOpenClass fieldType = this.getFieldType(cxt, row, rowSrc);
            DatatypeOpenField field = new DatatypeOpenField((IOpenClass)this.dataType, fieldName, fieldType);
            if (!cxt.isExecutionMode()) {
                IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)rowSrc, (String)"[]\n\r");
                IMetaInfo metaInfo = fieldType.getMetaInfo();
                if (metaInfo == null) {
                    metaInfo = DatatypeTableBoundNode.getRootComponentClass(fieldType).getMetaInfo();
                }
                RuleRowHelper.setCellMetaInfoWithNodeUsage(row, parsedHeader[0], metaInfo, NodeType.DATATYPE);
            }
            if (!this.isRecursiveField((IOpenField)field) && DatatypeTableBoundNode.getRootComponentClass(field.getType()).getInstanceClass() == null) {
                GridCellSourceCodeModule cellSource = DatatypeTableBoundNode.getCellSource(row, cxt, 0);
                TextInterval location = LocationUtils.createTextInterval((String)cellSource.getCode());
                String message = "Type " + DatatypeTableBoundNode.getRootComponentClass(field.getType()).getName() + " isn't generated yet";
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ILocation)location, (IOpenSourceCodeModule)cellSource);
            }
            try {
                this.dataType.addField((IOpenField)field);
                if (firstField) {
                    this.dataType.setIndexField((IOpenField)field);
                }
                fieldDescription = this.fieldDescriptionFactory((IOpenField)field);
                fields.put(fieldName, fieldDescription);
            }
            catch (Throwable t) {
                throw SyntaxNodeExceptionUtils.createError((String)t.getMessage(), (Throwable)t, null, (IOpenSourceCodeModule)DatatypeTableBoundNode.getCellSource(row, cxt, 1));
            }
            if (row.getWidth() > 2) {
                Object value;
                String defaultValue = this.getDefaultValue(row, cxt);
                fieldDescription.setDefaultValueAsString(defaultValue);
                if (fieldDescription.getType().equals(Date.class) && (value = ((ILogicalTable)row.getColumn(2)).getCell(0, 0).getObjectValue()) != null && fieldDescription.getType().equals(value.getClass())) {
                    RuleRowHelper.setCellMetaInfo((ILogicalTable)row.getColumn(2), null, fieldType, false);
                    fieldDescription.setDefaultValue(value);
                }
                try {
                    value = fieldDescription.getDefaultValue();
                }
                catch (RuntimeException e) {
                    String message = String.format("Cannot parse cell value '%s'", defaultValue);
                    GridCellSourceCodeModule cellSourceCodeModule = DatatypeTableBoundNode.getCellSource(row, cxt, 2);
                    if (e instanceof CompositeSyntaxNodeException) {
                        CompositeSyntaxNodeException exception = (CompositeSyntaxNodeException)((Object)e);
                        if (exception.getErrors() != null && exception.getErrors().length == 1) {
                            SyntaxNodeException syntaxNodeException = exception.getErrors()[0];
                            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ILocation)syntaxNodeException.getLocation(), (IOpenSourceCodeModule)cellSourceCodeModule);
                        }
                        throw SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)cellSourceCodeModule);
                    }
                    TextInterval location = defaultValue == null ? null : LocationUtils.createTextInterval((String)defaultValue);
                    throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ILocation)location, (IOpenSourceCodeModule)cellSourceCodeModule);
                }
                if (!(value == null || fieldDescription.hasDefaultKeyWord() && fieldDescription.getType().isArray())) {
                    try {
                        RuleRowHelper.validateValue(value, fieldType);
                    }
                    catch (Exception e) {
                        throw SyntaxNodeExceptionUtils.createError((String)e.getMessage(), (Throwable)e, null, (IOpenSourceCodeModule)DatatypeTableBoundNode.getCellSource(row, cxt, 2));
                    }
                }
            }
        }
    }

    private FieldDescription fieldDescriptionFactory(IOpenField field) {
        if (this.isRecursiveField(field)) {
            return new RecursiveFieldDescription(field);
        }
        return new DefaultFieldDescription(field);
    }

    private boolean isRecursiveField(IOpenField field) {
        IOpenClass fieldType = DatatypeTableBoundNode.getRootComponentClass(field.getType());
        return fieldType.getName().equals(this.dataType.getName());
    }

    public static IOpenClass getRootComponentClass(IOpenClass fieldType) {
        if (!fieldType.isArray()) {
            return fieldType;
        }
        return DatatypeTableBoundNode.getRootComponentClass(fieldType.getComponentClass());
    }

    private String getName(ILogicalTable row, IBindingContext cxt) throws OpenLCompilationException {
        GridCellSourceCodeModule nameCellSource = DatatypeTableBoundNode.getCellSource(row, cxt, 1);
        IdentifierNode[] idn = DatatypeTableBoundNode.getIdentifierNode(nameCellSource);
        if (idn.length != 1) {
            String errorMessage = String.format("Bad field name: %s", nameCellSource.getCode());
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, null, null, (IOpenSourceCodeModule)nameCellSource);
        }
        return idn[0].getIdentifier();
    }

    public static GridCellSourceCodeModule getCellSource(ILogicalTable row, IBindingContext cxt, int columnIndex) {
        return new GridCellSourceCodeModule(((ILogicalTable)row.getColumn(columnIndex)).getSource(), cxt);
    }

    private String getDefaultValue(ILogicalTable row, IBindingContext cxt) throws OpenLCompilationException {
        IdentifierNode[] idn;
        String defaultValue = null;
        GridCellSourceCodeModule defaultValueSrc = DatatypeTableBoundNode.getCellSource(row, cxt, 2);
        if (!ParserUtils.isCommented(defaultValueSrc.getCode()) && (idn = DatatypeTableBoundNode.getIdentifierNode(defaultValueSrc)).length > 0) {
            defaultValue = defaultValueSrc.getCode();
        }
        return defaultValue;
    }

    public static IdentifierNode[] getIdentifierNode(GridCellSourceCodeModule cellSrc) throws OpenLCompilationException {
        return Tokenizer.tokenize((IOpenSourceCodeModule)cellSrc, (String)" \r\n");
    }

    public static boolean canProcessRow(ILogicalTable row, IBindingContext cxt) {
        GridCellSourceCodeModule rowSrc = new GridCellSourceCodeModule(row.getSource(), cxt);
        return DatatypeTableBoundNode.canProcessRow(rowSrc);
    }

    public static boolean canProcessRow(GridCellSourceCodeModule rowSrc) {
        return !ParserUtils.isBlankOrCommented(rowSrc.getCode());
    }

    private IOpenClass getFieldType(IBindingContext cxt, ILogicalTable row, GridCellSourceCodeModule tableSrc) throws SyntaxNodeException {
        IOpenClass fieldType = OpenLManager.makeType((OpenL)this.openl, (IOpenSourceCodeModule)tableSrc, (IBindingContextDelegator)((IBindingContextDelegator)cxt));
        if (fieldType == null || fieldType instanceof NullOpenClass) {
            String errorMessage = String.format("Type %s is not found", tableSrc.getCode());
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, null, null, (IOpenSourceCodeModule)tableSrc);
        }
        if (row.getWidth() < 2) {
            String errorMessage = "Bad table structure: must be {header} / {type | name}";
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, null, null, (IOpenSourceCodeModule)tableSrc);
        }
        return fieldType;
    }

    public void addTo(ModuleOpenClass openClass) {
        InternalDatatypeClass internalClassMember = new InternalDatatypeClass((IOpenClass)this.dataType, (IOpenClass)openClass);
        this.tableSyntaxNode.setMember((IOpenMember)internalClassMember);
    }

    public void finalizeBind(IBindingContext cxt) throws Exception {
        if (this.parentClassName != null) {
            IOpenClass parentClass = cxt.findType("org.openl.this", this.parentClassName);
            if (parentClass == null) {
                cxt.removeType("org.openl.this", (IOpenClass)this.dataType);
                throw new OpenLCompilationException(String.format("Parent class '%s' is not defined", this.parentClassName));
            }
            if (parentClass.getInstanceClass() != null) {
                if (Modifier.isFinal(parentClass.getInstanceClass().getModifiers())) {
                    cxt.removeType("org.openl.this", (IOpenClass)this.dataType);
                    throw new OpenLCompilationException(String.format("Cannot inherit from final class \"%s\"", this.parentClassName));
                }
                if (Modifier.isAbstract(parentClass.getInstanceClass().getModifiers())) {
                    cxt.removeType("org.openl.this", (IOpenClass)this.dataType);
                    throw new OpenLCompilationException(String.format("Cannot inherit from abstract class \"%s\"", this.parentClassName));
                }
            }
            if (parentClass instanceof DomainOpenClass) {
                cxt.removeType("org.openl.this", (IOpenClass)this.dataType);
                throw new OpenLCompilationException(String.format("Parent class '%s' cannot be domain type", this.parentClassName));
            }
            this.dataType.setSuperClass(parentClass);
            if (!cxt.isExecutionMode()) {
                RuleRowHelper.setCellMetaInfoWithNodeUsage(this.table, this.parentClassIdentifier, parentClass.getMetaInfo(), NodeType.DATATYPE);
            }
        }
        this.addFields(cxt);
        if (this.dataType.getFields().size() > 0) {
            this.dataType.addMethod(new DatatypeOpenClass.OpenFieldsConstructor((IOpenClass)this.dataType));
        }
        this.moduleOpenClass.addType("org.openl.this", (IOpenClass)this.dataType);
    }

    private void checkInheritedFieldsDuplication(IBindingContext cxt) throws Exception {
        IOpenClass superClass = this.dataType.getSuperClass();
        if (superClass != null) {
            for (Map.Entry<String, IOpenField> field : this.dataType.getDeclaredFields().entrySet()) {
                IOpenField fieldInParent = superClass.getField(field.getKey());
                if (fieldInParent == null) continue;
                if (fieldInParent.getType().getInstanceClass().equals(field.getValue().getType().getInstanceClass())) {
                    BindHelper.processWarn((String)String.format("Field [%s] has been already defined in class \"%s\"", field.getKey(), fieldInParent.getDeclaringClass().getDisplayName(0)), (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                    continue;
                }
                throw SyntaxNodeExceptionUtils.createError((String)String.format("Field [%s] has been already defined in class \"%s\" with another type", field.getKey(), fieldInParent.getDeclaringClass().getDisplayName(0)), (ISyntaxNode)this.tableSyntaxNode);
            }
        }
    }

    public void removeDebugInformation(IBindingContext cxt) throws Exception {
    }
}

