/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import java.util.LinkedHashSet;
import java.util.Set;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.datatype.binding.DatatypeHelper;
import org.openl.rules.datatype.binding.DatatypeTableBoundNode;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.util.StringUtils;

class DependentTypesExtractor {
    public static final String ALIASDATATYPE_PATTERN = "^.+\\<.+\\>\\s*$";

    DependentTypesExtractor() {
    }

    private boolean isAliasDatatype(TableSyntaxNode node) {
        String header = node.getHeader().getSourceString();
        return header.matches(ALIASDATATYPE_PATTERN);
    }

    public Set<String> extract(TableSyntaxNode node, IBindingContext cxt) {
        ILogicalTable dataPart = DatatypeHelper.getNormalizedDataPartTable(node.getTable(), OpenL.getInstance((String)"org.openl.rules.java"), cxt);
        int tableHeight = 0;
        if (dataPart != null) {
            tableHeight = dataPart.getHeight();
        }
        LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
        if (this.isAliasDatatype(node)) {
            return dependencies;
        }
        String parentType = this.getParentDatatypeName(node);
        if (StringUtils.isNotBlank((CharSequence)parentType)) {
            dependencies.add(parentType);
        }
        for (int i = 0; i < tableHeight; ++i) {
            String typeName;
            ILogicalTable row = (ILogicalTable)dataPart.getRow(i);
            if (!DatatypeTableBoundNode.canProcessRow(row, cxt) || !StringUtils.isNotBlank((CharSequence)(typeName = this.getType(row, cxt)))) continue;
            dependencies.add(typeName);
        }
        return dependencies;
    }

    private String getParentDatatypeName(TableSyntaxNode tsn) {
        if (XlsNodeTypes.XLS_DATATYPE.equals((Object)tsn.getNodeType())) {
            IOpenSourceCodeModule src = tsn.getHeader().getModule();
            IdentifierNode[] parsedHeader = new IdentifierNode[]{};
            try {
                parsedHeader = DatatypeHelper.tokenizeHeader(src);
            }
            catch (OpenLCompilationException openLCompilationException) {
                // empty catch block
            }
            if (parsedHeader.length == 4) {
                return parsedHeader[3].getIdentifier();
            }
            return null;
        }
        return null;
    }

    private String getType(ILogicalTable row, IBindingContext cxt) {
        GridCellSourceCodeModule typeSrc = DatatypeTableBoundNode.getCellSource(row, cxt, 0);
        IdentifierNode[] idn = new IdentifierNode[]{};
        try {
            idn = DatatypeTableBoundNode.getIdentifierNode(typeSrc);
        }
        catch (OpenLCompilationException openLCompilationException) {
            // empty catch block
        }
        if (idn.length == 1) {
            String type = idn[0].getIdentifier();
            if (type.contains("[")) {
                type = type.substring(0, type.indexOf("["));
            }
            return type;
        }
        return null;
    }
}

